<?php
namespace Resrequest\Authentication\Factory;

use Resrequest\Authentication\Adapter\ApigilityAuthenticationAdapter;
use Zend\Authentication\AuthenticationService;
use Zend\Authentication\Storage\Session;
use Zend\Authentication\Storage\StorageInterface;

class AuthenticationServiceFactory
{
	public function __invoke($serviceLocator)
	{
		$adapter = $serviceLocator->get(ApigilityAuthenticationAdapter::class);
		$sessionManager = $serviceLocator->get('Zend\Session\SessionManager');
		$storage = $sessionManager->getStorage();
		$authenticationService = new AuthenticationService($storage);
		
		$authenticationService->setAdapter($adapter);
		return $authenticationService;
	}
}
