<?php

namespace Resrequest\Authentication\Factory;

use Zend\ServiceManager\FactoryInterface;
use Zend\ServiceManager\ServiceLocatorInterface;
use Resrequest\Authentication\Service\Password;

class PasswordFactory implements FactoryInterface
{
	public function createService(ServiceLocatorInterface $serviceLocator)
	{
		$entityManager = $serviceLocator->get('EnterpriseEntityManager');
		$enterpriseDatabase = $serviceLocator->get('Resrequest\DB\Service\EnterpriseDatabaseService');
		$passwordService = new Password($entityManager, $enterpriseDatabase);
		return $passwordService;
	}
}
