<?php

namespace Resrequest\Authorisation;

use Zend\Mvc\MvcEvent;
use Zend\Console\Console;
use Zend\Permissions\Acl\Acl;
use Resrequest\Authorisation\Listener\AclListener;
use Resrequest\Authorisation\Service\AuthoriseService;
use Resrequest\Authorisation\Service\AclService;
use Resrequest\Authentication\Factory\AuthenticationServiceFactory;

class Module {

    public function onBootstrap(MvcEvent $e) {
        return $this;
    }

    public function getConfig() {
        return include __DIR__ . '/config/module.config.php';
    }

    public function getAutoloaderConfig()
    {
        return array(
            'Zend\Loader\StandardAutoloader' => array(
                'namespaces' => array(
                    __NAMESPACE__ => __DIR__ . '/src/' . str_replace("\\", "/", __NAMESPACE__),
                ),
            ),
        );
    }

    public function getServiceConfig()
    {
        return array(
            'factories' => array(
                'AclService' => function($sm) {
                    $em = $sm->get('EnterpriseEntityManager');
                    $authoriseService = $sm->get('Resrequest\Authorisation\Service\AuthoriseService');
                    $globalConfig = $sm->get('config');
                    $service = new AclService(new Acl(), $em, $authoriseService, $globalConfig);

                    return $service;
                },
                'AclListener' => function($sm) {
                    $aclService = $sm->get('AclService');
                    $authenticateService = $sm->get('Resrequest\Authentication\Service\Authenticate');
                    $authoriseService = $sm->get('Resrequest\Authorisation\Service\AuthoriseService');
                    $entityManager = $sm->get('EnterpriseEntityManager');
                    $globalConfig = $sm->get('config');
                    $publicRouteNames = $globalConfig['enterprise']['public_route_names'];
                    return new AclListener($aclService, $authenticateService, $authoriseService, $entityManager, $publicRouteNames);
                },
                'Resrequest\Authorisation\Service\AuthoriseService' => function($sm) {
                    return new AuthoriseService($sm->get('EnterpriseEntityManager'));
                },
            ),
        );
    }
}
