<?php

namespace Resrequest\Authorisation\Listener;

use Zend\EventManager\AbstractListenerAggregate;
use Zend\EventManager\EventManagerInterface;
use Zend\Mvc\MvcEvent;
use Resrequest\Authorisation\Service\AclService;
use Resrequest\Authorisation\Service\AuthoriseService;
use Resrequest\Authentication\Service\Authenticate;

class AclListener extends AbstractListenerAggregate {

    private $aclService;
    private $authenticationService;
    private $authorisationService;
    private $publicRouteNames;
    protected $connection;

    public function __construct(
        AclService $aclService,
        Authenticate $authenticationService, 
        AuthoriseService $authorisationService,
        $entityManager,
        $publicRouteNames
    ) {
        $this->aclService = $aclService;
        $this->authenticationService = $authenticationService;
        $this->authorisationService = $authorisationService;
        $this->connection = $entityManager->getConnection();
        
        $this->publicRouteNames = $publicRouteNames;
    }

    public function attach(EventManagerInterface $eventManager) {
        $this->listeners[] = $eventManager->attach(MvcEvent::EVENT_ROUTE, array($this, 'checkAcl'), -1000);
    }

    public function checkAcl(MvcEvent $e) {
        $request = $e->getRequest();
        $requestUri = $request->getRequestUri();
        $matchedRouteName = $e->getRouteMatch()->getMatchedRouteName();
        $queryArray = explode("?", $requestUri);
        $scriptName = !empty($queryArray) ? $queryArray[0]: "";
        $argv = isset($queryArray[1]) ? explode("+", $queryArray[1]) : "";
        $userId = isset($_SESSION['userid'])?$_SESSION['userid']:"";
        $userDetails = $this->authenticationService->getUserById($userId);
        $role = !empty($userDetails) && isset($userDetails['sc_group_id']) ? $userDetails['sc_group_id'] : $this->aclService::PUBLIC_ACCESS_GROUP;
        $routeAllowed = true;

        if ($matchedRouteName == "reservation.php") {
            if (isset($argv[0])) {
                $jobId = $argv[0];
                if ($jobId != 999) {
                    if ($this->getAclService()->isJobAllowed($role, (int)$jobId) == false) {
                        $routeAllowed = false;
                    }
                }
            } else {
                $routeAllowed = false;
            }
        } elseif($this->isPublicRoute($matchedRouteName)) {
            $routeAllowed = true;
        } else {
            if ($this->getAclService()->isRouteAllowed($role, $scriptName) === false) {
                $routeAllowed = false;
            }
        }
        if ($routeAllowed === false) {
            $response = $e->getResponse();
            $response->setStatusCode(302);
            $response->getHeaders()->addHeaderLine('Location', '/reservation.php?999');
            $e->stopPropagation();
        }
        return $this;
    }

    private function isPublicRoute($routeName) {
        foreach($this->publicRouteNames as $publicRouteName) {
            $publicRouteName = '/' . $publicRouteName . '/';
            if (preg_match($publicRouteName, $routeName)) {
                return true;
            }
        }
        return false;
    }

    private function getAclService() {
        return $this->aclService;
    }

    private function getauthenticationService() {
        return $this->authenticationService;
    }
}
