<?php
namespace Resrequest\DB;

use Zend\Console\Request as ConsoleRequest;
use Zend\Console\Console;
use Resrequest\DB\Service\EnterpriseDatabaseService;

class Module
{
    public function onBootstrap($e)
    {
        $application = $e->getTarget();
        $sm = $application->getServiceManager();
    }

    public function getDoctrineConfiguration() {
        if (Console::isConsole()) {
            /*
                Hack to get Doctrine migrations working, since it only
                uses 'orm_default' connection.
                
                The command 'resrequest:enterprise:upgradedb' sets
                the DB name (obtained from the first parameter)
                as an environment variable and executes
                the command 'migrations:migrate'.
            */
            
            if (getenv('DB_NAME') !== false) {
                $databaseName = getenv('DB_NAME'); // Get database name from environment variable
                
                $config = array( // Configure Doctrine connection
                    'doctrine' => array(
                        'connection' => array(
                            'orm_default' => array(
                                'driverClass' => 'Doctrine\DBAL\Driver\PDOMySql\Driver',
                                'params' => array(
                                    'host' => 'localhost',
                                    'user' => 'root',
                                    'password' => '',
                                    'dbname' => $databaseName,
                                ),
                            ),
                        ),
                        'migrations_configuration' => array(
                            'orm_default' => array(
                                'directory' => __DIR__ . '/src/Resrequest/DB/Enterprise/Migrations',
                                'namespace' => 'Resrequest\DB\Enterprise\Migrations',
                                'table' => 'rf_migrations',
                            ),
                        ),
                    )
                );
            } else {
                /*
                Empty Doctrine configuration for console commands
                that don't need to use the Enterprise database
                */
                $config = array(
                    'doctrine' => array(
                        'connection' => array(
                            'orm_default' => array(
                                'driverClass' => 'Doctrine\DBAL\Driver\PDOMySql\Driver',
                                'params' => array(
                                    'host' => 'localhost',
                                    'user' => 'root',
                                    'password' => '',
                                    'dbname' => 'mysql',
                                ),
                            ),
                        ),
                        'migrations_configuration' => array(
                            'orm_default' => array(
                                'directory' => __DIR__ . '/src/Resrequest/DB/Enterprise/Migrations',
                                'namespace' => 'Resrequest\DB\Enterprise\Migrations',
                            ),
                        ),
                    )
                );
            }
            return $config;
        } else {
            return array(
                'doctrine' => array(
                    'connection' => array(
                        'orm_enterprise' => array(
                            'params' => array(
                                'dbname' => $GLOBALS['dbName'],
                            )
                        )
                    )
                )
            );
        }
    }

    public function getConfig()
    {   
        $doctrineConfig = array();
        $doctrineConfig = $this->getDoctrineConfiguration();

        $modulesConfig = include __DIR__ . '/config/module.config.php';
        return array_merge_recursive($doctrineConfig, $modulesConfig);
    }

    public function getServiceConfig() {
        return array(
            'factories' => array(
                'EnterpriseEntityManager' =>  'Resrequest\DB\Factory\EnterpriseEntityManagerFactory',
                'Resrequest\DB\Service\EnterpriseDatabaseService' => function($sm) {
                    $em = $sm->get('EnterpriseEntityManager');
                    return new EnterpriseDatabaseService($sm, $em);
                },
            ),
        );
    }

    public function getAutoloaderConfig()
    {
        return array(
            'Zend\Loader\StandardAutoloader' => array(
                'namespaces' => array(
                    __NAMESPACE__=>  __DIR__ . '/src/Resrequest/DB',
                ),
            ),
        );
    }
}
