<?php

return array(
	'doctrine' => array(
		'connection' => array(
			'orm_enterprise' => array(
				'driverClass' => 'Doctrine\DBAL\Driver\PDOMySql\Driver',
				'params' => array(
					'host' => 'localhost',
					'user' => 'root',
					'password' => '',
				),
			),
			'orm_censys' => array(
				'driverClass' => 'Doctrine\DBAL\Driver\PDOMySql\Driver',
				'params' => array(
					'host' => 'localhost',
					'user' => 'root',
					'password' => '',
					'dbname' => 'censys',
				),
			),
		),
		'entitymanager' => array(
			'orm_enterprise' => array(
				'connection'    => 'orm_enterprise',
				'configuration' => 'orm_default'
			),
			'orm_censys' => array(
				'connection'    => 'orm_censys',
				'configuration' => 'orm_default'
			),
		),
		'migrations_configuration' => array(
			'orm_enterprise' => array(
				'directory' => __DIR__ . '/DB/src/Resrequest/DB/Enterprise/Migrations',
				'namespace' => 'Resrequest\DB\Enterprise\Migrations',
				'table' => 'rf_migrations',
			),
			'orm_censys' => array(
				'directory' => __DIR__ . '/DB/src/Resrequest/DB/Censys/Migrations',
				'namespace' => 'Resrequest\DB\Censys\Migrations',
				'table' => 'cn_migrations',
			),
		),
		'configuration' => [
			'orm_default' => [
				'string_functions' => [
					'MONTH' => 'DoctrineExtensions\Query\Mysql\Month',
					'YEAR' => 'DoctrineExtensions\Query\Mysql\Year',
					'DAY' => 'DoctrineExtensions\Query\Mysql\Day',
					'DATEDIFF' => 'DoctrineExtensions\Query\Mysql\DateDiff',
					'NOW' => 'DoctrineExtensions\Query\Mysql\Now',
					'IF' => 'DoctrineExtensions\Query\Mysql\IfElse',
				]
			]
		],
		'driver' => array(
			'DB_driver' => array(
				'class' => 'Doctrine\ORM\Mapping\Driver\AnnotationDriver',
				'cache' => 'array',
				'paths' => array(
					__DIR__ . '/../src/Resrequest/DB/Enterprise/Entity',
					// __DIR__ . '/../src/Resrequest/DB/Censys/Entity' // Uncomment when entities for the censys DB have been added
				)
			),
			'orm_default' => array(
				'drivers' => array(
					'Resrequest\DB\Enterprise\Entity' => 'DB_driver',
					'Resrequest\DB\Censys\Entity' => 'DB_driver'
				),
			),
		),
	),
	'enterprise' => array(
		'enterprise_database' => array(
			'sql_path' => '/module/Resrequest/DB/src/Resrequest/DB/Enterprise/Sql',
			'default_environment' => 'RS',
			'sc_tables' => array(
				'sc_function',
				'sc_job',
				'sc_fun_job',
				'sc_menu',
				'sc_menu_format',
				'sc_transfer',
				'tc_table',
				'pf_object',
				'rf_link_type',
				'pg_method',
				'pg_type',
				'pg_type_obj',
				'fn_system',
				'fn_option',
				'fn_system_option',
				'ad_module_field',
				'rf_audit_module',
				'pr_social',
				'oauth_clients',
				'rf_obj_registration_card'
			),
		),
	),
);