<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * AcAccommBlock
 *
 * @ORM\Table(name="ac_accomm_block", indexes={@ORM\Index(name="ac_accomm_block_trf_yn", columns={"ac_accomm_block_trf_yn"}), @ORM\Index(name="ac_accomm_type_id", columns={"ac_accomm_type_id"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})}, options={"engine"="InnoDB", "collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}), uniqueConstraints={@ORM\UniqueConstraint(name="ac_accomm_block_ix", columns={"ac_accomm_block_ix"})})
 * @ORM\Entity
 */
class AcAccommBlock
{
    /**
     * @var string
     *
     * @ORM\Column(name="ac_accomm_block_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $acAccommBlockIx;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_accomm_block_db", type="string", nullable=false, length=2, options={"default"="", "fixed"="true"})
     */
    private $acAccommBlockDb = '';

    /**
     * @var integer
     *
     * @ORM\Column(name="ac_accomm_block_id", type="integer", nullable=false, nullable=false)
     */
    private $acAccommBlockId;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_accomm_type_id", type="string", length=36, nullable=true)
     */
    private $acAccommTypeId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ac_start_date", type="date", nullable=false, options={"default"="0000-00-00"})
     */
    private $acStartDate;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ac_end_date", type="date", nullable=false, options={"default"="0000-00-00"})
     */
    private $acEndDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_reason", type="string", length=255, nullable=true)
     */
    private $acReason;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_type_ind", type="boolean", nullable=false, options={"default"="1"})
     */
    private $acTypeInd;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="ac_accomm_block_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $acAccommBlockTrfYn;



    /**
     * Get acAccommBlockIx
     *
     * @return string
     */
    public function getAcAccommBlockIx()
    {
        return $this->acAccommBlockIx;
    }

    /**
     * Set acAccommBlockDb
     *
     * @param string $acAccommBlockDb
     *
     * @return AcAccommBlock
     */
    public function setAcAccommBlockDb($acAccommBlockDb)
    {
        $this->acAccommBlockDb = $acAccommBlockDb;

        return $this;
    }

    /**
     * Get acAccommBlockDb
     *
     * @return string
     */
    public function getAcAccommBlockDb()
    {
        return $this->acAccommBlockDb;
    }

    /**
     * Set acAccommBlockId
     *
     * @param integer $acAccommBlockId
     *
     * @return AcAccommBlock
     */
    public function setAcAccommBlockId($acAccommBlockId)
    {
        $this->acAccommBlockId = $acAccommBlockId;

        return $this;
    }

    /**
     * Get acAccommBlockId
     *
     * @return integer
     */
    public function getAcAccommBlockId()
    {
        return $this->acAccommBlockId;
    }

    /**
     * Set acAccommTypeId
     *
     * @param string $acAccommTypeId
     *
     * @return AcAccommBlock
     */
    public function setAcAccommTypeId($acAccommTypeId)
    {
        $this->acAccommTypeId = $acAccommTypeId;

        return $this;
    }

    /**
     * Get acAccommTypeId
     *
     * @return string
     */
    public function getAcAccommTypeId()
    {
        return $this->acAccommTypeId;
    }

    /**
     * Set acStartDate
     *
     * @param \DateTime $acStartDate
     *
     * @return AcAccommBlock
     */
    public function setAcStartDate($acStartDate)
    {
        $this->acStartDate = $acStartDate;

        return $this;
    }

    /**
     * Get acStartDate
     *
     * @return \DateTime
     */
    public function getAcStartDate()
    {
        return $this->acStartDate;
    }

    /**
     * Set acEndDate
     *
     * @param \DateTime $acEndDate
     *
     * @return AcAccommBlock
     */
    public function setAcEndDate($acEndDate)
    {
        $this->acEndDate = $acEndDate;

        return $this;
    }

    /**
     * Get acEndDate
     *
     * @return \DateTime
     */
    public function getAcEndDate()
    {
        return $this->acEndDate;
    }

    /**
     * Set acReason
     *
     * @param string $acReason
     *
     * @return AcAccommBlock
     */
    public function setAcReason($acReason)
    {
        $this->acReason = $acReason;

        return $this;
    }

    /**
     * Get acReason
     *
     * @return string
     */
    public function getAcReason()
    {
        return $this->acReason;
    }

    /**
     * Set acTypeInd
     *
     * @param string $acTypeInd
     *
     * @return AcAccommBlock
     */
    public function setAcTypeInd($acTypeInd)
    {
        $this->acTypeInd = $acTypeInd;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getAcTypeInd()
    {
        return $this->acTypeInd;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return AcAccommBlock
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set acAccommBlockTrfYn
     *
     * @param boolean $acAccommBlockTrfYn
     *
     * @return AcAccommBlock
     */
    public function setAcAccommBlockTrfYn($acAccommBlockTrfYn)
    {
        $this->acAccommBlockTrfYn = $acAccommBlockTrfYn;

        return $this;
    }

    /**
     * Get acAccommBlockTrfYn
     *
     * @return boolean
     */
    public function getAcAccommBlockTrfYn()
    {
        return $this->acAccommBlockTrfYn;
    }
}
