<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * AcAccommImage
 *
 * @ORM\Table(name="ac_accomm_image", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="ac_accomm_image_trf_yn", columns={"ac_accomm_image_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class AcAccommImage
{
    /**
     * @var string
     *
     * @ORM\Column(name="ac_accomm_image_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $acAccommImageIx;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_accomm_image_db", type="string", nullable=false, length=2, options={"default"="", "fixed"="true"})
     */
    private $acAccommImageDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="ac_accomm_image_id", type="integer", nullable=false)
     */
    private $acAccommImageId;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_accomm_image_desc", type="string", length=50, nullable=true, options={"default"=""})
     */
    private $acAccommImageDesc;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_accomm_image_filename", type="string", length=255, nullable=true)
     */
    private $acAccommImageFilename;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_accomm_type_id", type="string", length=36, nullable=true)
     */
    private $acAccommTypeId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="ac_accomm_image_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $acAccommImageTrfYn;



    /**
     * Get acAccommImageIx
     *
     * @return string
     */
    public function getAcAccommImageIx()
    {
        return $this->acAccommImageIx;
    }

    /**
     * Set acAccommImageDb
     *
     * @param string $acAccommImageDb
     *
     * @return AcAccommImage
     */
    public function setAcAccommImageDb($acAccommImageDb)
    {
        $this->acAccommImageDb = $acAccommImageDb;

        return $this;
    }

    /**
     * Get acAccommImageDb
     *
     * @return string
     */
    public function getAcAccommImageDb()
    {
        return $this->acAccommImageDb;
    }

    /**
     * Set acAccommImageId
     *
     * @param integer $acAccommImageId
     *
     * @return AcAccommImage
     */
    public function setAcAccommImageId($acAccommImageId)
    {
        $this->acAccommImageId = $acAccommImageId;

        return $this;
    }

    /**
     * Get acAccommImageId
     *
     * @return integer
     */
    public function getAcAccommImageId()
    {
        return $this->acAccommImageId;
    }

    /**
     * Set acAccommImageDesc
     *
     * @param string $acAccommImageDesc
     *
     * @return AcAccommImage
     */
    public function setAcAccommImageDesc($acAccommImageDesc)
    {
        $this->acAccommImageDesc = $acAccommImageDesc;

        return $this;
    }

    /**
     * Get acAccommImageDesc
     *
     * @return string
     */
    public function getAcAccommImageDesc()
    {
        return $this->acAccommImageDesc;
    }

    /**
     * Set acAccommImageFilename
     *
     * @param string $acAccommImageFilename
     *
     * @return AcAccommImage
     */
    public function setAcAccommImageFilename($acAccommImageFilename)
    {
        $this->acAccommImageFilename = $acAccommImageFilename;

        return $this;
    }

    /**
     * Get acAccommImageFilename
     *
     * @return string
     */
    public function getAcAccommImageFilename()
    {
        return $this->acAccommImageFilename;
    }

    /**
     * Set acAccommTypeId
     *
     * @param string $acAccommTypeId
     *
     * @return AcAccommImage
     */
    public function setAcAccommTypeId($acAccommTypeId)
    {
        $this->acAccommTypeId = $acAccommTypeId;

        return $this;
    }

    /**
     * Get acAccommTypeId
     *
     * @return string
     */
    public function getAcAccommTypeId()
    {
        return $this->acAccommTypeId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return AcAccommImage
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set acAccommImageTrfYn
     *
     * @param boolean $acAccommImageTrfYn
     *
     * @return AcAccommImage
     */
    public function setAcAccommImageTrfYn($acAccommImageTrfYn)
    {
        $this->acAccommImageTrfYn = $acAccommImageTrfYn;

        return $this;
    }

    /**
     * Get acAccommImageTrfYn
     *
     * @return boolean
     */
    public function getAcAccommImageTrfYn()
    {
        return $this->acAccommImageTrfYn;
    }
}
