<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * AcAccommRoom
 *
 * @ORM\Table(name="ac_accomm_room", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="ac_accomm_room_trf_yn", columns={"ac_accomm_room_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})}, uniqueConstraints={@ORM\UniqueConstraint(name="ac_desc", columns={"ac_desc", "ac_accomm_type_id"})})
 * @ORM\Entity
 */
class AcAccommRoom
{
    /**
     * @var string
     *
     * @ORM\Column(name="ac_accomm_room_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $acAccommRoomIx;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_accomm_room_db", type="string", nullable=false, length=2, options={"default"="", "fixed"="true"})
     */
    private $acAccommRoomDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="ac_accomm_room_id", type="integer", nullable=false)
     */
    private $acAccommRoomId;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_accomm_type_id", type="string", length=36, nullable=true)
     */
    private $acAccommTypeId;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_desc", type="string", length=50, nullable=false, options={"default"=""})
     */
    private $acDesc;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ac_accomm_room_create_date", type="date", nullable=false, options={"default"="0000-00-00"})
     */
    private $acAccommRoomCreateDate;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ac_accomm_room_inactive_date", type="date", nullable=false, options={"default"="0000-00-00"})
     */
    private $acAccommRoomInactiveDate;

    /**
     * @var boolean
     *
     * @ORM\Column(name="ac_accomm_room_inactive_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $acAccommRoomInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="ac_accomm_room_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $acAccommRoomTrfYn;



    /**
     * Get acAccommRoomIx
     *
     * @return string
     */
    public function getAcAccommRoomIx()
    {
        return $this->acAccommRoomIx;
    }

    /**
     * Set acAccommRoomDb
     *
     * @param string $acAccommRoomDb
     *
     * @return AcAccommRoom
     */
    public function setAcAccommRoomDb($acAccommRoomDb)
    {
        $this->acAccommRoomDb = $acAccommRoomDb;

        return $this;
    }

    /**
     * Get acAccommRoomDb
     *
     * @return string
     */
    public function getAcAccommRoomDb()
    {
        return $this->acAccommRoomDb;
    }

    /**
     * Set acAccommRoomId
     *
     * @param integer $acAccommRoomId
     *
     * @return AcAccommRoom
     */
    public function setAcAccommRoomId($acAccommRoomId)
    {
        $this->acAccommRoomId = $acAccommRoomId;

        return $this;
    }

    /**
     * Get acAccommRoomId
     *
     * @return integer
     */
    public function getAcAccommRoomId()
    {
        return $this->acAccommRoomId;
    }

    /**
     * Set acAccommTypeId
     *
     * @param string $acAccommTypeId
     *
     * @return AcAccommRoom
     */
    public function setAcAccommTypeId($acAccommTypeId)
    {
        $this->acAccommTypeId = $acAccommTypeId;

        return $this;
    }

    /**
     * Get acAccommTypeId
     *
     * @return string
     */
    public function getAcAccommTypeId()
    {
        return $this->acAccommTypeId;
    }

    /**
     * Set acDesc
     *
     * @param string $acDesc
     *
     * @return AcAccommRoom
     */
    public function setAcDesc($acDesc)
    {
        $this->acDesc = $acDesc;

        return $this;
    }

    /**
     * Get acDesc
     *
     * @return string
     */
    public function getAcDesc()
    {
        return $this->acDesc;
    }

    /**
     * Set acAccommRoomCreateDate
     *
     * @param \DateTime $acAccommRoomCreateDate
     *
     * @return AcAccommRoom
     */
    public function setAcAccommRoomCreateDate($acAccommRoomCreateDate)
    {
        $this->acAccommRoomCreateDate = $acAccommRoomCreateDate;

        return $this;
    }

    /**
     * Get acAccommRoomCreateDate
     *
     * @return \DateTime
     */
    public function getAcAccommRoomCreateDate()
    {
        return $this->acAccommRoomCreateDate;
    }

    /**
     * Set acAccommRoomInactiveDate
     *
     * @param \DateTime $acAccommRoomInactiveDate
     *
     * @return AcAccommRoom
     */
    public function setAcAccommRoomInactiveDate($acAccommRoomInactiveDate)
    {
        $this->acAccommRoomInactiveDate = $acAccommRoomInactiveDate;

        return $this;
    }

    /**
     * Get acAccommRoomInactiveDate
     *
     * @return \DateTime
     */
    public function getAcAccommRoomInactiveDate()
    {
        return $this->acAccommRoomInactiveDate;
    }

    /**
     * Set acAccommRoomInactiveYn
     *
     * @param boolean $acAccommRoomInactiveYn
     *
     * @return AcAccommRoom
     */
    public function setAcAccommRoomInactiveYn($acAccommRoomInactiveYn)
    {
        $this->acAccommRoomInactiveYn = $acAccommRoomInactiveYn;

        return $this;
    }

    /**
     * Get acAccommRoomInactiveYn
     *
     * @return boolean
     */
    public function getAcAccommRoomInactiveYn()
    {
        return $this->acAccommRoomInactiveYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return AcAccommRoom
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set acAccommRoomTrfYn
     *
     * @param boolean $acAccommRoomTrfYn
     *
     * @return AcAccommRoom
     */
    public function setAcAccommRoomTrfYn($acAccommRoomTrfYn)
    {
        $this->acAccommRoomTrfYn = $acAccommRoomTrfYn;

        return $this;
    }

    /**
     * Get acAccommRoomTrfYn
     *
     * @return boolean
     */
    public function getAcAccommRoomTrfYn()
    {
        return $this->acAccommRoomTrfYn;
    }
}
