<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * AcAccommRoomAttr
 *
 * @ORM\Table(name="ac_accomm_room_attr", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="ac_accomm_room_attr_trf_yn", columns={"ac_accomm_room_attr_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})}, uniqueConstraints={@ORM\UniqueConstraint(name="ac_accomm_room_id", columns={"ac_accomm_room_id", "rt_component_id"})})
 * @ORM\Entity
 */
class AcAccommRoomAttr
{
    /**
     * @var string
     *
     * @ORM\Column(name="ac_accomm_room_attr_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $acAccommRoomAttrIx;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_accomm_room_attr_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $acAccommRoomAttrDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="ac_accomm_room_attr_id", type="integer", nullable=false)
     */
    private $acAccommRoomAttrId;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_accomm_room_id", type="string", length=36, nullable=true)
     */
    private $acAccommRoomId;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_component_id", type="string", length=36, nullable=true)
     */
    private $rtComponentId;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_accomm_type_id", type="string", length=36, nullable=true)
     */
    private $acAccommTypeId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="ac_accomm_room_attr_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $acAccommRoomAttrTrfYn;



    /**
     * Get acAccommRoomAttrIx
     *
     * @return string
     */
    public function getAcAccommRoomAttrIx()
    {
        return $this->acAccommRoomAttrIx;
    }

    /**
     * Set acAccommRoomAttrDb
     *
     * @param string $acAccommRoomAttrDb
     *
     * @return AcAccommRoomAttr
     */
    public function setAcAccommRoomAttrDb($acAccommRoomAttrDb)
    {
        $this->acAccommRoomAttrDb = $acAccommRoomAttrDb;

        return $this;
    }

    /**
     * Get acAccommRoomAttrDb
     *
     * @return string
     */
    public function getAcAccommRoomAttrDb()
    {
        return $this->acAccommRoomAttrDb;
    }

    /**
     * Set acAccommRoomAttrId
     *
     * @param integer $acAccommRoomAttrId
     *
     * @return AcAccommRoomAttr
     */
    public function setAcAccommRoomAttrId($acAccommRoomAttrId)
    {
        $this->acAccommRoomAttrId = $acAccommRoomAttrId;

        return $this;
    }

    /**
     * Get acAccommRoomAttrId
     *
     * @return integer
     */
    public function getAcAccommRoomAttrId()
    {
        return $this->acAccommRoomAttrId;
    }

    /**
     * Set acAccommRoomId
     *
     * @param string $acAccommRoomId
     *
     * @return AcAccommRoomAttr
     */
    public function setAcAccommRoomId($acAccommRoomId)
    {
        $this->acAccommRoomId = $acAccommRoomId;

        return $this;
    }

    /**
     * Get acAccommRoomId
     *
     * @return string
     */
    public function getAcAccommRoomId()
    {
        return $this->acAccommRoomId;
    }

    /**
     * Set rtComponentId
     *
     * @param string $rtComponentId
     *
     * @return AcAccommRoomAttr
     */
    public function setRtComponentId($rtComponentId)
    {
        $this->rtComponentId = $rtComponentId;

        return $this;
    }

    /**
     * Get rtComponentId
     *
     * @return string
     */
    public function getRtComponentId()
    {
        return $this->rtComponentId;
    }

    /**
     * Set acAccommTypeId
     *
     * @param string $acAccommTypeId
     *
     * @return AcAccommRoomAttr
     */
    public function setAcAccommTypeId($acAccommTypeId)
    {
        $this->acAccommTypeId = $acAccommTypeId;

        return $this;
    }

    /**
     * Get acAccommTypeId
     *
     * @return string
     */
    public function getAcAccommTypeId()
    {
        return $this->acAccommTypeId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return AcAccommRoomAttr
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set acAccommRoomAttrTrfYn
     *
     * @param boolean $acAccommRoomAttrTrfYn
     *
     * @return AcAccommRoomAttr
     */
    public function setAcAccommRoomAttrTrfYn($acAccommRoomAttrTrfYn)
    {
        $this->acAccommRoomAttrTrfYn = $acAccommRoomAttrTrfYn;

        return $this;
    }

    /**
     * Get acAccommRoomAttrTrfYn
     *
     * @return boolean
     */
    public function getAcAccommRoomAttrTrfYn()
    {
        return $this->acAccommRoomAttrTrfYn;
    }
}
