<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * AcAccommType
 *
 * @ORM\Table(name="ac_accomm_type", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="ac_accomm_type_trf_yn", columns={"ac_accomm_type_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class AcAccommType
{
    /**
     * @var string
     *
     * @ORM\Column(name="ac_accomm_type_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $acAccommTypeIx;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_accomm_type_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $acAccommTypeDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="ac_accomm_type_id", type="integer", nullable=false)
     */
    private $acAccommTypeId;

    /**
     * @var integer
     *
     * @ORM\Column(name="ac_accomm_capacity", type="integer", nullable=false, options={"default"="0"})
     */
    private $acAccommCapacity;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_accomm_desc", type="string", length=50, nullable=true)
     */
    private $acAccommDesc;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_accomm_label", type="string", length=50, nullable=true, options={"default"="Room"})
     */
    private $acAccommLabel;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_accomm_name_short", type="string", length=10, nullable=true)
     */
    private $acAccommNameShort;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_accomm_wetu_id", type="string", length=50, nullable=true)
     */
    private $acAccommWetuId;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_accomm_wetu_exclude", type="boolean", nullable=false, options={"default"="0"})
     */
    private $acAccommWetuExclude;

    /**
     * @var integer
     *
     * @ORM\Column(name="ac_accomm_no_of_units", type="integer", nullable=false, options={"default"="0"})
     */
    private $acAccommNoOfUnits;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_accomm_note", type="text", length=65535, nullable=true)
     */
    private $acAccommNote;

    /**
     * @var boolean
     *
     * @ORM\Column(name="ac_accomm_sequence", type="boolean", nullable=false, options={"default"="0"})
     */
    private $acAccommSequence;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_cost_centre_id", type="string", length=36, nullable=true)
     */
    private $fnCostCentreId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_business_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $prBusinessId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ac_accomm_type_inactive_date", type="date", nullable=false, options={"default"="0000-00-00"})
     */
    private $acAccommTypeInactiveDate;

    /**
     * @var boolean
     *
     * @ORM\Column(name="ac_accomm_type_inactive_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $acAccommTypeInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_accomm_xref_text", type="string", length=50, nullable=true)
     */
    private $acAccommXrefText;

    /**
     * @var integer
     *
     * @ORM\Column(name="ac_accomm_max_capacity", type="integer", nullable=false, options={"default"="0"})
     */
    private $acAccommMaxCapacity;

    /**
     * @var integer
     *
     * @ORM\Column(name="ac_accomm_max_adults", type="integer", nullable=true)
     */
    private $acAccommMaxAdults;

    /**
     * @var boolean
     *
     * @ORM\Column(name="ac_accomm_max_child_age", type="boolean", nullable=true)
     */
    private $acAccommMaxChildAge;

    /**
     * @var boolean
     *
     * @ORM\Column(name="ac_accomm_day_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $acAccommDayYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="ac_accomm_type_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $acAccommTypeTrfYn;



    /**
     * Get acAccommTypeIx
     *
     * @return string
     */
    public function getAcAccommTypeIx()
    {
        return $this->acAccommTypeIx;
    }

    /**
     * Set acAccommTypeDb
     *
     * @param string $acAccommTypeDb
     *
     * @return AcAccommType
     */
    public function setAcAccommTypeDb($acAccommTypeDb)
    {
        $this->acAccommTypeDb = $acAccommTypeDb;

        return $this;
    }

    /**
     * Get acAccommTypeDb
     *
     * @return string
     */
    public function getAcAccommTypeDb()
    {
        return $this->acAccommTypeDb;
    }

    /**
     * Set acAccommTypeId
     *
     * @param integer $acAccommTypeId
     *
     * @return AcAccommType
     */
    public function setAcAccommTypeId($acAccommTypeId)
    {
        $this->acAccommTypeId = $acAccommTypeId;

        return $this;
    }

    /**
     * Get acAccommTypeId
     *
     * @return integer
     */
    public function getAcAccommTypeId()
    {
        return $this->acAccommTypeId;
    }

    /**
     * Set acAccommCapacity
     *
     * @param integer $acAccommCapacity
     *
     * @return AcAccommType
     */
    public function setAcAccommCapacity($acAccommCapacity)
    {
        $this->acAccommCapacity = $acAccommCapacity;

        return $this;
    }

    /**
     * Get acAccommCapacity
     *
     * @return integer
     */
    public function getAcAccommCapacity()
    {
        return $this->acAccommCapacity;
    }

    /**
     * Set acAccommDesc
     *
     * @param string $acAccommDesc
     *
     * @return AcAccommType
     */
    public function setAcAccommDesc($acAccommDesc)
    {
        $this->acAccommDesc = $acAccommDesc;

        return $this;
    }

    /**
     * Get acAccommDesc
     *
     * @return string
     */
    public function getAcAccommDesc()
    {
        return $this->acAccommDesc;
    }

    /**
     * Set acAccommLabel
     *
     * @param string $acAccommLabel
     *
     * @return AcAccommType
     */
    public function setAcAccommLabel($acAccommLabel)
    {
        $this->acAccommLabel = $acAccommLabel;

        return $this;
    }

    /**
     * Get acAccommLabel
     *
     * @return string
     */
    public function getAcAccommLabel()
    {
        return $this->acAccommLabel;
    }

    /**
     * Set acAccommNameShort
     *
     * @param string $acAccommNameShort
     *
     * @return AcAccommType
     */
    public function setAcAccommNameShort($acAccommNameShort)
    {
        $this->acAccommNameShort = $acAccommNameShort;

        return $this;
    }

    /**
     * Get acAccommNameShort
     *
     * @return string
     */
    public function getAcAccommNameShort()
    {
        return $this->acAccommNameShort;
    }

    /**
     * Set acAccommWetuId
     *
     * @param string $acAccommWetuId
     *
     * @return AcAccommType
     */
    public function setAcAccommWetuId($acAccommWetuId)
    {
        $this->acAccommWetuId = $acAccommWetuId;

        return $this;
    }

    /**
     * Get acAccommWetuId
     *
     * @return string
     */
    public function getAcAccommWetuId()
    {
        return $this->acAccommWetuId;
    }

    /**
     * Set acAccommWetuExclude
     *
     * @param boolean $acAccommWetuExclude
     *
     * @return PrBusiness
     */
    public function setAcAccommWetuExclude($acAccommWetuExclude)
    {
        $this->acAccommWetuExclude = $acAccommWetuExclude;

        return $this;
    }

    /**
     * Get acAccommWetuExclude
     *
     * @return boolean
     */
    public function getAcAccommWetuExclude()
    {
        return $this->acAccommWetuExclude;
    }

    /**
     * Set acAccommNoOfUnits
     *
     * @param integer $acAccommNoOfUnits
     *
     * @return AcAccommType
     */
    public function setAcAccommNoOfUnits($acAccommNoOfUnits)
    {
        $this->acAccommNoOfUnits = $acAccommNoOfUnits;

        return $this;
    }

    /**
     * Get acAccommNoOfUnits
     *
     * @return integer
     */
    public function getAcAccommNoOfUnits()
    {
        return $this->acAccommNoOfUnits;
    }

    /**
     * Set acAccommNote
     *
     * @param string $acAccommNote
     *
     * @return AcAccommType
     */
    public function setAcAccommNote($acAccommNote)
    {
        $this->acAccommNote = $acAccommNote;

        return $this;
    }

    /**
     * Get acAccommNote
     *
     * @return string
     */
    public function getAcAccommNote()
    {
        return $this->acAccommNote;
    }

    /**
     * Set acAccommSequence
     *
     * @param boolean $acAccommSequence
     *
     * @return AcAccommType
     */
    public function setAcAccommSequence($acAccommSequence)
    {
        $this->acAccommSequence = $acAccommSequence;

        return $this;
    }

    /**
     * Get acAccommSequence
     *
     * @return boolean
     */
    public function getAcAccommSequence()
    {
        return $this->acAccommSequence;
    }

    /**
     * Set fnCostCentreId
     *
     * @param string $fnCostCentreId
     *
     * @return AcAccommType
     */
    public function setFnCostCentreId($fnCostCentreId)
    {
        $this->fnCostCentreId = $fnCostCentreId;

        return $this;
    }

    /**
     * Get fnCostCentreId
     *
     * @return string
     */
    public function getFnCostCentreId()
    {
        return $this->fnCostCentreId;
    }

    /**
     * Set prBusinessId
     *
     * @param string $prBusinessId
     *
     * @return AcAccommType
     */
    public function setPrBusinessId($prBusinessId)
    {
        $this->prBusinessId = $prBusinessId;

        return $this;
    }

    /**
     * Get prBusinessId
     *
     * @return string
     */
    public function getPrBusinessId()
    {
        return $this->prBusinessId;
    }

    /**
     * Set acAccommTypeInactiveDate
     *
     * @param \DateTime $acAccommTypeInactiveDate
     *
     * @return AcAccommType
     */
    public function setAcAccommTypeInactiveDate($acAccommTypeInactiveDate)
    {
        $this->acAccommTypeInactiveDate = $acAccommTypeInactiveDate;

        return $this;
    }

    /**
     * Get acAccommTypeInactiveDate
     *
     * @return \DateTime
     */
    public function getAcAccommTypeInactiveDate()
    {
        return $this->acAccommTypeInactiveDate;
    }

    /**
     * Set acAccommTypeInactiveYn
     *
     * @param boolean $acAccommTypeInactiveYn
     *
     * @return AcAccommType
     */
    public function setAcAccommTypeInactiveYn($acAccommTypeInactiveYn)
    {
        $this->acAccommTypeInactiveYn = $acAccommTypeInactiveYn;

        return $this;
    }

    /**
     * Get acAccommTypeInactiveYn
     *
     * @return boolean
     */
    public function getAcAccommTypeInactiveYn()
    {
        return $this->acAccommTypeInactiveYn;
    }

    /**
     * Set acAccommXrefText
     *
     * @param string $acAccommXrefText
     *
     * @return AcAccommType
     */
    public function setAcAccommXrefText($acAccommXrefText)
    {
        $this->acAccommXrefText = $acAccommXrefText;

        return $this;
    }

    /**
     * Get acAccommXrefText
     *
     * @return string
     */
    public function getAcAccommXrefText()
    {
        return $this->acAccommXrefText;
    }

    /**
     * Set acAccommMaxCapacity
     *
     * @param integer $acAccommMaxCapacity
     *
     * @return AcAccommType
     */
    public function setAcAccommMaxCapacity($acAccommMaxCapacity)
    {
        $this->acAccommMaxCapacity = $acAccommMaxCapacity;

        return $this;
    }

    /**
     * Get acAccommMaxCapacity
     *
     * @return integer
     */
    public function getAcAccommMaxCapacity()
    {
        return $this->acAccommMaxCapacity;
    }

    /**
     * Set acAccommMaxAdults
     *
     * @param integer $acAccommMaxAdults
     *
     * @return AcAccommType
     */
    public function setAcAccommMaxAdults($acAccommMaxAdults)
    {
        $this->acAccommMaxAdults = $acAccommMaxAdults;

        return $this;
    }

    /**
     * Get acAccommMaxAdults
     *
     * @return integer
     */
    public function getAcAccommMaxAdults()
    {
        return $this->acAccommMaxAdults;
    }

    /**
     * Set acAccommMaxChildAge
     *
     * @param boolean $acAccommMaxChildAge
     *
     * @return AcAccommType
     */
    public function setAcAccommMaxChildAge($acAccommMaxChildAge)
    {
        $this->acAccommMaxChildAge = $acAccommMaxChildAge;

        return $this;
    }

    /**
     * Get acAccommMaxChildAge
     *
     * @return boolean
     */
    public function getAcAccommMaxChildAge()
    {
        return $this->acAccommMaxChildAge;
    }

    /**
     * Set acAccommDayYn
     *
     * @param boolean $acAccommDayYn
     *
     * @return AcAccommType
     */
    public function setAcAccommDayYn($acAccommDayYn)
    {
        $this->acAccommDayYn = $acAccommDayYn;

        return $this;
    }

    /**
     * Get acAccommDayYn
     *
     * @return boolean
     */
    public function getAcAccommDayYn()
    {
        return $this->acAccommDayYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return AcAccommType
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set acAccommTypeTrfYn
     *
     * @param boolean $acAccommTypeTrfYn
     *
     * @return AcAccommType
     */
    public function setAcAccommTypeTrfYn($acAccommTypeTrfYn)
    {
        $this->acAccommTypeTrfYn = $acAccommTypeTrfYn;

        return $this;
    }

    /**
     * Get acAccommTypeTrfYn
     *
     * @return boolean
     */
    public function getAcAccommTypeTrfYn()
    {
        return $this->acAccommTypeTrfYn;
    }
}
