<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * AcExtra
 *
 * @ORM\Table(name="ac_extra", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="ac_extra_category_id", columns={"ac_extra_category_id"}), @ORM\Index(name="ac_extra_trf_yn", columns={"ac_extra_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class AcExtra
{
    /**
     * @var string
     *
     * @ORM\Column(name="ac_extra_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $acExtraIx;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_extra_db", type="string", length=2, nullable=false, options={"default"="RS", "fixed"="true"})
     */
    private $acExtraDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="ac_extra_id", type="integer", nullable=false)
     */
    private $acExtraId;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_ext_amount", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.00"})
     */
    private $acExtAmount;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_ext_child_disc", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.00"})
     */
    private $acExtChildDisc;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_ext_colour", type="string", length=6, nullable=true)
     */
    private $acExtColour;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_ext_comm_pay", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.00"})
     */
    private $acExtCommPay;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_ext_comm_rec", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.00"})
     */
    private $acExtCommRec;

    /**
     * @var integer
     *
     * @ORM\Column(name="ac_ext_max", type="smallint", nullable=false, options={"default"="0"})
     */
    private $acExtMax;

    /**
     * @var boolean
     *
     * @ORM\Column(name="ac_ext_max_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $acExtMaxYn;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_ext_desc", type="string", length=50, nullable=false, options={"default"=""})
     */
    private $acExtDesc;

    /**
     * @var boolean
     *
     * @ORM\Column(name="ac_extra_external_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $acExtraExternalYn;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_ext_note", type="text", length=65535, nullable=true)
     */
    private $acExtNote;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_ext_note_internal", type="text", length=65535, nullable=true)
     */
    private $acExtNoteInternal;

    /**
     * @var boolean
     *
     * @ORM\Column(name="ac_ext_supplier_conf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $acExtSupplierConfYn;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_ext_travel_eta", type="string", length=50, nullable=true)
     */
    private $acExtTravelEta;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_ext_travel_etd", type="string", length=50, nullable=true)
     */
    private $acExtTravelEtd;

    /**
     * @var integer
     *
     * @ORM\Column(name="ac_ext_adult_count", type="smallint", nullable=false, options={"default"="0"})
     */
    private $acExtAdultCount;

    /**
     * @var integer
     *
     * @ORM\Column(name="ac_ext_child_count", type="smallint", nullable=false, options={"default"="0"})
     */
    private $acExtChildCount;

    /**
     * @var integer
     *
     * @ORM\Column(name="ac_ext_nights", type="smallint", nullable=false, options={"default"="0"})
     */
    private $acExtNights;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_extra_category_id", type="string", length=36, nullable=true)
     */
    private $acExtraCategoryId;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_ext_wetu_prop_id", type="string", length=50, nullable=true)
     */
    private $acExtWetuPropId;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_ext_wetu_accomm_id", type="string", length=50, nullable=true)
     */
    private $acExtWetuAccommId;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_ext_wetu_exclude", type="boolean", length=50, nullable=false, options={"default"="0"})
     */
    private $acExtWetuExclude;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_cost_centre_default_id", type="string", length=36, nullable=true)
     */
    private $fnCostCentreDefaultId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_ledger_id", type="string", length=36, nullable=true)
     */
    private $fnLedgerId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_supplier_id", type="string", length=36, nullable=true)
     */
    private $prSupplierId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_currency_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $rfCurrencyId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_tax_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $rfTaxId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_tax_ind", type="string", length=36, nullable=true)
     */
    private $rfTaxInd;

    /**
     * @var boolean
     *
     * @ORM\Column(name="ac_inactive_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $acInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_extra_xref", type="string", length=50, nullable=false, options={"default"=""})
     */
    private $acExtraXref;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="ac_extra_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $acExtraTrfYn;



    /**
     * Get acExtraIx
     *
     * @return string
     */
    public function getAcExtraIx()
    {
        return $this->acExtraIx;
    }

    /**
     * Set acExtraDb
     *
     * @param string $acExtraDb
     *
     * @return AcExtra
     */
    public function setAcExtraDb($acExtraDb)
    {
        $this->acExtraDb = $acExtraDb;

        return $this;
    }

    /**
     * Get acExtraDb
     *
     * @return string
     */
    public function getAcExtraDb()
    {
        return $this->acExtraDb;
    }

    /**
     * Set acExtraId
     *
     * @param integer $acExtraId
     *
     * @return AcExtra
     */
    public function setAcExtraId($acExtraId)
    {
        $this->acExtraId = $acExtraId;

        return $this;
    }

    /**
     * Get acExtraId
     *
     * @return integer
     */
    public function getAcExtraId()
    {
        return $this->acExtraId;
    }

    /**
     * Set acExtAmount
     *
     * @param string $acExtAmount
     *
     * @return AcExtra
     */
    public function setAcExtAmount($acExtAmount)
    {
        $this->acExtAmount = $acExtAmount;

        return $this;
    }

    /**
     * Get acExtAmount
     *
     * @return string
     */
    public function getAcExtAmount()
    {
        return $this->acExtAmount;
    }

    /**
     * Set acExtChildDisc
     *
     * @param string $acExtChildDisc
     *
     * @return AcExtra
     */
    public function setAcExtChildDisc($acExtChildDisc)
    {
        $this->acExtChildDisc = $acExtChildDisc;

        return $this;
    }

    /**
     * Get acExtChildDisc
     *
     * @return string
     */
    public function getAcExtChildDisc()
    {
        return $this->acExtChildDisc;
    }

    /**
     * Set acExtColour
     *
     * @param string $acExtColour
     *
     * @return AcExtra
     */
    public function setAcExtColour($acExtColour)
    {
        $this->acExtColour = $acExtColour;

        return $this;
    }

    /**
     * Get acExtColour
     *
     * @return string
     */
    public function getAcExtColour()
    {
        return $this->acExtColour;
    }

    /**
     * Set acExtCommPay
     *
     * @param string $acExtCommPay
     *
     * @return AcExtra
     */
    public function setAcExtCommPay($acExtCommPay)
    {
        $this->acExtCommPay = $acExtCommPay;

        return $this;
    }

    /**
     * Get acExtCommPay
     *
     * @return string
     */
    public function getAcExtCommPay()
    {
        return $this->acExtCommPay;
    }

    /**
     * Set acExtCommRec
     *
     * @param string $acExtCommRec
     *
     * @return AcExtra
     */
    public function setAcExtCommRec($acExtCommRec)
    {
        $this->acExtCommRec = $acExtCommRec;

        return $this;
    }

    /**
     * Get acExtCommRec
     *
     * @return string
     */
    public function getAcExtCommRec()
    {
        return $this->acExtCommRec;
    }

    /**
     * Set acExtMax
     *
     * @param integer $acExtMax
     *
     * @return AcExtra
     */
    public function setAcExtMax($acExtMax)
    {
        $this->acExtMax = $acExtMax;

        return $this;
    }

    /**
     * Get acExtMax
     *
     * @return integer
     */
    public function getAcExtMax()
    {
        return $this->acExtMax;
    }

    /**
     * Set acExtMaxYn
     *
     * @param boolean $acExtMaxYn
     *
     * @return AcExtra
     */
    public function setAcExtMaxYn($acExtMaxYn)
    {
        $this->acExtMaxYn = $acExtMaxYn;

        return $this;
    }

    /**
     * Get acExtMaxYn
     *
     * @return boolean
     */
    public function getAcExtMaxYn()
    {
        return $this->acExtMaxYn;
    }

    /**
     * Set acExtDesc
     *
     * @param string $acExtDesc
     *
     * @return AcExtra
     */
    public function setAcExtDesc($acExtDesc)
    {
        $this->acExtDesc = $acExtDesc;

        return $this;
    }

    /**
     * Get acExtDesc
     *
     * @return string
     */
    public function getAcExtDesc()
    {
        return $this->acExtDesc;
    }

    /**
     * Set acExtraExternalYn
     *
     * @param boolean $acExtraExternalYn
     *
     * @return AcExtra
     */
    public function setAcExtraExternalYn($acExtraExternalYn)
    {
        $this->acExtraExternalYn = $acExtraExternalYn;

        return $this;
    }

    /**
     * Get acExtraExternalYn
     *
     * @return boolean
     */
    public function getAcExtraExternalYn()
    {
        return $this->acExtraExternalYn;
    }

    /**
     * Set acExtNote
     *
     * @param string $acExtNote
     *
     * @return AcExtra
     */
    public function setAcExtNote($acExtNote)
    {
        $this->acExtNote = $acExtNote;

        return $this;
    }

    /**
     * Get acExtNote
     *
     * @return string
     */
    public function getAcExtNote()
    {
        return $this->acExtNote;
    }

    /**
     * Set acExtNoteInternal
     *
     * @param string $acExtNoteInternal
     *
     * @return AcExtra
     */
    public function setAcExtNoteInternal($acExtNoteInternal)
    {
        $this->acExtNoteInternal = $acExtNoteInternal;

        return $this;
    }

    /**
     * Get acExtNoteInternal
     *
     * @return string
     */
    public function getAcExtNoteInternal()
    {
        return $this->acExtNoteInternal;
    }

    /**
     * Set acExtSupplierConfYn
     *
     * @param boolean $acExtSupplierConfYn
     *
     * @return AcExtra
     */
    public function setAcExtSupplierConfYn($acExtSupplierConfYn)
    {
        $this->acExtSupplierConfYn = $acExtSupplierConfYn;

        return $this;
    }

    /**
     * Get acExtSupplierConfYn
     *
     * @return boolean
     */
    public function getAcExtSupplierConfYn()
    {
        return $this->acExtSupplierConfYn;
    }

    /**
     * Set acExtTravelEta
     *
     * @param string $acExtTravelEta
     *
     * @return AcExtra
     */
    public function setAcExtTravelEta($acExtTravelEta)
    {
        $this->acExtTravelEta = $acExtTravelEta;

        return $this;
    }

    /**
     * Get acExtTravelEta
     *
     * @return string
     */
    public function getAcExtTravelEta()
    {
        return $this->acExtTravelEta;
    }

    /**
     * Set acExtTravelEtd
     *
     * @param string $acExtTravelEtd
     *
     * @return AcExtra
     */
    public function setAcExtTravelEtd($acExtTravelEtd)
    {
        $this->acExtTravelEtd = $acExtTravelEtd;

        return $this;
    }

    /**
     * Get acExtTravelEtd
     *
     * @return string
     */
    public function getAcExtTravelEtd()
    {
        return $this->acExtTravelEtd;
    }

    /**
     * Set acExtAdultCount
     *
     * @param integer $acExtAdultCount
     *
     * @return AcExtra
     */
    public function setAcExtAdultCount($acExtAdultCount)
    {
        $this->acExtAdultCount = $acExtAdultCount;

        return $this;
    }

    /**
     * Get acExtAdultCount
     *
     * @return integer
     */
    public function getAcExtAdultCount()
    {
        return $this->acExtAdultCount;
    }

    /**
     * Set acExtChildCount
     *
     * @param integer $acExtChildCount
     *
     * @return AcExtra
     */
    public function setAcExtChildCount($acExtChildCount)
    {
        $this->acExtChildCount = $acExtChildCount;

        return $this;
    }

    /**
     * Get acExtChildCount
     *
     * @return integer
     */
    public function getAcExtChildCount()
    {
        return $this->acExtChildCount;
    }

    /**
     * Set acExtNights
     *
     * @param integer $acExtNights
     *
     * @return AcExtra
     */
    public function setAcExtNights($acExtNights)
    {
        $this->acExtNights = $acExtNights;

        return $this;
    }

    /**
     * Get acExtNights
     *
     * @return integer
     */
    public function getAcExtNights()
    {
        return $this->acExtNights;
    }

    /**
     * Set acExtraCategoryId
     *
     * @param string $acExtraCategoryId
     *
     * @return AcExtra
     */
    public function setAcExtraCategoryId($acExtraCategoryId)
    {
        $this->acExtraCategoryId = $acExtraCategoryId;

        return $this;
    }

    /**
     * Get acExtraCategoryId
     *
     * @return string
     */
    public function getAcExtraCategoryId()
    {
        return $this->acExtraCategoryId;
    }

    /**
     * Set acExtWetuPropId
     *
     * @param string $acExtWetuPropId
     *
     * @return AcExtra
     */
    public function setAcExtWetuPropId($acExtWetuPropId)
    {
        $this->acExtWetuPropId = $acExtWetuPropId;

        return $this;
    }

    /**
     * Get acExtWetuPropId
     *
     * @return string
     */
    public function getAcExtWetuPropId()
    {
        return $this->acExtWetuPropId;
    }

    /**
     * Set acExtWetuAccommId
     *
     * @param string $acExtWetuAccommId
     *
     * @return AcExtra
     */
    public function setAcExtWetuAccommId($acExtWetuAccommId)
    {
        $this->acExtWetuAccommId = $acExtWetuAccommId;

        return $this;
    }

    /**
     * Get acExtWetuAccommId
     *
     * @return string
     */
    public function getAcExtWetuAccommId()
    {
        return $this->acExtWetuAccommId;
    }

    /**
     * Set acExtWetuExclude
     *
     * @param string $acExtWetuExclude
     *
     * @return AcExtra
     */
    public function setAcExtWetuExclude($acExtWetuExclude)
    {
        $this->acExtWetuExclude = $acExtWetuExclude;

        return $this;
    }

    /**
     * Get acExtWetuExclude
     *
     * @return string
     */
    public function getAcExtWetuExclude()
    {
        return $this->acExtWetuExclude;
    }

    /**
     * Set fnCostCentreDefaultId
     *
     * @param string $fnCostCentreDefaultId
     *
     * @return AcExtra
     */
    public function setFnCostCentreDefaultId($fnCostCentreDefaultId)
    {
        $this->fnCostCentreDefaultId = $fnCostCentreDefaultId;

        return $this;
    }

    /**
     * Get fnCostCentreDefaultId
     *
     * @return string
     */
    public function getFnCostCentreDefaultId()
    {
        return $this->fnCostCentreDefaultId;
    }

    /**
     * Set fnLedgerId
     *
     * @param string $fnLedgerId
     *
     * @return AcExtra
     */
    public function setFnLedgerId($fnLedgerId)
    {
        $this->fnLedgerId = $fnLedgerId;

        return $this;
    }

    /**
     * Get fnLedgerId
     *
     * @return string
     */
    public function getFnLedgerId()
    {
        return $this->fnLedgerId;
    }

    /**
     * Set prSupplierId
     *
     * @param string $prSupplierId
     *
     * @return AcExtra
     */
    public function setPrSupplierId($prSupplierId)
    {
        $this->prSupplierId = $prSupplierId;

        return $this;
    }

    /**
     * Get prSupplierId
     *
     * @return string
     */
    public function getPrSupplierId()
    {
        return $this->prSupplierId;
    }

    /**
     * Set rfCurrencyId
     *
     * @param string $rfCurrencyId
     *
     * @return AcExtra
     */
    public function setRfCurrencyId($rfCurrencyId)
    {
        $this->rfCurrencyId = $rfCurrencyId;

        return $this;
    }

    /**
     * Get rfCurrencyId
     *
     * @return string
     */
    public function getRfCurrencyId()
    {
        return $this->rfCurrencyId;
    }

    /**
     * Set rfTaxId
     *
     * @param string $rfTaxId
     *
     * @return AcExtra
     */
    public function setRfTaxId($rfTaxId)
    {
        $this->rfTaxId = $rfTaxId;

        return $this;
    }

    /**
     * Get rfTaxId
     *
     * @return string
     */
    public function getRfTaxId()
    {
        return $this->rfTaxId;
    }

    /**
     * Set rfTaxInd
     *
     * @param string $rfTaxInd
     *
     * @return AcExtra
     */
    public function setRfTaxInd($rfTaxInd)
    {
        $this->rfTaxInd = $rfTaxInd;

        return $this;
    }

    /**
     * Get rfTaxInd
     *
     * @return string
     */
    public function getRfTaxInd()
    {
        return $this->rfTaxInd;
    }

    /**
     * Set acInactiveYn
     *
     * @param boolean $acInactiveYn
     *
     * @return AcExtra
     */
    public function setAcInactiveYn($acInactiveYn)
    {
        $this->acInactiveYn = $acInactiveYn;

        return $this;
    }

    /**
     * Get acInactiveYn
     *
     * @return boolean
     */
    public function getAcInactiveYn()
    {
        return $this->acInactiveYn;
    }

    /**
     * Set acExtraXref
     *
     * @param string $acExtraXref
     *
     * @return AcExtra
     */
    public function setAcExtraXref($acExtraXref)
    {
        $this->acExtraXref = $acExtraXref;

        return $this;
    }

    /**
     * Get acExtraXref
     *
     * @return string
     */
    public function getAcExtraXref()
    {
        return $this->acExtraXref;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return AcExtra
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set acExtraTrfYn
     *
     * @param boolean $acExtraTrfYn
     *
     * @return AcExtra
     */
    public function setAcExtraTrfYn($acExtraTrfYn)
    {
        $this->acExtraTrfYn = $acExtraTrfYn;

        return $this;
    }

    /**
     * Get acExtraTrfYn
     *
     * @return boolean
     */
    public function getAcExtraTrfYn()
    {
        return $this->acExtraTrfYn;
    }
}
