<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * AcExtraCatInv
 *
 * @ORM\Table(name="ac_extra_cat_inv", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="ac_extra_cat_inv_trf_yn", columns={"ac_extra_cat_inv_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"}), @ORM\Index(name="pr_business_id", columns={"pr_business_id"})})
 * @ORM\Entity
 */
class AcExtraCatInv
{
    /**
     * @var string
     *
     * @ORM\Column(name="ac_extra_cat_inv_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $acExtraCatInvIx;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_extra_cat_inv_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $acExtraCatInvDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="ac_extra_cat_inv_id", type="integer", nullable=false)
     */
    private $acExtraCatInvId;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_extra_category_id", type="string", length=36, nullable=true)
     */
    private $acExtraCategoryId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_cost_centre_1_id", type="string", length=36, nullable=true)
     */
    private $fnCostCentre1Id;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_cost_centre_2_id", type="string", length=36, nullable=true)
     */
    private $fnCostCentre2Id;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_ledger_id", type="string", length=36, nullable=true)
     */
    private $fnLedgerId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_business_id", type="string", length=36, nullable=true)
     */
    private $prBusinessId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="ac_extra_cat_inv_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $acExtraCatInvTrfYn;



    /**
     * Get acExtraCatInvIx
     *
     * @return string
     */
    public function getAcExtraCatInvIx()
    {
        return $this->acExtraCatInvIx;
    }

    /**
     * Set acExtraCatInvDb
     *
     * @param string $acExtraCatInvDb
     *
     * @return AcExtraCatInv
     */
    public function setAcExtraCatInvDb($acExtraCatInvDb)
    {
        $this->acExtraCatInvDb = $acExtraCatInvDb;

        return $this;
    }

    /**
     * Get acExtraCatInvDb
     *
     * @return string
     */
    public function getAcExtraCatInvDb()
    {
        return $this->acExtraCatInvDb;
    }

    /**
     * Set acExtraCatInvId
     *
     * @param integer $acExtraCatInvId
     *
     * @return AcExtraCatInv
     */
    public function setAcExtraCatInvId($acExtraCatInvId)
    {
        $this->acExtraCatInvId = $acExtraCatInvId;

        return $this;
    }

    /**
     * Get acExtraCatInvId
     *
     * @return integer
     */
    public function getAcExtraCatInvId()
    {
        return $this->acExtraCatInvId;
    }

    /**
     * Set acExtraCategoryId
     *
     * @param string $acExtraCategoryId
     *
     * @return AcExtraCatInv
     */
    public function setAcExtraCategoryId($acExtraCategoryId)
    {
        $this->acExtraCategoryId = $acExtraCategoryId;

        return $this;
    }

    /**
     * Get acExtraCategoryId
     *
     * @return string
     */
    public function getAcExtraCategoryId()
    {
        return $this->acExtraCategoryId;
    }

    /**
     * Set fnCostCentre1Id
     *
     * @param string $fnCostCentre1Id
     *
     * @return AcExtraCatInv
     */
    public function setFnCostCentre1Id($fnCostCentre1Id)
    {
        $this->fnCostCentre1Id = $fnCostCentre1Id;

        return $this;
    }

    /**
     * Get fnCostCentre1Id
     *
     * @return string
     */
    public function getFnCostCentre1Id()
    {
        return $this->fnCostCentre1Id;
    }

    /**
     * Set fnCostCentre2Id
     *
     * @param string $fnCostCentre2Id
     *
     * @return AcExtraCatInv
     */
    public function setFnCostCentre2Id($fnCostCentre2Id)
    {
        $this->fnCostCentre2Id = $fnCostCentre2Id;

        return $this;
    }

    /**
     * Get fnCostCentre2Id
     *
     * @return string
     */
    public function getFnCostCentre2Id()
    {
        return $this->fnCostCentre2Id;
    }

    /**
     * Set fnLedgerId
     *
     * @param string $fnLedgerId
     *
     * @return AcExtraCatInv
     */
    public function setFnLedgerId($fnLedgerId)
    {
        $this->fnLedgerId = $fnLedgerId;

        return $this;
    }

    /**
     * Get fnLedgerId
     *
     * @return string
     */
    public function getFnLedgerId()
    {
        return $this->fnLedgerId;
    }

    /**
     * Set prBusinessId
     *
     * @param string $prBusinessId
     *
     * @return AcExtraCatInv
     */
    public function setPrBusinessId($prBusinessId)
    {
        $this->prBusinessId = $prBusinessId;

        return $this;
    }

    /**
     * Get prBusinessId
     *
     * @return string
     */
    public function getPrBusinessId()
    {
        return $this->prBusinessId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return AcExtraCatInv
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set acExtraCatInvTrfYn
     *
     * @param boolean $acExtraCatInvTrfYn
     *
     * @return AcExtraCatInv
     */
    public function setAcExtraCatInvTrfYn($acExtraCatInvTrfYn)
    {
        $this->acExtraCatInvTrfYn = $acExtraCatInvTrfYn;

        return $this;
    }

    /**
     * Get acExtraCatInvTrfYn
     *
     * @return boolean
     */
    public function getAcExtraCatInvTrfYn()
    {
        return $this->acExtraCatInvTrfYn;
    }
}
