<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * AcExtraCategory
 *
 * @ORM\Table(name="ac_extra_category", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="ac_extra_category_trf_yn", columns={"ac_extra_category_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})}, uniqueConstraints={@ORM\UniqueConstraint(name="ac_extra_cat_desc", columns={"ac_extra_cat_desc"}), @ORM\UniqueConstraint(name="ac_extra_cat_abbrv", columns={"ac_extra_cat_abbrv"})})
 * @ORM\Entity
 */
class AcExtraCategory
{
    /**
     * @var string
     *
     * @ORM\Column(name="ac_extra_category_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $acExtraCategoryIx;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_extra_category_db", type="string", length=2, nullable=false, options={"default"="RS", "fixed"="true"})
     */
    private $acExtraCategoryDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="ac_extra_category_id", type="integer", nullable=false)
     */
    private $acExtraCategoryId;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_extra_cat_abbrv", type="string", length=4, nullable=true)
     */
    private $acExtraCatAbbrv;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_extra_cat_colour", type="string", length=6, nullable=true)
     */
    private $acExtraCatColour;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_extra_cat_cost_ctr", type="string", length=10, nullable=true)
     */
    private $acExtraCatCostCtr;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_extra_cat_desc", type="string", length=20, nullable=true)
     */
    private $acExtraCatDesc;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_extra_cat_note", type="string", length=250, nullable=true)
     */
    private $acExtraCatNote;

    /**
     * @var boolean
     *
     * @ORM\Column(name="ac_extra_cat_sys_code", type="boolean", nullable=false, options={"default"="0"})
     */
    private $acExtraCatSysCode;

    /**
     * @var integer
     *
     * @ORM\Column(name="ac_extra_cat_ind", type="integer", nullable=false, options={"default"="0"})
     */
    private $acExtraCatInd;

    /**
     * @var boolean
     *
     * @ORM\Column(name="ac_extra_category_inactive_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $acExtraCategoryInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="ac_extra_category_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $acExtraCategoryTrfYn;



    /**
     * Get acExtraCategoryIx
     *
     * @return string
     */
    public function getAcExtraCategoryIx()
    {
        return $this->acExtraCategoryIx;
    }

    /**
     * Set acExtraCategoryDb
     *
     * @param string $acExtraCategoryDb
     *
     * @return AcExtraCategory
     */
    public function setAcExtraCategoryDb($acExtraCategoryDb)
    {
        $this->acExtraCategoryDb = $acExtraCategoryDb;

        return $this;
    }

    /**
     * Get acExtraCategoryDb
     *
     * @return string
     */
    public function getAcExtraCategoryDb()
    {
        return $this->acExtraCategoryDb;
    }

    /**
     * Set acExtraCategoryId
     *
     * @param integer $acExtraCategoryId
     *
     * @return AcExtraCategory
     */
    public function setAcExtraCategoryId($acExtraCategoryId)
    {
        $this->acExtraCategoryId = $acExtraCategoryId;

        return $this;
    }

    /**
     * Get acExtraCategoryId
     *
     * @return integer
     */
    public function getAcExtraCategoryId()
    {
        return $this->acExtraCategoryId;
    }

    /**
     * Set acExtraCatAbbrv
     *
     * @param string $acExtraCatAbbrv
     *
     * @return AcExtraCategory
     */
    public function setAcExtraCatAbbrv($acExtraCatAbbrv)
    {
        $this->acExtraCatAbbrv = $acExtraCatAbbrv;

        return $this;
    }

    /**
     * Get acExtraCatAbbrv
     *
     * @return string
     */
    public function getAcExtraCatAbbrv()
    {
        return $this->acExtraCatAbbrv;
    }

    /**
     * Set acExtraCatColour
     *
     * @param string $acExtraCatColour
     *
     * @return AcExtraCategory
     */
    public function setAcExtraCatColour($acExtraCatColour)
    {
        $this->acExtraCatColour = $acExtraCatColour;

        return $this;
    }

    /**
     * Get acExtraCatColour
     *
     * @return string
     */
    public function getAcExtraCatColour()
    {
        return $this->acExtraCatColour;
    }

    /**
     * Set acExtraCatCostCtr
     *
     * @param string $acExtraCatCostCtr
     *
     * @return AcExtraCategory
     */
    public function setAcExtraCatCostCtr($acExtraCatCostCtr)
    {
        $this->acExtraCatCostCtr = $acExtraCatCostCtr;

        return $this;
    }

    /**
     * Get acExtraCatCostCtr
     *
     * @return string
     */
    public function getAcExtraCatCostCtr()
    {
        return $this->acExtraCatCostCtr;
    }

    /**
     * Set acExtraCatDesc
     *
     * @param string $acExtraCatDesc
     *
     * @return AcExtraCategory
     */
    public function setAcExtraCatDesc($acExtraCatDesc)
    {
        $this->acExtraCatDesc = $acExtraCatDesc;

        return $this;
    }

    /**
     * Get acExtraCatDesc
     *
     * @return string
     */
    public function getAcExtraCatDesc()
    {
        return $this->acExtraCatDesc;
    }

    /**
     * Set acExtraCatNote
     *
     * @param string $acExtraCatNote
     *
     * @return AcExtraCategory
     */
    public function setAcExtraCatNote($acExtraCatNote)
    {
        $this->acExtraCatNote = $acExtraCatNote;

        return $this;
    }

    /**
     * Get acExtraCatNote
     *
     * @return string
     */
    public function getAcExtraCatNote()
    {
        return $this->acExtraCatNote;
    }

    /**
     * Set acExtraCatSysCode
     *
     * @param boolean $acExtraCatSysCode
     *
     * @return AcExtraCategory
     */
    public function setAcExtraCatSysCode($acExtraCatSysCode)
    {
        $this->acExtraCatSysCode = $acExtraCatSysCode;

        return $this;
    }

    /**
     * Get acExtraCatSysCode
     *
     * @return boolean
     */
    public function getAcExtraCatSysCode()
    {
        return $this->acExtraCatSysCode;
    }

    /**
     * Set acExtraCatInd
     *
     * @param boolean $acExtraCatInd
     *
     * @return AcExtraCategory
     */
    public function setAcExtraCatInd($acExtraCatInd)
    {
        $this->acExtraCatInd = $acExtraCatInd;

        return $this;
    }

    /**
     * Get acExtraCatInd
     *
     * @return boolean
     */
    public function getAcExtraCatInd()
    {
        return $this->acExtraCatInd;
    }

    /**
     * Set acExtraCategoryInactiveYn
     *
     * @param boolean $acExtraCategoryInactiveYn
     *
     * @return AcExtraCategory
     */
    public function setAcExtraCategoryInactiveYn($acExtraCategoryInactiveYn)
    {
        $this->acExtraCategoryInactiveYn = $acExtraCategoryInactiveYn;

        return $this;
    }

    /**
     * Get acExtraCategoryInactiveYn
     *
     * @return boolean
     */
    public function getAcExtraCategoryInactiveYn()
    {
        return $this->acExtraCategoryInactiveYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return AcExtraCategory
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set acExtraCategoryTrfYn
     *
     * @param boolean $acExtraCategoryTrfYn
     *
     * @return AcExtraCategory
     */
    public function setAcExtraCategoryTrfYn($acExtraCategoryTrfYn)
    {
        $this->acExtraCategoryTrfYn = $acExtraCategoryTrfYn;

        return $this;
    }

    /**
     * Get acExtraCategoryTrfYn
     *
     * @return boolean
     */
    public function getAcExtraCategoryTrfYn()
    {
        return $this->acExtraCategoryTrfYn;
    }
}
