<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * AcExtraInv
 *
 * @ORM\Table(name="ac_extra_inv", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="ac_extra_inv_trf_yn", columns={"ac_extra_inv_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"}), @ORM\Index(name="pr_business_id", columns={"pr_business_id"})})
 * @ORM\Entity
 */
class AcExtraInv
{
    /**
     * @var string
     *
     * @ORM\Column(name="ac_extra_inv_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $acExtraInvIx;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_extra_inv_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $acExtraInvDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="ac_extra_inv_id", type="integer", nullable=false)
     */
    private $acExtraInvId;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_extra_id", type="string", length=36, nullable=true)
     */
    private $acExtraId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_cost_centre_2_id", type="string", length=36, nullable=true)
     */
    private $fnCostCentre2Id;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_cost_centre_1_id", type="string", length=36, nullable=true)
     */
    private $fnCostCentre1Id;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_ledger_id", type="string", length=36, nullable=true)
     */
    private $fnLedgerId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_business_id", type="string", length=36, nullable=true)
     */
    private $prBusinessId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="ac_extra_inv_inactive_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $acExtraInvInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="ac_extra_inv_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $acExtraInvTrfYn;



    /**
     * Get acExtraInvIx
     *
     * @return string
     */
    public function getAcExtraInvIx()
    {
        return $this->acExtraInvIx;
    }

    /**
     * Set acExtraInvDb
     *
     * @param string $acExtraInvDb
     *
     * @return AcExtraInv
     */
    public function setAcExtraInvDb($acExtraInvDb)
    {
        $this->acExtraInvDb = $acExtraInvDb;

        return $this;
    }

    /**
     * Get acExtraInvDb
     *
     * @return string
     */
    public function getAcExtraInvDb()
    {
        return $this->acExtraInvDb;
    }

    /**
     * Set acExtraInvId
     *
     * @param integer $acExtraInvId
     *
     * @return AcExtraInv
     */
    public function setAcExtraInvId($acExtraInvId)
    {
        $this->acExtraInvId = $acExtraInvId;

        return $this;
    }

    /**
     * Get acExtraInvId
     *
     * @return integer
     */
    public function getAcExtraInvId()
    {
        return $this->acExtraInvId;
    }

    /**
     * Set acExtraId
     *
     * @param string $acExtraId
     *
     * @return AcExtraInv
     */
    public function setAcExtraId($acExtraId)
    {
        $this->acExtraId = $acExtraId;

        return $this;
    }

    /**
     * Get acExtraId
     *
     * @return string
     */
    public function getAcExtraId()
    {
        return $this->acExtraId;
    }

    /**
     * Set fnCostCentre2Id
     *
     * @param string $fnCostCentre2Id
     *
     * @return AcExtraInv
     */
    public function setFnCostCentre2Id($fnCostCentre2Id)
    {
        $this->fnCostCentre2Id = $fnCostCentre2Id;

        return $this;
    }

    /**
     * Get fnCostCentre2Id
     *
     * @return string
     */
    public function getFnCostCentre2Id()
    {
        return $this->fnCostCentre2Id;
    }

    /**
     * Set fnCostCentre1Id
     *
     * @param string $fnCostCentre1Id
     *
     * @return AcExtraInv
     */
    public function setFnCostCentre1Id($fnCostCentre1Id)
    {
        $this->fnCostCentre1Id = $fnCostCentre1Id;

        return $this;
    }

    /**
     * Get fnCostCentre1Id
     *
     * @return string
     */
    public function getFnCostCentre1Id()
    {
        return $this->fnCostCentre1Id;
    }

    /**
     * Set fnLedgerId
     *
     * @param string $fnLedgerId
     *
     * @return AcExtraInv
     */
    public function setFnLedgerId($fnLedgerId)
    {
        $this->fnLedgerId = $fnLedgerId;

        return $this;
    }

    /**
     * Get fnLedgerId
     *
     * @return string
     */
    public function getFnLedgerId()
    {
        return $this->fnLedgerId;
    }

    /**
     * Set prBusinessId
     *
     * @param string $prBusinessId
     *
     * @return AcExtraInv
     */
    public function setPrBusinessId($prBusinessId)
    {
        $this->prBusinessId = $prBusinessId;

        return $this;
    }

    /**
     * Get prBusinessId
     *
     * @return string
     */
    public function getPrBusinessId()
    {
        return $this->prBusinessId;
    }

    /**
     * Set acExtraInvInactiveYn
     *
     * @param boolean $acExtraInvInactiveYn
     *
     * @return AcExtraInv
     */
    public function setAcExtraInvInactiveYn($acExtraInvInactiveYn)
    {
        $this->acExtraInvInactiveYn = $acExtraInvInactiveYn;

        return $this;
    }

    /**
     * Get acExtraInvInactiveYn
     *
     * @return boolean
     */
    public function getAcExtraInvInactiveYn()
    {
        return $this->acExtraInvInactiveYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return AcExtraInv
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set acExtraInvTrfYn
     *
     * @param boolean $acExtraInvTrfYn
     *
     * @return AcExtraInv
     */
    public function setAcExtraInvTrfYn($acExtraInvTrfYn)
    {
        $this->acExtraInvTrfYn = $acExtraInvTrfYn;

        return $this;
    }

    /**
     * Get acExtraInvTrfYn
     *
     * @return boolean
     */
    public function getAcExtraInvTrfYn()
    {
        return $this->acExtraInvTrfYn;
    }
}
