<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * AcExtraProp
 *
 * @ORM\Table(name="ac_extra_prop", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="ac_extra_prop_trf_yn", columns={"ac_extra_prop_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class AcExtraProp
{
    /**
     * @var string
     *
     * @ORM\Column(name="ac_extra_prop_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $acExtraPropIx;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_extra_prop_db", type="string", length=2, nullable=false, options={"default"="RS", "fixed"="true"})
     */
    private $acExtraPropDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="ac_extra_prop_id", type="integer", nullable=false)
     */
    private $acExtraPropId;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_extra_id", type="string", length=36, nullable=true)
     */
    private $acExtraId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_business_id", type="string", length=36, nullable=true)
     */
    private $prBusinessId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="ac_extra_prop_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $acExtraPropTrfYn;



    /**
     * Get acExtraPropIx
     *
     * @return string
     */
    public function getAcExtraPropIx()
    {
        return $this->acExtraPropIx;
    }

    /**
     * Set acExtraPropDb
     *
     * @param string $acExtraPropDb
     *
     * @return AcExtraProp
     */
    public function setAcExtraPropDb($acExtraPropDb)
    {
        $this->acExtraPropDb = $acExtraPropDb;

        return $this;
    }

    /**
     * Get acExtraPropDb
     *
     * @return string
     */
    public function getAcExtraPropDb()
    {
        return $this->acExtraPropDb;
    }

    /**
     * Set acExtraPropId
     *
     * @param integer $acExtraPropId
     *
     * @return AcExtraProp
     */
    public function setAcExtraPropId($acExtraPropId)
    {
        $this->acExtraPropId = $acExtraPropId;

        return $this;
    }

    /**
     * Get acExtraPropId
     *
     * @return integer
     */
    public function getAcExtraPropId()
    {
        return $this->acExtraPropId;
    }

    /**
     * Set acExtraId
     *
     * @param string $acExtraId
     *
     * @return AcExtraProp
     */
    public function setAcExtraId($acExtraId)
    {
        $this->acExtraId = $acExtraId;

        return $this;
    }

    /**
     * Get acExtraId
     *
     * @return string
     */
    public function getAcExtraId()
    {
        return $this->acExtraId;
    }

    /**
     * Set prBusinessId
     *
     * @param string $prBusinessId
     *
     * @return AcExtraProp
     */
    public function setPrBusinessId($prBusinessId)
    {
        $this->prBusinessId = $prBusinessId;

        return $this;
    }

    /**
     * Get prBusinessId
     *
     * @return string
     */
    public function getPrBusinessId()
    {
        return $this->prBusinessId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return AcExtraProp
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set acExtraPropTrfYn
     *
     * @param boolean $acExtraPropTrfYn
     *
     * @return AcExtraProp
     */
    public function setAcExtraPropTrfYn($acExtraPropTrfYn)
    {
        $this->acExtraPropTrfYn = $acExtraPropTrfYn;

        return $this;
    }

    /**
     * Get acExtraPropTrfYn
     *
     * @return boolean
     */
    public function getAcExtraPropTrfYn()
    {
        return $this->acExtraPropTrfYn;
    }
}
