<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * AcPayItem
 *
 * @ORM\Table(name="ac_pay_item", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="ac_pay_plan_id", columns={"ac_pay_plan_id"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"}), @ORM\Index(name="ac_pay_item_trf_yn", columns={"ac_pay_item_trf_yn"})})
 * @ORM\Entity
 */
class AcPayItem
{
    /**
     * @var string
     *
     * @ORM\Column(name="ac_pay_item_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $acPayItemIx;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_pay_item_db", type="string", length=2, nullable=false, options={"default"="RS", "fixed"="true"})
     */
    private $acPayItemDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="ac_pay_item_id", type="integer", nullable=true)
     */
    private $acPayItemId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="ac_pay_base", type="boolean", nullable=false, options={"default"="0"})
     */
    private $acPayBase;

    /**
     * @var boolean
     *
     * @ORM\Column(name="ac_pay_days", type="boolean", nullable=false, options={"default"="0"})
     */
    private $acPayDays;

    /**
     * @var boolean
     *
     * @ORM\Column(name="ac_pay_final_base", type="boolean", nullable=false, options={"default"="0"})
     */
    private $acPayFinalBase;

    /**
     * @var boolean
     *
     * @ORM\Column(name="ac_pay_final_days", type="boolean", nullable=false, options={"default"="0"})
     */
    private $acPayFinalDays;

    /**
     * @var boolean
     *
     * @ORM\Column(name="ac_pay_final_agent_override_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $acPayFinalAgentOverrideYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="ac_pay_amount_ind", type="boolean", nullable=false, options={"default"="0"})
     */
    private $acPayAmountInd;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_pay_amount", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.00"})
     */
    private $acPayAmount;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_pay_plan_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $acPayPlanId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="ac_pay_item_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $acPayItemTrfYn;



    /**
     * Get acPayItemIx
     *
     * @return string
     */
    public function getAcPayItemIx()
    {
        return $this->acPayItemIx;
    }

    /**
     * Set acPayItemDb
     *
     * @param string $acPayItemDb
     *
     * @return AcPayItem
     */
    public function setAcPayItemDb($acPayItemDb)
    {
        $this->acPayItemDb = $acPayItemDb;

        return $this;
    }

    /**
     * Get acPayItemDb
     *
     * @return string
     */
    public function getAcPayItemDb()
    {
        return $this->acPayItemDb;
    }

    /**
     * Set acPayItemId
     *
     * @param integer $acPayItemId
     *
     * @return AcPayItem
     */
    public function setAcPayItemId($acPayItemId)
    {
        $this->acPayItemId = $acPayItemId;

        return $this;
    }

    /**
     * Get acPayItemId
     *
     * @return integer
     */
    public function getAcPayItemId()
    {
        return $this->acPayItemId;
    }

    /**
     * Set acPayBase
     *
     * @param boolean $acPayBase
     *
     * @return AcPayItem
     */
    public function setAcPayBase($acPayBase)
    {
        $this->acPayBase = $acPayBase;

        return $this;
    }

    /**
     * Get acPayBase
     *
     * @return boolean
     */
    public function getAcPayBase()
    {
        return $this->acPayBase;
    }

    /**
     * Set acPayDays
     *
     * @param boolean $acPayDays
     *
     * @return AcPayItem
     */
    public function setAcPayDays($acPayDays)
    {
        $this->acPayDays = $acPayDays;

        return $this;
    }

    /**
     * Get acPayDays
     *
     * @return boolean
     */
    public function getAcPayDays()
    {
        return $this->acPayDays;
    }

    /**
     * Set acPayFinalBase
     *
     * @param boolean $acPayFinalBase
     *
     * @return AcPayItem
     */
    public function setAcPayFinalBase($acPayFinalBase)
    {
        $this->acPayFinalBase = $acPayFinalBase;

        return $this;
    }

    /**
     * Get acPayFinalBase
     *
     * @return boolean
     */
    public function getAcPayFinalBase()
    {
        return $this->acPayFinalBase;
    }

    /**
     * Set acPayFinalDays
     *
     * @param boolean $acPayFinalDays
     *
     * @return AcPayItem
     */
    public function setAcPayFinalDays($acPayFinalDays)
    {
        $this->acPayFinalDays = $acPayFinalDays;

        return $this;
    }

    /**
     * Get acPayFinalDays
     *
     * @return boolean
     */
    public function getAcPayFinalDays()
    {
        return $this->acPayFinalDays;
    }

    /**
     * Set acPayFinalAgentOverrideYn
     *
     * @param boolean $acPayFinalAgentOverrideYn
     *
     * @return AcPayItem
     */
    public function setAcPayFinalAgentOverrideYn($acPayFinalAgentOverrideYn)
    {
        $this->acPayFinalAgentOverrideYn = $acPayFinalAgentOverrideYn;

        return $this;
    }

    /**
     * Get acPayFinalAgentOverrideYn
     *
     * @return boolean
     */
    public function getAcPayFinalAgentOverrideYn()
    {
        return $this->acPayFinalAgentOverrideYn;
    }

    /**
     * Set acPayAmountInd
     *
     * @param boolean $acPayAmountInd
     *
     * @return AcPayItem
     */
    public function setAcPayAmountInd($acPayAmountInd)
    {
        $this->acPayAmountInd = $acPayAmountInd;

        return $this;
    }

    /**
     * Get acPayAmountInd
     *
     * @return boolean
     */
    public function getAcPayAmountInd()
    {
        return $this->acPayAmountInd;
    }

    /**
     * Set acPayAmount
     *
     * @param string $acPayAmount
     *
     * @return AcPayItem
     */
    public function setAcPayAmount($acPayAmount)
    {
        $this->acPayAmount = $acPayAmount;

        return $this;
    }

    /**
     * Get acPayAmount
     *
     * @return string
     */
    public function getAcPayAmount()
    {
        return $this->acPayAmount;
    }

    /**
     * Set acPayPlanId
     *
     * @param string $acPayPlanId
     *
     * @return AcPayItem
     */
    public function setAcPayPlanId($acPayPlanId)
    {
        $this->acPayPlanId = $acPayPlanId;

        return $this;
    }

    /**
     * Get acPayPlanId
     *
     * @return string
     */
    public function getAcPayPlanId()
    {
        return $this->acPayPlanId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return AcPayItem
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set acPayItemTrfYn
     *
     * @param boolean $acPayItemTrfYn
     *
     * @return AcPayItem
     */
    public function setAcPayItemTrfYn($acPayItemTrfYn)
    {
        $this->acPayItemTrfYn = $acPayItemTrfYn;

        return $this;
    }

    /**
     * Get acPayItemTrfYn
     *
     * @return boolean
     */
    public function getAcPayItemTrfYn()
    {
        return $this->acPayItemTrfYn;
    }
}
