<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * AcPayPlan
 *
 * @ORM\Table(name="ac_pay_plan", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="ac_pay_plan_trf_yn", columns={"ac_pay_plan_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})}, uniqueConstraints={@ORM\UniqueConstraint(name="ac_pay_plan_desc", columns={"ac_pay_plan_desc"})})
 * @ORM\Entity
 */
class AcPayPlan
{
    /**
     * @var string
     *
     * @ORM\Column(name="ac_pay_plan_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $acPayPlanIx;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_pay_plan_db", type="string", length=2, nullable=false, options={"default"="RS", "fixed"="true"})
     */
    private $acPayPlanDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="ac_pay_plan_id", type="integer", nullable=true)
     */
    private $acPayPlanId;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_pay_plan_desc", type="string", length=50, nullable=true)
     */
    private $acPayPlanDesc;

    /**
     * @var boolean
     *
     * @ORM\Column(name="ac_pay_plan_inactive_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $acPayPlanInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="ac_pay_plan_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $acPayPlanTrfYn;



    /**
     * Get acPayPlanIx
     *
     * @return string
     */
    public function getAcPayPlanIx()
    {
        return $this->acPayPlanIx;
    }

    /**
     * Set acPayPlanDb
     *
     * @param string $acPayPlanDb
     *
     * @return AcPayPlan
     */
    public function setAcPayPlanDb($acPayPlanDb)
    {
        $this->acPayPlanDb = $acPayPlanDb;

        return $this;
    }

    /**
     * Get acPayPlanDb
     *
     * @return string
     */
    public function getAcPayPlanDb()
    {
        return $this->acPayPlanDb;
    }

    /**
     * Set acPayPlanId
     *
     * @param integer $acPayPlanId
     *
     * @return AcPayPlan
     */
    public function setAcPayPlanId($acPayPlanId)
    {
        $this->acPayPlanId = $acPayPlanId;

        return $this;
    }

    /**
     * Get acPayPlanId
     *
     * @return integer
     */
    public function getAcPayPlanId()
    {
        return $this->acPayPlanId;
    }

    /**
     * Set acPayPlanDesc
     *
     * @param string $acPayPlanDesc
     *
     * @return AcPayPlan
     */
    public function setAcPayPlanDesc($acPayPlanDesc)
    {
        $this->acPayPlanDesc = $acPayPlanDesc;

        return $this;
    }

    /**
     * Get acPayPlanDesc
     *
     * @return string
     */
    public function getAcPayPlanDesc()
    {
        return $this->acPayPlanDesc;
    }

    /**
     * Set acPayPlanInactiveYn
     *
     * @param boolean $acPayPlanInactiveYn
     *
     * @return AcPayPlan
     */
    public function setAcPayPlanInactiveYn($acPayPlanInactiveYn)
    {
        $this->acPayPlanInactiveYn = $acPayPlanInactiveYn;

        return $this;
    }

    /**
     * Get acPayPlanInactiveYn
     *
     * @return boolean
     */
    public function getAcPayPlanInactiveYn()
    {
        return $this->acPayPlanInactiveYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return AcPayPlan
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set acPayPlanTrfYn
     *
     * @param boolean $acPayPlanTrfYn
     *
     * @return AcPayPlan
     */
    public function setAcPayPlanTrfYn($acPayPlanTrfYn)
    {
        $this->acPayPlanTrfYn = $acPayPlanTrfYn;

        return $this;
    }

    /**
     * Get acPayPlanTrfYn
     *
     * @return boolean
     */
    public function getAcPayPlanTrfYn()
    {
        return $this->acPayPlanTrfYn;
    }
}
