<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * AcPos
 *
 * @ORM\Table(name="ac_pos", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="ac_pos_trf_yn", columns={"ac_pos_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class AcPos
{
    /**
     * @var string
     *
     * @ORM\Column(name="ac_pos_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $acPosIx;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_pos_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $acPosDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="ac_pos_id", type="integer", nullable=false)
     */
    private $acPosId;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_pos_name", type="string", length=50, nullable=true)
     */
    private $acPosName;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_pos_name_rr", type="string", length=20, nullable=true)
     */
    private $acPosNameRr;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_extra_id", type="string", length=36, nullable=true)
     */
    private $acExtraId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_reservation_id", type="string", length=13, nullable=true)
     */
    private $rvReservationId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="ac_cash_period_ind", type="boolean", nullable=false)
     */
    private $acCashPeriodInd;

    /**
     * @var boolean
     *
     * @ORM\Column(name="ac_inactive_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $acInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="ac_pos_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $acPosTrfYn;



    /**
     * Get acPosIx
     *
     * @return string
     */
    public function getAcPosIx()
    {
        return $this->acPosIx;
    }

    /**
     * Set acPosDb
     *
     * @param string $acPosDb
     *
     * @return AcPos
     */
    public function setAcPosDb($acPosDb)
    {
        $this->acPosDb = $acPosDb;

        return $this;
    }

    /**
     * Get acPosDb
     *
     * @return string
     */
    public function getAcPosDb()
    {
        return $this->acPosDb;
    }

    /**
     * Set acPosId
     *
     * @param integer $acPosId
     *
     * @return AcPos
     */
    public function setAcPosId($acPosId)
    {
        $this->acPosId = $acPosId;

        return $this;
    }

    /**
     * Get acPosId
     *
     * @return integer
     */
    public function getAcPosId()
    {
        return $this->acPosId;
    }

    /**
     * Set acPosName
     *
     * @param string $acPosName
     *
     * @return AcPos
     */
    public function setAcPosName($acPosName)
    {
        $this->acPosName = $acPosName;

        return $this;
    }

    /**
     * Get acPosName
     *
     * @return string
     */
    public function getAcPosName()
    {
        return $this->acPosName;
    }

    /**
     * Set acPosNameRr
     *
     * @param string $acPosNameRr
     *
     * @return AcPos
     */
    public function setAcPosNameRr($acPosNameRr)
    {
        $this->acPosNameRr = $acPosNameRr;

        return $this;
    }

    /**
     * Get acPosNameRr
     *
     * @return string
     */
    public function getAcPosNameRr()
    {
        return $this->acPosNameRr;
    }

    /**
     * Set acExtraId
     *
     * @param string $acExtraId
     *
     * @return AcPos
     */
    public function setAcExtraId($acExtraId)
    {
        $this->acExtraId = $acExtraId;

        return $this;
    }

    /**
     * Get acExtraId
     *
     * @return string
     */
    public function getAcExtraId()
    {
        return $this->acExtraId;
    }

    /**
     * Set rvReservationId
     *
     * @param string $rvReservationId
     *
     * @return AcPos
     */
    public function setRvReservationId($rvReservationId)
    {
        $this->rvReservationId = $rvReservationId;

        return $this;
    }

    /**
     * Get rvReservationId
     *
     * @return string
     */
    public function getRvReservationId()
    {
        return $this->rvReservationId;
    }

    /**
     * Set acCashPeriodInd
     *
     * @param boolean $acCashPeriodInd
     *
     * @return AcPos
     */
    public function setAcCashPeriodInd($acCashPeriodInd)
    {
        $this->acCashPeriodInd = $acCashPeriodInd;

        return $this;
    }

    /**
     * Get acCashPeriodInd
     *
     * @return boolean
     */
    public function getAcCashPeriodInd()
    {
        return $this->acCashPeriodInd;
    }

    /**
     * Set acInactiveYn
     *
     * @param boolean $acInactiveYn
     *
     * @return AcPos
     */
    public function setAcInactiveYn($acInactiveYn)
    {
        $this->acInactiveYn = $acInactiveYn;

        return $this;
    }

    /**
     * Get acInactiveYn
     *
     * @return boolean
     */
    public function getAcInactiveYn()
    {
        return $this->acInactiveYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return AcPos
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set acPosTrfYn
     *
     * @param boolean $acPosTrfYn
     *
     * @return AcPos
     */
    public function setAcPosTrfYn($acPosTrfYn)
    {
        $this->acPosTrfYn = $acPosTrfYn;

        return $this;
    }

    /**
     * Get acPosTrfYn
     *
     * @return boolean
     */
    public function getAcPosTrfYn()
    {
        return $this->acPosTrfYn;
    }
}
