<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * AcPosMap
 *
 * @ORM\Table(name="ac_pos_map", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="ac_pos_map_trf_yn", columns={"ac_pos_map_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class AcPosMap
{
    /**
     * @var string
     *
     * @ORM\Column(name="ac_pos_map_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $acPosMapIx;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_pos_map_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $acPosMapDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="ac_pos_map_id", type="integer", nullable=false)
     */
    private $acPosMapId;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_pos_id", type="string", length=36, nullable=true)
     */
    private $acPosId;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_extra_id", type="string", length=36, nullable=true)
     */
    private $acExtraId;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_pos_map_code", type="string", length=255, nullable=true, options={"default"=""})
     */
    private $acPosMapCode;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="ac_pos_map_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $acPosMapTrfYn;



    /**
     * Get acPosMapIx
     *
     * @return string
     */
    public function getAcPosMapIx()
    {
        return $this->acPosMapIx;
    }

    /**
     * Set acPosMapDb
     *
     * @param string $acPosMapDb
     *
     * @return AcPosMap
     */
    public function setAcPosMapDb($acPosMapDb)
    {
        $this->acPosMapDb = $acPosMapDb;

        return $this;
    }

    /**
     * Get acPosMapDb
     *
     * @return string
     */
    public function getAcPosMapDb()
    {
        return $this->acPosMapDb;
    }

    /**
     * Set acPosMapId
     *
     * @param integer $acPosMapId
     *
     * @return AcPosMap
     */
    public function setAcPosMapId($acPosMapId)
    {
        $this->acPosMapId = $acPosMapId;

        return $this;
    }

    /**
     * Get acPosMapId
     *
     * @return integer
     */
    public function getAcPosMapId()
    {
        return $this->acPosMapId;
    }

    /**
     * Set acPosId
     *
     * @param string $acPosId
     *
     * @return AcPosMap
     */
    public function setAcPosId($acPosId)
    {
        $this->acPosId = $acPosId;

        return $this;
    }

    /**
     * Get acPosId
     *
     * @return string
     */
    public function getAcPosId()
    {
        return $this->acPosId;
    }

    /**
     * Set acExtraId
     *
     * @param string $acExtraId
     *
     * @return AcPosMap
     */
    public function setAcExtraId($acExtraId)
    {
        $this->acExtraId = $acExtraId;

        return $this;
    }

    /**
     * Get acExtraId
     *
     * @return string
     */
    public function getAcExtraId()
    {
        return $this->acExtraId;
    }

    /**
     * Set acPosMapCode
     *
     * @param string $acPosMapCode
     *
     * @return AcPosMap
     */
    public function setAcPosMapCode($acPosMapCode)
    {
        $this->acPosMapCode = $acPosMapCode;

        return $this;
    }

    /**
     * Get acPosMapCode
     *
     * @return string
     */
    public function getAcPosMapCode()
    {
        return $this->acPosMapCode;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return AcPosMap
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set acPosMapTrfYn
     *
     * @param boolean $acPosMapTrfYn
     *
     * @return AcPosMap
     */
    public function setAcPosMapTrfYn($acPosMapTrfYn)
    {
        $this->acPosMapTrfYn = $acPosMapTrfYn;

        return $this;
    }

    /**
     * Get acPosMapTrfYn
     *
     * @return boolean
     */
    public function getAcPosMapTrfYn()
    {
        return $this->acPosMapTrfYn;
    }
}
