<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * AdApi
 *
 * @ORM\Table(name="ad_api", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="ad_api_trf_yn", columns={"ad_api_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class AdApi
{
    /**
     * @var string
     *
     * @ORM\Column(name="ad_api_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $adApiIx;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_api_db", type="string", length=2, nullable=false, options={"default"="RS", "fixed"="true"})
     */
    private $adApiDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="ad_api_id", type="integer", nullable=false)
     */
    private $adApiId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_api_time", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adApiTime;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_api_time_tz", type="string", length=40, nullable=false)
     */
    private $adApiTimeTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_api_function", type="string", length=30, nullable=true)
     */
    private $adApiFunction;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_user_id", type="string", length=36, nullable=true)
     */
    private $prUserId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="ad_api_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $adApiTrfYn;



    /**
     * Get adApiIx
     *
     * @return string
     */
    public function getAdApiIx()
    {
        return $this->adApiIx;
    }

    /**
     * Set adApiDb
     *
     * @param string $adApiDb
     *
     * @return AdApi
     */
    public function setAdApiDb($adApiDb)
    {
        $this->adApiDb = $adApiDb;

        return $this;
    }

    /**
     * Get adApiDb
     *
     * @return string
     */
    public function getAdApiDb()
    {
        return $this->adApiDb;
    }

    /**
     * Set adApiId
     *
     * @param integer $adApiId
     *
     * @return AdApi
     */
    public function setAdApiId($adApiId)
    {
        $this->adApiId = $adApiId;

        return $this;
    }

    /**
     * Get adApiId
     *
     * @return integer
     */
    public function getAdApiId()
    {
        return $this->adApiId;
    }

    /**
     * Set adApiTime
     *
     * @param \DateTime $adApiTime
     *
     * @return AdApi
     */
    public function setAdApiTime($adApiTime)
    {
        $this->adApiTime = $adApiTime;

        return $this;
    }

    /**
     * Get adApiTime
     *
     * @return \DateTime
     */
    public function getAdApiTime()
    {
        return $this->adApiTime;
    }

    /**
     * Set adApiTimeTz
     *
     * @param string $adApiTimeTz
     *
     * @return AdApi
     */
    public function setAdApiTimeTz($adApiTimeTz)
    {
        $this->adApiTimeTz = $adApiTimeTz;

        return $this;
    }

    /**
     * Get adApiTimeTz
     *
     * @return string
     */
    public function getAdApiTimeTz()
    {
        return $this->adApiTimeTz;
    }

    /**
     * Set adApiFunction
     *
     * @param string $adApiFunction
     *
     * @return AdApi
     */
    public function setAdApiFunction($adApiFunction)
    {
        $this->adApiFunction = $adApiFunction;

        return $this;
    }

    /**
     * Get adApiFunction
     *
     * @return string
     */
    public function getAdApiFunction()
    {
        return $this->adApiFunction;
    }

    /**
     * Set prUserId
     *
     * @param string $prUserId
     *
     * @return AdApi
     */
    public function setPrUserId($prUserId)
    {
        $this->prUserId = $prUserId;

        return $this;
    }

    /**
     * Get prUserId
     *
     * @return string
     */
    public function getPrUserId()
    {
        return $this->prUserId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return AdApi
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set adApiTrfYn
     *
     * @param boolean $adApiTrfYn
     *
     * @return AdApi
     */
    public function setAdApiTrfYn($adApiTrfYn)
    {
        $this->adApiTrfYn = $adApiTrfYn;

        return $this;
    }

    /**
     * Get adApiTrfYn
     *
     * @return boolean
     */
    public function getAdApiTrfYn()
    {
        return $this->adApiTrfYn;
    }
}
