<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * AdArchive
 *
 * @ORM\Table(name="ad_archive", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="ad_archive_trf_yn", columns={"ad_archive_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class AdArchive
{
    /**
     * @var string
     *
     * @ORM\Column(name="ad_archive_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $adArchiveIx;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_archive_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $adArchiveDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="ad_archive_id", type="integer", nullable=false)
     */
    private $adArchiveId;

    /**
     * @var integer
     *
     * @ORM\Column(name="rf_archive_id", type="integer", nullable=false, options={"default"="0"})
     */
    private $rfArchiveId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_create_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adCreateDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_date_tz", type="string", length=40, nullable=false)
     */
    private $adCreateDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_user_id", type="string", length=36, nullable=true)
     */
    private $adCreateUserId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="ad_archive_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $adArchiveTrfYn;



    /**
     * Get adArchiveIx
     *
     * @return string
     */
    public function getAdArchiveIx()
    {
        return $this->adArchiveIx;
    }

    /**
     * Set adArchiveDb
     *
     * @param string $adArchiveDb
     *
     * @return AdArchive
     */
    public function setAdArchiveDb($adArchiveDb)
    {
        $this->adArchiveDb = $adArchiveDb;

        return $this;
    }

    /**
     * Get adArchiveDb
     *
     * @return string
     */
    public function getAdArchiveDb()
    {
        return $this->adArchiveDb;
    }

    /**
     * Set adArchiveId
     *
     * @param integer $adArchiveId
     *
     * @return AdArchive
     */
    public function setAdArchiveId($adArchiveId)
    {
        $this->adArchiveId = $adArchiveId;

        return $this;
    }

    /**
     * Get adArchiveId
     *
     * @return integer
     */
    public function getAdArchiveId()
    {
        return $this->adArchiveId;
    }

    /**
     * Set rfArchiveId
     *
     * @param integer $rfArchiveId
     *
     * @return AdArchive
     */
    public function setRfArchiveId($rfArchiveId)
    {
        $this->rfArchiveId = $rfArchiveId;

        return $this;
    }

    /**
     * Get rfArchiveId
     *
     * @return integer
     */
    public function getRfArchiveId()
    {
        return $this->rfArchiveId;
    }

    /**
     * Set adCreateDate
     *
     * @param \DateTime $adCreateDate
     *
     * @return AdArchive
     */
    public function setAdCreateDate($adCreateDate)
    {
        $this->adCreateDate = $adCreateDate;

        return $this;
    }

    /**
     * Get adCreateDate
     *
     * @return \DateTime
     */
    public function getAdCreateDate()
    {
        return $this->adCreateDate;
    }

    /**
     * Set adCreateDateTz
     *
     * @param string $adCreateDateTz
     *
     * @return AdArchive
     */
    public function setAdCreateDateTz($adCreateDateTz)
    {
        $this->adCreateDateTz = $adCreateDateTz;

        return $this;
    }

    /**
     * Get adCreateDateTz
     *
     * @return string
     */
    public function getAdCreateDateTz()
    {
        return $this->adCreateDateTz;
    }

    /**
     * Set adCreateUserId
     *
     * @param string $adCreateUserId
     *
     * @return AdArchive
     */
    public function setAdCreateUserId($adCreateUserId)
    {
        $this->adCreateUserId = $adCreateUserId;

        return $this;
    }

    /**
     * Get adCreateUserId
     *
     * @return string
     */
    public function getAdCreateUserId()
    {
        return $this->adCreateUserId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return AdArchive
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set adArchiveTrfYn
     *
     * @param boolean $adArchiveTrfYn
     *
     * @return AdArchive
     */
    public function setAdArchiveTrfYn($adArchiveTrfYn)
    {
        $this->adArchiveTrfYn = $adArchiveTrfYn;

        return $this;
    }

    /**
     * Get adArchiveTrfYn
     *
     * @return boolean
     */
    public function getAdArchiveTrfYn()
    {
        return $this->adArchiveTrfYn;
    }
}
