<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * AdBatch
 *
 * @ORM\Table(name="ad_batch", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="fn_batch_id", columns={"fn_batch_id"}), @ORM\Index(name="ad_batch_trf_yn", columns={"ad_batch_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class AdBatch
{
    /**
     * @var string
     *
     * @ORM\Column(name="ad_batch_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $adBatchIx;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_batch_db", type="string", length=2, nullable=false, options={"default"="RS", "fixed"="true"})
     */
    private $adBatchDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="ad_batch_id", type="integer", nullable=false)
     */
    private $adBatchId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="ad_batch_action_ind", type="boolean", nullable=false, options={"default"="0"})
     */
    private $adBatchActionInd;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_batch_result", type="text", length=65535, nullable=false)
     */
    private $adBatchResult;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_create_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adCreateDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_date_tz", type="string", length=40, nullable=false)
     */
    private $adCreateDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_user_id", type="string", length=36, nullable=true)
     */
    private $adCreateUserId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_batch_id", type="string", length=18, nullable=false, options={"default"=""}))
     */
    private $fnBatchId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="ad_batch_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $adBatchTrfYn;



    /**
     * Get adBatchIx
     *
     * @return string
     */
    public function getAdBatchIx()
    {
        return $this->adBatchIx;
    }

    /**
     * Set adBatchDb
     *
     * @param string $adBatchDb
     *
     * @return AdBatch
     */
    public function setAdBatchDb($adBatchDb)
    {
        $this->adBatchDb = $adBatchDb;

        return $this;
    }

    /**
     * Get adBatchDb
     *
     * @return string
     */
    public function getAdBatchDb()
    {
        return $this->adBatchDb;
    }

    /**
     * Set adBatchId
     *
     * @param integer $adBatchId
     *
     * @return AdBatch
     */
    public function setAdBatchId($adBatchId)
    {
        $this->adBatchId = $adBatchId;

        return $this;
    }

    /**
     * Get adBatchId
     *
     * @return integer
     */
    public function getAdBatchId()
    {
        return $this->adBatchId;
    }

    /**
     * Set adBatchActionInd
     *
     * @param boolean $adBatchActionInd
     *
     * @return AdBatch
     */
    public function setAdBatchActionInd($adBatchActionInd)
    {
        $this->adBatchActionInd = $adBatchActionInd;

        return $this;
    }

    /**
     * Get adBatchActionInd
     *
     * @return boolean
     */
    public function getAdBatchActionInd()
    {
        return $this->adBatchActionInd;
    }

    /**
     * Set adBatchResult
     *
     * @param string $adBatchResult
     *
     * @return AdBatch
     */
    public function setAdBatchResult($adBatchResult)
    {
        $this->adBatchResult = $adBatchResult;

        return $this;
    }

    /**
     * Get adBatchResult
     *
     * @return string
     */
    public function getAdBatchResult()
    {
        return $this->adBatchResult;
    }

    /**
     * Set adCreateDate
     *
     * @param \DateTime $adCreateDate
     *
     * @return AdBatch
     */
    public function setAdCreateDate($adCreateDate)
    {
        $this->adCreateDate = $adCreateDate;

        return $this;
    }

    /**
     * Get adCreateDate
     *
     * @return \DateTime
     */
    public function getAdCreateDate()
    {
        return $this->adCreateDate;
    }

    /**
     * Set adCreateDateTz
     *
     * @param string $adCreateDateTz
     *
     * @return AdBatch
     */
    public function setAdCreateDateTz($adCreateDateTz)
    {
        $this->adCreateDateTz = $adCreateDateTz;

        return $this;
    }

    /**
     * Get adCreateDateTz
     *
     * @return string
     */
    public function getAdCreateDateTz()
    {
        return $this->adCreateDateTz;
    }

    /**
     * Set adCreateUserId
     *
     * @param string $adCreateUserId
     *
     * @return AdBatch
     */
    public function setAdCreateUserId($adCreateUserId)
    {
        $this->adCreateUserId = $adCreateUserId;

        return $this;
    }

    /**
     * Get adCreateUserId
     *
     * @return string
     */
    public function getAdCreateUserId()
    {
        return $this->adCreateUserId;
    }

    /**
     * Set fnBatchId
     *
     * @param string $fnBatchId
     *
     * @return AdBatch
     */
    public function setFnBatchId($fnBatchId)
    {
        $this->fnBatchId = $fnBatchId;

        return $this;
    }

    /**
     * Get fnBatchId
     *
     * @return string
     */
    public function getFnBatchId()
    {
        return $this->fnBatchId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return AdBatch
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set adBatchTrfYn
     *
     * @param boolean $adBatchTrfYn
     *
     * @return AdBatch
     */
    public function setAdBatchTrfYn($adBatchTrfYn)
    {
        $this->adBatchTrfYn = $adBatchTrfYn;

        return $this;
    }

    /**
     * Get adBatchTrfYn
     *
     * @return boolean
     */
    public function getAdBatchTrfYn()
    {
        return $this->adBatchTrfYn;
    }
}
