<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * AdDbStatus
 *
 * @ORM\Table(name="ad_db_status", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="ad_db_status_trf_yn", columns={"ad_db_status_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class AdDbStatus
{
    /**
     * @var string
     *
     * @ORM\Column(name="ad_db_status_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $adDbStatusIx;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_db_status_db", type="string", length=2, nullable=false, options={"default"="RS", "fixed"="true"})
     */
    private $adDbStatusDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="ad_db_status_id", type="integer", nullable=true)
     */
    private $adDbStatusId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_db_start", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adDbStart;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_db_start_tz", type="string", length=40, nullable=false)
     */
    private $adDbStartTz;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_db_end", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adDbEnd;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_db_end_tz", type="string", length=40, nullable=false)
     */
    private $adDbEndTz;

    /**
     * @var boolean
     *
     * @ORM\Column(name="ad_db_function_ind", type="boolean", nullable=true)
     */
    private $adDbFunctionInd;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_db_user_id", type="string", length=36, nullable=true)
     */
    private $adDbUserId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="ad_db_status_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $adDbStatusTrfYn;



    /**
     * Get adDbStatusIx
     *
     * @return string
     */
    public function getAdDbStatusIx()
    {
        return $this->adDbStatusIx;
    }

    /**
     * Set adDbStatusDb
     *
     * @param string $adDbStatusDb
     *
     * @return AdDbStatus
     */
    public function setAdDbStatusDb($adDbStatusDb)
    {
        $this->adDbStatusDb = $adDbStatusDb;

        return $this;
    }

    /**
     * Get adDbStatusDb
     *
     * @return string
     */
    public function getAdDbStatusDb()
    {
        return $this->adDbStatusDb;
    }
    
    /**
     * Set adDbStatusId
     *
     * @param integer $adDbStatusId
     *
     * @return AdDbStatus
     */
    public function setAdDbStatusId($adDbStatusId)
    {
        $this->adDbStatusId = $adDbStatusId;

        return $this;
    }

    /**
     * Get adDbStatusId
     *
     * @return integer
     */
    public function getAdDbStatusId()
    {
        return $this->adDbStatusId;
    }

    /**
     * Set adDbStart
     *
     * @param \DateTime $adDbStart
     *
     * @return AdDbStatus
     */
    public function setAdDbStart($adDbStart)
    {
        $this->adDbStart = $adDbStart;

        return $this;
    }

    /**
     * Get adDbStart
     *
     * @return \DateTime
     */
    public function getAdDbStart()
    {
        return $this->adDbStart;
    }

    /**
     * Set adDbStartTz
     *
     * @param string $adDbStartTz
     *
     * @return AdDbStatus
     */
    public function setAdDbStartTz($adDbStartTz)
    {
        $this->adDbStartTz = $adDbStartTz;

        return $this;
    }

    /**
     * Get adDbStartTz
     *
     * @return string
     */
    public function getAdDbStartTz()
    {
        return $this->adDbStartTz;
    }

    /**
     * Set adDbEnd
     *
     * @param \DateTime $adDbEnd
     *
     * @return AdDbStatus
     */
    public function setAdDbEnd($adDbEnd)
    {
        $this->adDbEnd = $adDbEnd;

        return $this;
    }

    /**
     * Get adDbEnd
     *
     * @return \DateTime
     */
    public function getAdDbEnd()
    {
        return $this->adDbEnd;
    }

    /**
     * Set adDbEndTz
     *
     * @param string $adDbEndTz
     *
     * @return AdDbStatus
     */
    public function setAdDbEndTz($adDbEndTz)
    {
        $this->adDbEndTz = $adDbEndTz;

        return $this;
    }

    /**
     * Get adDbEndTz
     *
     * @return string
     */
    public function getAdDbEndTz()
    {
        return $this->adDbEndTz;
    }

    /**
     * Set adDbFunctionInd
     *
     * @param boolean $adDbFunctionInd
     *
     * @return AdDbStatus
     */
    public function setAdDbFunctionInd($adDbFunctionInd)
    {
        $this->adDbFunctionInd = $adDbFunctionInd;

        return $this;
    }

    /**
     * Get adDbFunctionInd
     *
     * @return boolean
     */
    public function getAdDbFunctionInd()
    {
        return $this->adDbFunctionInd;
    }

    /**
     * Set adDbUserId
     *
     * @param string $adDbUserId
     *
     * @return AdDbStatus
     */
    public function setAdDbUserId($adDbUserId)
    {
        $this->adDbUserId = $adDbUserId;

        return $this;
    }

    /**
     * Get adDbUserId
     *
     * @return string
     */
    public function getAdDbUserId()
    {
        return $this->adDbUserId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return AdDbStatus
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set adDbStatusTrfYn
     *
     * @param boolean $adDbStatusTrfYn
     *
     * @return AdDbStatus
     */
    public function setAdDbStatusTrfYn($adDbStatusTrfYn)
    {
        $this->adDbStatusTrfYn = $adDbStatusTrfYn;

        return $this;
    }

    /**
     * Get adDbStatusTrfYn
     *
     * @return boolean
     */
    public function getAdDbStatusTrfYn()
    {
        return $this->adDbStatusTrfYn;
    }
}
