<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * AdModuleField
 *
 * @ORM\Table(name="ad_module_field", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="ad_module_field_trf_yn", columns={"ad_module_field_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class AdModuleField
{
    /**
     * @var integer
     *
     * @ORM\Column(name="ad_module_field_id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue
     */
    private $adModuleFieldId;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_module_field_name", type="string", length=300, nullable=false)
     */
    private $adModuleFieldName;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_module_field_description", type="string", length=200, nullable=false)
     */
    private $adModuleFieldDescription;

    /**
     * @var integer
     *
     * @ORM\Column(name="tc_table_id", type="integer", nullable=false)
     */
    private $tcTableId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_audit_module_id", type="string", length=36, nullable=true)
     */
    private $rfAuditModuleId;

    /**
     * @var integer
     *
     * @ORM\Column(name="tc_table_id_display", type="integer", nullable=true)
     */
    private $tcTableIdDisplay;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_module_field_display", type="string", length=300, nullable=true)
     */
    private $adModuleFieldDisplay;

    /**
     * @var integer
     *
     * @ORM\Column(name="ad_module_field_display_type_ind", type="integer", nullable=false)
     */
    private $adModuleFieldDisplayTypeInd;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="ad_module_field_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $adModuleFieldTrfYn;



    /**
     * Get adModuleFieldId
     *
     * @return integer
     */
    public function getAdModuleFieldId()
    {
        return $this->adModuleFieldId;
    }

    /**
     * Set adModuleFieldName
     *
     * @param string $adModuleFieldName
     *
     * @return AdModuleField
     */
    public function setAdModuleFieldName($adModuleFieldName)
    {
        $this->adModuleFieldName = $adModuleFieldName;

        return $this;
    }

    /**
     * Get adModuleFieldName
     *
     * @return string
     */
    public function getAdModuleFieldName()
    {
        return $this->adModuleFieldName;
    }

    /**
     * Set adModuleFieldDescription
     *
     * @param string $adModuleFieldDescription
     *
     * @return AdModuleField
     */
    public function setAdModuleFieldDescription($adModuleFieldDescription)
    {
        $this->adModuleFieldDescription = $adModuleFieldDescription;

        return $this;
    }

    /**
     * Get adModuleFieldDescription
     *
     * @return string
     */
    public function getAdModuleFieldDescription()
    {
        return $this->adModuleFieldDescription;
    }

    /**
     * Set tcTableId
     *
     * @param integer $tcTableId
     *
     * @return AdModuleField
     */
    public function setTcTableId($tcTableId)
    {
        $this->tcTableId = $tcTableId;

        return $this;
    }

    /**
     * Get tcTableId
     *
     * @return integer
     */
    public function getTcTableId()
    {
        return $this->tcTableId;
    }

    /**
     * Set rfAuditModuleId
     *
     * @param string $rfAuditModuleId
     *
     * @return AdModuleField
     */
    public function setRfAuditModuleId($rfAuditModuleId)
    {
        $this->rfAuditModuleId = $rfAuditModuleId;

        return $this;
    }

    /**
     * Get rfAuditModuleId
     *
     * @return string
     */
    public function getRfAuditModuleId()
    {
        return $this->rfAuditModuleId;
    }

    /**
     * Set tcTableIdDisplay
     *
     * @param integer $tcTableIdDisplay
     *
     * @return AdModuleField
     */
    public function setTcTableIdDisplay($tcTableIdDisplay)
    {
        $this->tcTableIdDisplay = $tcTableIdDisplay;

        return $this;
    }

    /**
     * Get tcTableIdDisplay
     *
     * @return integer
     */
    public function getTcTableIdDisplay()
    {
        return $this->tcTableIdDisplay;
    }

    /**
     * Set adModuleFieldDisplay
     *
     * @param string $adModuleFieldDisplay
     *
     * @return AdModuleField
     */
    public function setAdModuleFieldDisplay($adModuleFieldDisplay)
    {
        $this->adModuleFieldDisplay = $adModuleFieldDisplay;

        return $this;
    }

    /**
     * Get adModuleFieldDisplay
     *
     * @return string
     */
    public function getAdModuleFieldDisplay()
    {
        return $this->adModuleFieldDisplay;
    }

    /**
     * Set adModuleFieldDisplayTypeInd
     *
     * @param integer $adModuleFieldDisplayTypeInd
     *
     * @return AdModuleField
     */
    public function setAdModuleFieldDisplayTypeInd($adModuleFieldDisplayTypeInd)
    {
        $this->adModuleFieldDisplayTypeInd = $adModuleFieldDisplayTypeInd;

        return $this;
    }

    /**
     * Get adModuleFieldDisplayTypeInd
     *
     * @return integer
     */
    public function getAdModuleFieldDisplayTypeInd()
    {
        return $this->adModuleFieldDisplayTypeInd;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return AdModuleField
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set adModuleFieldTrfYn
     *
     * @param boolean $adModuleFieldTrfYn
     *
     * @return AdModuleField
     */
    public function setAdModuleFieldTrfYn($adModuleFieldTrfYn)
    {
        $this->adModuleFieldTrfYn = $adModuleFieldTrfYn;

        return $this;
    }

    /**
     * Get adModuleFieldTrfYn
     *
     * @return boolean
     */
    public function getAdModuleFieldTrfYn()
    {
        return $this->adModuleFieldTrfYn;
    }
}
