<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * AdPersona
 *
 * @ORM\Table(name="ad_persona", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="pr_persona_id", columns={"pr_persona_id"})})
 * @ORM\Entity
 */
class AdPersona
{
    /**
     * @var string
     *
     * @ORM\Column(name="ad_persona_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $adPersonaIx;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_persona_db", type="string", length=2, nullable=false, options={"default"="RS", "fixed"="true"})
     */
    private $adPersonaDb = 'RS';

    /**
     * @var integer
     *
     * @ORM\Column(name="ad_persona_id", type="integer", nullable=false)
     */
    private $adPersonaId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_persona_time", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adPersonaTime = '0000-00-00 00:00:00';

    /**
     * @var string
     *
     * @ORM\Column(name="ad_persona_time_tz", type="string", length=40, nullable=false)
     */
    private $adPersonaTimeTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_persona_form", type="text", length=65535, nullable=false)
     */
    private $adPersonaForm;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_user_id", type="string", length=36, nullable=true)
     */
    private $prUserId;

    /**
     * @var integer
     *
     * @ORM\Column(name="rf_database_id", type="integer", nullable=true)
     */
    private $rfDatabaseId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_persona_id", type="string", length=36, nullable=true)
     */
    private $prPersonaId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_reservation_id", type="string", length=36, nullable=true)
     */
    private $rvReservationId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="ad_persona_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $adPersonaTrfYn = '0';



    /**
     * Set adPersonaIx
     *
     * @param string $adPersonaIx
     *
     * @return AdPersona
     */
    public function setAdPersonaIx($adPersonaIx)
    {
        $this->adPersonaIx = $adPersonaIx;

        return $this;
    }

    /**
     * Get adPersonaIx
     *
     * @return string
     */
    public function getAdPersonaIx()
    {
        return $this->adPersonaIx;
    }

    /**
     * Set adPersonaDb
     *
     * @param string $adPersonaDb
     *
     * @return AdPersona
     */
    public function setAdPersonaDb($adPersonaDb)
    {
        $this->adPersonaDb = $adPersonaDb;

        return $this;
    }

    /**
     * Get adPersonaDb
     *
     * @return string
     */
    public function getAdPersonaDb()
    {
        return $this->adPersonaDb;
    }

    /**
     * Set adPersonaId
     *
     * @param integer $adPersonaId
     *
     * @return AdPersona
     */
    public function setAdPersonaId($adPersonaId)
    {
        $this->adPersonaId = $adPersonaId;

        return $this;
    }

    /**
     * Get adPersonaId
     *
     * @return integer
     */
    public function getAdPersonaId()
    {
        return $this->adPersonaId;
    }

    /**
     * Set adPersonaTime
     *
     * @param \DateTime $adPersonaTime
     *
     * @return AdPersona
     */
    public function setAdPersonaTime($adPersonaTime)
    {
        $this->adPersonaTime = $adPersonaTime;

        return $this;
    }

    /**
     * Get adPersonaTime
     *
     * @return \DateTime
     */
    public function getAdPersonaTime()
    {
        return $this->adPersonaTime;
    }

    /**
     * Set adPersonaTimeTz
     *
     * @param string $adPersonaTimeTz
     *
     * @return AdPersona
     */
    public function setAdPersonaTimeTz($adPersonaTimeTz)
    {
        $this->adPersonaTimeTz = $adPersonaTimeTz;

        return $this;
    }

    /**
     * Get adPersonaTimeTz
     *
     * @return string
     */
    public function getAdPersonaTimeTz()
    {
        return $this->adPersonaTimeTz;
    }

    /**
     * Set adPersonaForm
     *
     * @param string $adPersonaForm
     *
     * @return AdPersona
     */
    public function setAdPersonaForm($adPersonaForm)
    {
        $this->adPersonaForm = $adPersonaForm;

        return $this;
    }

    /**
     * Get adPersonaForm
     *
     * @return string
     */
    public function getAdPersonaForm()
    {
        return $this->adPersonaForm;
    }

    /**
     * Set prUserId
     *
     * @param string $prUserId
     *
     * @return AdPersona
     */
    public function setPrUserId($prUserId)
    {
        $this->prUserId = $prUserId;

        return $this;
    }

    /**
     * Get prUserId
     *
     * @return string
     */
    public function getPrUserId()
    {
        return $this->prUserId;
    }

    /**
     * Set rfDatabaseId
     *
     * @param integer $rfDatabaseId
     *
     * @return AdPersona
     */
    public function setRfDatabaseId($rfDatabaseId)
    {
        $this->rfDatabaseId = $rfDatabaseId;

        return $this;
    }

    /**
     * Get rfDatabaseId
     *
     * @return integer
     */
    public function getRfDatabaseId()
    {
        return $this->rfDatabaseId;
    }

    /**
     * Set prPersonaId
     *
     * @param string $prPersonaId
     *
     * @return AdPersona
     */
    public function setPrPersonaId($prPersonaId)
    {
        $this->prPersonaId = $prPersonaId;

        return $this;
    }

    /**
     * Get prPersonaId
     *
     * @return string
     */
    public function getPrPersonaId()
    {
        return $this->prPersonaId;
    }

    /**
     * Set rvReservationId
     *
     * @param string $rvReservationId
     *
     * @return AdPersona
     */
    public function setRvReservationId($rvReservationId)
    {
        $this->rvReservationId = $rvReservationId;

        return $this;
    }

    /**
     * Get rvReservationId
     *
     * @return string
     */
    public function getRvReservationId()
    {
        return $this->rvReservationId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return AdPersona
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set adPersonaTrfYn
     *
     * @param boolean $adPersonaTrfYn
     *
     * @return AdPersona
     */
    public function setAdPersonaTrfYn($adPersonaTrfYn)
    {
        $this->adPersonaTrfYn = $adPersonaTrfYn;

        return $this;
    }

    /**
     * Get adPersonaTrfYn
     *
     * @return boolean
     */
    public function getAdPersonaTrfYn()
    {
        return $this->adPersonaTrfYn;
    }
}
