<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * AdPersonaDetail
 *
 * @ORM\Table(name="ad_persona_detail", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="ad_persona_id", columns={"ad_persona_id"})})
 * @ORM\Entity
 */
class AdPersonaDetail
{
    /**
     * @var string
     *
     * @ORM\Column(name="ad_persona_detail_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $adPersonaDetailIx;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_persona_detail_db", type="string", length=2, nullable=false, options={"default"="RS", "fixed"="true"})
     */
    private $adPersonaDetailDb = 'RS';

    /**
     * @var integer
     *
     * @ORM\Column(name="ad_persona_detail_id", type="integer", nullable=false)
     */
    private $adPersonaDetailId;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_persona_detail_value_from", type="text", length=65535, nullable=false)
     */
    private $adPersonaDetailValueFrom;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_persona_detail_value_to", type="text", length=65535, nullable=false)
     */
    private $adPersonaDetailValueTo;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_persona_detail_value_from_display", type="text", length=65535, nullable=false)
     */
    private $adPersonaDetailValueFromDisplay;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_persona_detail_value_to_display", type="text", length=65535, nullable=false)
     */
    private $adPersonaDetailValueToDisplay;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_persona_detail_id_from", type="string", length=36, nullable=true)
     */
    private $adPersonaDetailIdFrom;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_persona_detail_id_to", type="string", length=36, nullable=true)
     */
    private $adPersonaDetailIdTo;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_persona_detail_field_id", type="string", length=36, nullable=true)
     */
    private $adPersonaDetailFieldId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="ad_persona_detail_action_ind", type="boolean", nullable=false, options={"default"="0"})
     */
    private $adPersonaDetailActionInd = '0';

    /**
     * @var string
     *
     * @ORM\Column(name="ad_persona_id", type="string", length=36, nullable=true)
     */
    private $adPersonaId;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_module_field_id", type="string", length=36, nullable=true)
     */
    private $adModuleFieldId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="ad_persona_detail_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $adPersonaDetailTrfYn = '0';



    /**
     * Set adPersonaDetailIx
     *
     * @param string $adPersonaDetailIx
     *
     * @return AdPersonaDetail
     */
    public function setAdPersonaDetailIx($adPersonaDetailIx)
    {
        $this->adPersonaDetailIx = $adPersonaDetailIx;

        return $this;
    }

    /**
     * Get adPersonaDetailIx
     *
     * @return string
     */
    public function getAdPersonaDetailIx()
    {
        return $this->adPersonaDetailIx;
    }

    /**
     * Set adPersonaDetailDb
     *
     * @param string $adPersonaDetailDb
     *
     * @return AdPersonaDetail
     */
    public function setAdPersonaDetailDb($adPersonaDetailDb)
    {
        $this->adPersonaDetailDb = $adPersonaDetailDb;

        return $this;
    }

    /**
     * Get adPersonaDetailDb
     *
     * @return string
     */
    public function getAdPersonaDetailDb()
    {
        return $this->adPersonaDetailDb;
    }

    /**
     * Set adPersonaDetailId
     *
     * @param integer $adPersonaDetailId
     *
     * @return AdPersonaDetail
     */
    public function setAdPersonaDetailId($adPersonaDetailId)
    {
        $this->adPersonaDetailId = $adPersonaDetailId;

        return $this;
    }

    /**
     * Get adPersonaDetailId
     *
     * @return integer
     */
    public function getAdPersonaDetailId()
    {
        return $this->adPersonaDetailId;
    }

    /**
     * Set adPersonaDetailValueFrom
     *
     * @param string $adPersonaDetailValueFrom
     *
     * @return AdPersonaDetail
     */
    public function setAdPersonaDetailValueFrom($adPersonaDetailValueFrom)
    {
        $this->adPersonaDetailValueFrom = $adPersonaDetailValueFrom;

        return $this;
    }

    /**
     * Get adPersonaDetailValueFrom
     *
     * @return string
     */
    public function getAdPersonaDetailValueFrom()
    {
        return $this->adPersonaDetailValueFrom;
    }

    /**
     * Set adPersonaDetailValueTo
     *
     * @param string $adPersonaDetailValueTo
     *
     * @return AdPersonaDetail
     */
    public function setAdPersonaDetailValueTo($adPersonaDetailValueTo)
    {
        $this->adPersonaDetailValueTo = $adPersonaDetailValueTo;

        return $this;
    }

    /**
     * Get adPersonaDetailValueTo
     *
     * @return string
     */
    public function getAdPersonaDetailValueTo()
    {
        return $this->adPersonaDetailValueTo;
    }

    /**
     * Set adPersonaDetailValueFromDisplay
     *
     * @param string $adPersonaDetailValueFromDisplay
     *
     * @return AdPersonaDetail
     */
    public function setAdPersonaDetailValueFromDisplay($adPersonaDetailValueFromDisplay)
    {
        $this->adPersonaDetailValueFromDisplay = $adPersonaDetailValueFromDisplay;

        return $this;
    }

    /**
     * Get adPersonaDetailValueFromDisplay
     *
     * @return string
     */
    public function getAdPersonaDetailValueFromDisplay()
    {
        return $this->adPersonaDetailValueFromDisplay;
    }

    /**
     * Set adPersonaDetailValueToDisplay
     *
     * @param string $adPersonaDetailValueToDisplay
     *
     * @return AdPersonaDetail
     */
    public function setAdPersonaDetailValueToDisplay($adPersonaDetailValueToDisplay)
    {
        $this->adPersonaDetailValueToDisplay = $adPersonaDetailValueToDisplay;

        return $this;
    }

    /**
     * Get adPersonaDetailValueToDisplay
     *
     * @return string
     */
    public function getAdPersonaDetailValueToDisplay()
    {
        return $this->adPersonaDetailValueToDisplay;
    }

    /**
     * Set adPersonaDetailIdFrom
     *
     * @param string $adPersonaDetailIdFrom
     *
     * @return AdPersonaDetail
     */
    public function setAdPersonaDetailIdFrom($adPersonaDetailIdFrom)
    {
        $this->adPersonaDetailIdFrom = $adPersonaDetailIdFrom;

        return $this;
    }

    /**
     * Get adPersonaDetailIdFrom
     *
     * @return string
     */
    public function getAdPersonaDetailIdFrom()
    {
        return $this->adPersonaDetailIdFrom;
    }

    /**
     * Set adPersonaDetailIdTo
     *
     * @param string $adPersonaDetailIdTo
     *
     * @return AdPersonaDetail
     */
    public function setAdPersonaDetailIdTo($adPersonaDetailIdTo)
    {
        $this->adPersonaDetailIdTo = $adPersonaDetailIdTo;

        return $this;
    }

    /**
     * Get adPersonaDetailIdTo
     *
     * @return string
     */
    public function getAdPersonaDetailIdTo()
    {
        return $this->adPersonaDetailIdTo;
    }

    /**
     * Set adPersonaDetailFieldId
     *
     * @param string $adPersonaDetailFieldId
     *
     * @return AdPersonaDetail
     */
    public function setAdPersonaDetailFieldId($adPersonaDetailFieldId)
    {
        $this->adPersonaDetailFieldId = $adPersonaDetailFieldId;

        return $this;
    }

    /**
     * Get adPersonaDetailFieldId
     *
     * @return string
     */
    public function getAdPersonaDetailFieldId()
    {
        return $this->adPersonaDetailFieldId;
    }

    /**
     * Set adPersonaDetailActionInd
     *
     * @param boolean $adPersonaDetailActionInd
     *
     * @return AdPersonaDetail
     */
    public function setAdPersonaDetailActionInd($adPersonaDetailActionInd)
    {
        $this->adPersonaDetailActionInd = $adPersonaDetailActionInd;

        return $this;
    }

    /**
     * Get adPersonaDetailActionInd
     *
     * @return boolean
     */
    public function getAdPersonaDetailActionInd()
    {
        return $this->adPersonaDetailActionInd;
    }

    /**
     * Set adPersonaId
     *
     * @param string $adPersonaId
     *
     * @return AdPersonaDetail
     */
    public function setAdPersonaId($adPersonaId)
    {
        $this->adPersonaId = $adPersonaId;

        return $this;
    }

    /**
     * Get adPersonaId
     *
     * @return string
     */
    public function getAdPersonaId()
    {
        return $this->adPersonaId;
    }

    /**
     * Set adModuleFieldId
     *
     * @param string $adModuleFieldId
     *
     * @return AdPersonaDetail
     */
    public function setAdModuleFieldId($adModuleFieldId)
    {
        $this->adModuleFieldId = $adModuleFieldId;

        return $this;
    }

    /**
     * Get adModuleFieldId
     *
     * @return string
     */
    public function getAdModuleFieldId()
    {
        return $this->adModuleFieldId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return AdPersonaDetail
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set adPersonaDetailTrfYn
     *
     * @param boolean $adPersonaDetailTrfYn
     *
     * @return AdPersonaDetail
     */
    public function setAdPersonaDetailTrfYn($adPersonaDetailTrfYn)
    {
        $this->adPersonaDetailTrfYn = $adPersonaDetailTrfYn;

        return $this;
    }

    /**
     * Get adPersonaDetailTrfYn
     *
     * @return boolean
     */
    public function getAdPersonaDetailTrfYn()
    {
        return $this->adPersonaDetailTrfYn;
    }
}
