<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * AdResDetail
 *
 * @ORM\Table(name="ad_res_detail", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="ad_res_detail_trf_yn", columns={"ad_res_detail_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"}), @ORM\Index(name="ad_reservation_id", columns={"ad_reservation_id"})})
 * @ORM\Entity
 */
class AdResDetail
{
    /**
     * @var string
     *
     * @ORM\Column(name="ad_res_detail_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $adResDetailIx;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_res_detail_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $adResDetailDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="ad_res_detail_id", type="integer", nullable=false)
     */
    private $adResDetailId;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_res_detail_value_from", type="text", length=65535, nullable=true)
     */
    private $adResDetailValueFrom;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_res_detail_value_to", type="text", length=65535, nullable=true)
     */
    private $adResDetailValueTo;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_res_detail_value_from_display", type="text", length=65535, nullable=true)
     */
    private $adResDetailValueFromDisplay;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_res_detail_value_to_display", type="text", length=65535, nullable=true)
     */
    private $adResDetailValueToDisplay;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_res_detail_id_from", type="string", length=200, nullable=true)
     */
    private $adResDetailIdFrom;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_res_detail_id_to", type="string", length=200, nullable=true)
     */
    private $adResDetailIdTo;

    /**
     * @var integer
     *
     * @ORM\Column(name="ad_res_detail_action_ind", type="integer", nullable=false)
     */
    private $adResDetailActionInd;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_reservation_id", type="string", length=36, nullable=true)
     */
    private $adReservationId;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_module_field_id", type="string", length=36, nullable=true)
     */
    private $adModuleFieldId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="ad_res_detail_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $adResDetailTrfYn;



    /**
     * Get adResDetailIx
     *
     * @return string
     */
    public function getAdResDetailIx()
    {
        return $this->adResDetailIx;
    }

    /**
     * Set adResDetailDb
     *
     * @param string $adResDetailDb
     *
     * @return AdResDetail
     */
    public function setAdResDetailDb($adResDetailDb)
    {
        $this->adResDetailDb = $adResDetailDb;

        return $this;
    }

    /**
     * Get adResDetailDb
     *
     * @return string
     */
    public function getAdResDetailDb()
    {
        return $this->adResDetailDb;
    }

    /**
     * Set adResDetailId
     *
     * @param integer $adResDetailId
     *
     * @return AdResDetail
     */
    public function setAdResDetailId($adResDetailId)
    {
        $this->adResDetailId = $adResDetailId;

        return $this;
    }

    /**
     * Get adResDetailId
     *
     * @return integer
     */
    public function getAdResDetailId()
    {
        return $this->adResDetailId;
    }

    /**
     * Set adResDetailValueFrom
     *
     * @param string $adResDetailValueFrom
     *
     * @return AdResDetail
     */
    public function setAdResDetailValueFrom($adResDetailValueFrom)
    {
        $this->adResDetailValueFrom = $adResDetailValueFrom;

        return $this;
    }

    /**
     * Get adResDetailValueFrom
     *
     * @return string
     */
    public function getAdResDetailValueFrom()
    {
        return $this->adResDetailValueFrom;
    }

    /**
     * Set adResDetailValueTo
     *
     * @param string $adResDetailValueTo
     *
     * @return AdResDetail
     */
    public function setAdResDetailValueTo($adResDetailValueTo)
    {
        $this->adResDetailValueTo = $adResDetailValueTo;

        return $this;
    }

    /**
     * Get adResDetailValueTo
     *
     * @return string
     */
    public function getAdResDetailValueTo()
    {
        return $this->adResDetailValueTo;
    }

    /**
     * Set adResDetailValueFromDisplay
     *
     * @param string $adResDetailValueFromDisplay
     *
     * @return AdResDetail
     */
    public function setAdResDetailValueFromDisplay($adResDetailValueFromDisplay)
    {
        $this->adResDetailValueFromDisplay = $adResDetailValueFromDisplay;

        return $this;
    }

    /**
     * Get adResDetailValueFromDisplay
     *
     * @return string
     */
    public function getAdResDetailValueFromDisplay()
    {
        return $this->adResDetailValueFromDisplay;
    }

    /**
     * Set adResDetailValueToDisplay
     *
     * @param string $adResDetailValueToDisplay
     *
     * @return AdResDetail
     */
    public function setAdResDetailValueToDisplay($adResDetailValueToDisplay)
    {
        $this->adResDetailValueToDisplay = $adResDetailValueToDisplay;

        return $this;
    }

    /**
     * Get adResDetailValueToDisplay
     *
     * @return string
     */
    public function getAdResDetailValueToDisplay()
    {
        return $this->adResDetailValueToDisplay;
    }

    /**
     * Set adResDetailIdFrom
     *
     * @param string $adResDetailIdFrom
     *
     * @return AdResDetail
     */
    public function setAdResDetailIdFrom($adResDetailIdFrom)
    {
        $this->adResDetailIdFrom = $adResDetailIdFrom;

        return $this;
    }

    /**
     * Get adResDetailIdFrom
     *
     * @return string
     */
    public function getAdResDetailIdFrom()
    {
        return $this->adResDetailIdFrom;
    }

    /**
     * Set adResDetailIdTo
     *
     * @param string $adResDetailIdTo
     *
     * @return AdResDetail
     */
    public function setAdResDetailIdTo($adResDetailIdTo)
    {
        $this->adResDetailIdTo = $adResDetailIdTo;

        return $this;
    }

    /**
     * Get adResDetailIdTo
     *
     * @return string
     */
    public function getAdResDetailIdTo()
    {
        return $this->adResDetailIdTo;
    }

    /**
     * Set adResDetailActionInd
     *
     * @param integer $adResDetailActionInd
     *
     * @return AdResDetail
     */
    public function setAdResDetailActionInd($adResDetailActionInd)
    {
        $this->adResDetailActionInd = $adResDetailActionInd;

        return $this;
    }

    /**
     * Get adResDetailActionInd
     *
     * @return integer
     */
    public function getAdResDetailActionInd()
    {
        return $this->adResDetailActionInd;
    }

    /**
     * Set adReservationId
     *
     * @param string $adReservationId
     *
     * @return AdResDetail
     */
    public function setAdReservationId($adReservationId)
    {
        $this->adReservationId = $adReservationId;

        return $this;
    }

    /**
     * Get adReservationId
     *
     * @return string
     */
    public function getAdReservationId()
    {
        return $this->adReservationId;
    }

    /**
     * Set adModuleFieldId
     *
     * @param string $adModuleFieldId
     *
     * @return AdResDetail
     */
    public function setAdModuleFieldId($adModuleFieldId)
    {
        $this->adModuleFieldId = $adModuleFieldId;

        return $this;
    }

    /**
     * Get adModuleFieldId
     *
     * @return string
     */
    public function getAdModuleFieldId()
    {
        return $this->adModuleFieldId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return AdResDetail
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set adResDetailTrfYn
     *
     * @param boolean $adResDetailTrfYn
     *
     * @return AdResDetail
     */
    public function setAdResDetailTrfYn($adResDetailTrfYn)
    {
        $this->adResDetailTrfYn = $adResDetailTrfYn;

        return $this;
    }

    /**
     * Get adResDetailTrfYn
     *
     * @return boolean
     */
    public function getAdResDetailTrfYn()
    {
        return $this->adResDetailTrfYn;
    }
}
