<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * AdReservation
 *
 * @ORM\Table(name="ad_reservation", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="dt_temp_id", columns={"dt_temp_id"}), @ORM\Index(name="rv_reservation_ix", columns={"rv_reservation_id"}), @ORM\Index(name="ad_reservation_trf_yn", columns={"ad_reservation_trf_yn"}), @ORM\Index(name="pr_user_id", columns={"pr_user_id"}), @ORM\Index(name="rf_database_id", columns={"rf_database_id"})})
 * @ORM\Entity
 */
class AdReservation
{
    /**
     * @var string
     *
     * @ORM\Column(name="ad_reservation_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $adReservationIx;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_reservation_db", type="string", length=2, nullable=false, options={"default"="RS", "fixed"="true"})
     */
    private $adReservationDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="ad_reservation_id", type="integer", nullable=false)
     */
    private $adReservationId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_res_time", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adResTime;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_res_time_tz", type="string", length=40, nullable=false)
     */
    private $adResTimeTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_res_form", type="text", length=65535, nullable=true)
     */
    private $adResForm;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_user_id", type="string", length=36, nullable=true)
     */
    private $prUserId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_database_id", type="string", length=36, nullable=true)
     */
    private $rfDatabaseId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_reservation_id", type="string", length=36, nullable=true)
     */
    private $rvReservationId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="ad_reservation_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $adReservationTrfYn;



    /**
     * Get adReservationIx
     *
     * @return string
     */
    public function getAdReservationIx()
    {
        return $this->adReservationIx;
    }

    /**
     * Set adReservationDb
     *
     * @param string $adReservationDb
     *
     * @return AdReservation
     */
    public function setAdReservationDb($adReservationDb)
    {
        $this->adReservationDb = $adReservationDb;

        return $this;
    }

    /**
     * Get adReservationDb
     *
     * @return string
     */
    public function getAdReservationDb()
    {
        return $this->adReservationDb;
    }

    /**
     * Set adReservationId
     *
     * @param integer $adReservationId
     *
     * @return AdReservation
     */
    public function setAdReservationId($adReservationId)
    {
        $this->adReservationId = $adReservationId;

        return $this;
    }

    /**
     * Get adReservationId
     *
     * @return integer
     */
    public function getAdReservationId()
    {
        return $this->adReservationId;
    }

    /**
     * Set adResTime
     *
     * @param \DateTime $adResTime
     *
     * @return AdReservation
     */
    public function setAdResTime($adResTime)
    {
        $this->adResTime = $adResTime;

        return $this;
    }

    /**
     * Get adResTime
     *
     * @return \DateTime
     */
    public function getAdResTime()
    {
        return $this->adResTime;
    }

    /**
     * Set adResTimeTz
     *
     * @param string $adResTimeTz
     *
     * @return AdReservation
     */
    public function setAdResTimeTz($adResTimeTz)
    {
        $this->adResTimeTz = $adResTimeTz;

        return $this;
    }

    /**
     * Get adResTimeTz
     *
     * @return string
     */
    public function getAdResTimeTz()
    {
        return $this->adResTimeTz;
    }

    /**
     * Set adResForm
     *
     * @param string $adResForm
     *
     * @return AdReservation
     */
    public function setAdResForm($adResForm)
    {
        $this->adResForm = $adResForm;

        return $this;
    }

    /**
     * Get adResForm
     *
     * @return string
     */
    public function getAdResForm()
    {
        return $this->adResForm;
    }

    /**
     * Set prUserId
     *
     * @param string $prUserId
     *
     * @return AdReservation
     */
    public function setPrUserId($prUserId)
    {
        $this->prUserId = $prUserId;

        return $this;
    }

    /**
     * Get prUserId
     *
     * @return string
     */
    public function getPrUserId()
    {
        return $this->prUserId;
    }

    /**
     * Set rfDatabaseId
     *
     * @param string $rfDatabaseId
     *
     * @return AdReservation
     */
    public function setRfDatabaseId($rfDatabaseId)
    {
        $this->rfDatabaseId = $rfDatabaseId;

        return $this;
    }

    /**
     * Get rfDatabaseId
     *
     * @return string
     */
    public function getRfDatabaseId()
    {
        return $this->rfDatabaseId;
    }

    /**
     * Set rvReservationId
     *
     * @param string $rvReservationId
     *
     * @return AdReservation
     */
    public function setRvReservationId($rvReservationId)
    {
        $this->rvReservationId = $rvReservationId;

        return $this;
    }

    /**
     * Get rvReservationId
     *
     * @return string
     */
    public function getRvReservationId()
    {
        return $this->rvReservationId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return AdReservation
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set adReservationTrfYn
     *
     * @param boolean $adReservationTrfYn
     *
     * @return AdReservation
     */
    public function setAdReservationTrfYn($adReservationTrfYn)
    {
        $this->adReservationTrfYn = $adReservationTrfYn;

        return $this;
    }

    /**
     * Get adReservationTrfYn
     *
     * @return boolean
     */
    public function getAdReservationTrfYn()
    {
        return $this->adReservationTrfYn;
    }
}
