<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * AdUserLog
 *
 * @ORM\Table(name="ad_user_log", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="dt_temp_id", columns={"dt_temp_id"}), @ORM\Index(name="ad_user_log_trf_yn", columns={"ad_user_log_trf_yn"})})
 * @ORM\Entity
 */
class AdUserLog
{
    /**
     * @var string
     *
     * @ORM\Column(name="ad_user_log_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $adUserLogIx;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_user_log_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $adUserLogDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="ad_user_log_id", type="integer", nullable=false)
     */
    private $adUserLogId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_date_time", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adDateTime;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_date_time_tz", type="string", length=40, nullable=false)
     */
    private $adDateTimeTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_ip_address", type="string", length=50, nullable=true)
     */
    private $adIpAddress;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_user_agent", type="string", length=255, nullable=false)
     */
    private $adUserAgent;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_name_first", type="string", length=50, nullable=true)
     */
    private $prNameFirst;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_name_last", type="string", length=95, nullable=false, options={"default"=""})
     */
    private $prNameLast;

    /**
     * @var string
     *
     * @ORM\Column(name="sc_grp_desc", type="string", length=50, nullable=false, options={"default"=""})
     */
    private $scGrpDesc;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_user_id", type="string", length=36, nullable=true)
     */
    private $prUserId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="ad_user_status", type="boolean", nullable=false, options={"default"="0"})
     */
    private $adUserStatus;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="ad_user_log_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $adUserLogTrfYn;



    /**
     * Get adUserLogIx
     *
     * @return string
     */
    public function getAdUserLogIx()
    {
        return $this->adUserLogIx;
    }

    /**
     * Set adUserLogDb
     *
     * @param string $adUserLogDb
     *
     * @return AdUserLog
     */
    public function setAdUserLogDb($adUserLogDb)
    {
        $this->adUserLogDb = $adUserLogDb;

        return $this;
    }

    /**
     * Get adUserLogDb
     *
     * @return string
     */
    public function getAdUserLogDb()
    {
        return $this->adUserLogDb;
    }

    /**
     * Set adUserLogId
     *
     * @param integer $adUserLogId
     *
     * @return AdUserLog
     */
    public function setAdUserLogId($adUserLogId)
    {
        $this->adUserLogId = $adUserLogId;

        return $this;
    }

    /**
     * Get adUserLogId
     *
     * @return integer
     */
    public function getAdUserLogId()
    {
        return $this->adUserLogId;
    }

    /**
     * Set adDateTime
     *
     * @param \DateTime $adDateTime
     *
     * @return AdUserLog
     */
    public function setAdDateTime($adDateTime)
    {
        $this->adDateTime = $adDateTime;

        return $this;
    }

    /**
     * Get adDateTime
     *
     * @return \DateTime
     */
    public function getAdDateTime()
    {
        return $this->adDateTime;
    }

    /**
     * Set adDateTimeTz
     *
     * @param string $adDateTimeTz
     *
     * @return AdUserLog
     */
    public function setAdDateTimeTz($adDateTimeTz)
    {
        $this->adDateTimeTz = $adDateTimeTz;

        return $this;
    }

    /**
     * Get adDateTimeTz
     *
     * @return string
     */
    public function getAdDateTimeTz()
    {
        return $this->adDateTimeTz;
    }

    /**
     * Set adIpAddress
     *
     * @param string $adIpAddress
     *
     * @return AdUserLog
     */
    public function setAdIpAddress($adIpAddress)
    {
        $this->adIpAddress = $adIpAddress;

        return $this;
    }

    /**
     * Get adIpAddress
     *
     * @return string
     */
    public function getAdIpAddress()
    {
        return $this->adIpAddress;
    }

    /**
     * Set adUserAgent
     *
     * @param string $adUserAgent
     *
     * @return AdUserLog
     */
    public function setAdUserAgent($adUserAgent)
    {
        $this->adUserAgent = $adUserAgent;

        return $this;
    }

    /**
     * Get adUserAgent
     *
     * @return string
     */
    public function getAdUserAgent()
    {
        return $this->adUserAgent;
    }

    /**
     * Set prNameFirst
     *
     * @param string $prNameFirst
     *
     * @return AdUserLog
     */
    public function setPrNameFirst($prNameFirst)
    {
        $this->prNameFirst = $prNameFirst;

        return $this;
    }

    /**
     * Get prNameFirst
     *
     * @return string
     */
    public function getPrNameFirst()
    {
        return $this->prNameFirst;
    }

    /**
     * Set prNameLast
     *
     * @param string $prNameLast
     *
     * @return AdUserLog
     */
    public function setPrNameLast($prNameLast)
    {
        $this->prNameLast = $prNameLast;

        return $this;
    }

    /**
     * Get prNameLast
     *
     * @return string
     */
    public function getPrNameLast()
    {
        return $this->prNameLast;
    }

    /**
     * Set scGrpDesc
     *
     * @param string $scGrpDesc
     *
     * @return AdUserLog
     */
    public function setScGrpDesc($scGrpDesc)
    {
        $this->scGrpDesc = $scGrpDesc;

        return $this;
    }

    /**
     * Get scGrpDesc
     *
     * @return string
     */
    public function getScGrpDesc()
    {
        return $this->scGrpDesc;
    }

    /**
     * Set prUserId
     *
     * @param string $prUserId
     *
     * @return AdUserLog
     */
    public function setPrUserId($prUserId)
    {
        $this->prUserId = $prUserId;

        return $this;
    }

    /**
     * Get prUserId
     *
     * @return string
     */
    public function getPrUserId()
    {
        return $this->prUserId;
    }

    /**
     * Set adUserStatus
     *
     * @param boolean $adUserStatus
     *
     * @return AdUserLog
     */
    public function setAdUserStatus($adUserStatus)
    {
        $this->adUserStatus = $adUserStatus;

        return $this;
    }

    /**
     * Get adUserStatus
     *
     * @return boolean
     */
    public function getAdUserStatus()
    {
        return $this->adUserStatus;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return AdUserLog
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set adUserLogTrfYn
     *
     * @param boolean $adUserLogTrfYn
     *
     * @return AdUserLog
     */
    public function setAdUserLogTrfYn($adUserLogTrfYn)
    {
        $this->adUserLogTrfYn = $adUserLogTrfYn;

        return $this;
    }

    /**
     * Get adUserLogTrfYn
     *
     * @return boolean
     */
    public function getAdUserLogTrfYn()
    {
        return $this->adUserLogTrfYn;
    }
}
