<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * AdUseraccess
 *
 * @ORM\Table(name="ad_useraccess", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="ad_useraccess_trf_yn", columns={"ad_useraccess_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class AdUseraccess
{
    /**
     * @var string
     *
     * @ORM\Column(name="ad_useraccess_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $adUseraccessIx;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_useraccess_db", type="string", length=2, nullable=false, options={"default"="RS", "fixed"="true"})
     */
    private $adUseraccessDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="ad_useraccess_id", type="integer", nullable=false)
     */
    private $adUseraccessId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_useraccess_time", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adUseraccessTime;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_useraccess_time_tz", type="string", length=40, nullable=false)
     */
    private $adUseraccessTimeTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_useraccess_form", type="text", length=65535, nullable=false)
     */
    private $adUseraccessForm;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_user_id", type="string", length=36, nullable=true)
     */
    private $prUserId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_database_id", type="integer", nullable=true)
     */
    private $rfDatabaseId;

    /**
     * @var string
     *
     * @ORM\Column(name="sc_group_id", type="integer", nullable=true)
     */
    private $scGroupId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="ad_useraccess_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $adUseraccessTrfYn;



    /**
     * Get adUseraccessIx
     *
     * @return string
     */
    public function getAdUseraccessIx()
    {
        return $this->adUseraccessIx;
    }

    /**
     * Set adUseraccessDb
     *
     * @param string $adUseraccessDb
     *
     * @return AdUseraccess
     */
    public function setAdUseraccessDb($adUseraccessDb)
    {
        $this->adUseraccessDb = $adUseraccessDb;

        return $this;
    }

    /**
     * Get adUseraccessDb
     *
     * @return string
     */
    public function getAdUseraccessDb()
    {
        return $this->adUseraccessDb;
    }

    /**
     * Set adUseraccessId
     *
     * @param integer $adUseraccessId
     *
     * @return AdUseraccess
     */
    public function setAdUseraccessId($adUseraccessId)
    {
        $this->adUseraccessId = $adUseraccessId;

        return $this;
    }

    /**
     * Get adUseraccessId
     *
     * @return integer
     */
    public function getAdUseraccessId()
    {
        return $this->adUseraccessId;
    }

    /**
     * Set adUseraccessTime
     *
     * @param \DateTime $adUseraccessTime
     *
     * @return AdUseraccess
     */
    public function setAdUseraccessTime($adUseraccessTime)
    {
        $this->adUseraccessTime = $adUseraccessTime;

        return $this;
    }

    /**
     * Get adUseraccessTime
     *
     * @return \DateTime
     */
    public function getAdUseraccessTime()
    {
        return $this->adUseraccessTime;
    }

    /**
     * Set adUseraccessTimeTz
     *
     * @param string $adUseraccessTimeTz
     *
     * @return AdUseraccess
     */
    public function setAdUseraccessTimeTz($adUseraccessTimeTz)
    {
        $this->adUseraccessTimeTz = $adUseraccessTimeTz;

        return $this;
    }

    /**
     * Get adUseraccessTimeTz
     *
     * @return string
     */
    public function getAdUseraccessTimeTz()
    {
        return $this->adUseraccessTimeTz;
    }

    /**
     * Set adUseraccessForm
     *
     * @param string $adUseraccessForm
     *
     * @return AdUseraccess
     */
    public function setAdUseraccessForm($adUseraccessForm)
    {
        $this->adUseraccessForm = $adUseraccessForm;

        return $this;
    }

    /**
     * Get adUseraccessForm
     *
     * @return string
     */
    public function getAdUseraccessForm()
    {
        return $this->adUseraccessForm;
    }

    /**
     * Set prUserId
     *
     * @param string $prUserId
     *
     * @return AdUseraccess
     */
    public function setPrUserId($prUserId)
    {
        $this->prUserId = $prUserId;

        return $this;
    }

    /**
     * Get prUserId
     *
     * @return string
     */
    public function getPrUserId()
    {
        return $this->prUserId;
    }

    /**
     * Set rfDatabaseId
     *
     * @param string $rfDatabaseId
     *
     * @return AdUseraccess
     */
    public function setRfDatabaseId($rfDatabaseId)
    {
        $this->rfDatabaseId = $rfDatabaseId;

        return $this;
    }

    /**
     * Get rfDatabaseId
     *
     * @return string
     */
    public function getRfDatabaseId()
    {
        return $this->rfDatabaseId;
    }

    /**
     * Set scGroupId
     *
     * @param string $scGroupId
     *
     * @return AdUseraccess
     */
    public function setScGroupId($scGroupId)
    {
        $this->scGroupId = $scGroupId;

        return $this;
    }

    /**
     * Get scGroupId
     *
     * @return string
     */
    public function getScGroupId()
    {
        return $this->scGroupId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return AdUseraccess
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set adUseraccessTrfYn
     *
     * @param boolean $adUseraccessTrfYn
     *
     * @return AdUseraccess
     */
    public function setAdUseraccessTrfYn($adUseraccessTrfYn)
    {
        $this->adUseraccessTrfYn = $adUseraccessTrfYn;

        return $this;
    }

    /**
     * Get adUseraccessTrfYn
     *
     * @return boolean
     */
    public function getAdUseraccessTrfYn()
    {
        return $this->adUseraccessTrfYn;
    }
}
