<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * AwWorkflow
 *
 * @ORM\Table(name="aw_workflow", indexes={@ORM\Index(name="aw_workflow_trigger_id", columns={"aw_workflow_trigger_id"}), @ORM\Index(name="ad_create_user_id", columns={"ad_create_user_id"}), @ORM\Index(name="ad_delete_user_id", columns={"ad_delete_user_id"}), @ORM\Index(name="ad_modify_user_id", columns={"ad_modify_user_id"})})
 * @ORM\Entity
 */
class AwWorkflow
{
    const AW_WORKFLOW_TYPE_GUEST_CHECKIN_REMINDER = 0;
    const AW_WORKFLOW_TYPE_PROV_EXPIRY_REMINDER = 1;
    const AW_WORKFLOW_TYPE_PAYMENTS_DUE = 2;
    const AW_WORKFLOW_BEFORE = 0;
    const AW_WORKFLOW_AFTER = 1;
    
    /**
     * @var string
     *
     * @ORM\Column(name="aw_workflow_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $awWorkflowIx;

    /**
     * @var string
     *
     * @ORM\Column(name="aw_workflow_db", type="string", length=2, nullable=false)
     */
    private $awWorkflowDb = 'RS';

    /**
     * @var integer
     *
     * @ORM\Column(name="aw_workflow_id", type="integer", nullable=false)
     */
    private $awWorkflowId = '0';

    /**
     * @var string
     *
     * @ORM\Column(name="aw_workflow_name", type="string", length=50, nullable=false)
     */
    private $awWorkflowName;

    /**
     * @var string
     *
     * @ORM\Column(name="aw_workflow_description", type="string", length=200, nullable=false)
     */
    private $awWorkflowDescription;

    /**
     * @var integer
     *
     * @ORM\Column(name="aw_workflow_type_ind", type="integer", nullable=false)
     */
    private $awWorkflowTypeInd = 0;

    /**
     * @var integer
     *
     * @ORM\Column(name="aw_workflow_inactive_yn", type="integer", nullable=false)
     */
    private $awWorkflowInactiveYn = '0';

    /**
     * @var integer
     *
     * @ORM\Column(name="aw_workflow_schedule_days", type="integer", nullable=false)
     */
    private $awWorkflowScheduleDays = '0';

    /**
     * @var integer
     *
     * @ORM\Column(name="aw_workflow_before_after_ind", type="integer", nullable=true)
     */
    private $awWorkflowBeforeAfterInd;

    /**
     * @var string
     *
     * @ORM\Column(name="aw_workflow_config", type="json_array", nullable=false)
     */
    private $awWorkflowConfig;


    /**
     * @var string
     *
     * @ORM\Column(name="aw_workflow_time", type="string", nullable=true)
     */
    private $awWorkflowTime;

    /**
     * @var string
     *
     * @ORM\Column(name="aw_workflow_time_tz", type="string", length=40, nullable=false)
     */
    private $awWorkflowTimeTz;

    /**
     * @var string
     *
     * @ORM\Column(name="aw_workflow_last_run_timestamp", type="string", nullable=true)
     */
    private $awWorkflowLastRunTimestamp;

    /**
     * @var string
     *
     * @ORM\Column(name="aw_workflow_last_run_timestamp_tz", type="string", length=40, nullable=false)
     */
    private $awWorkflowLastRunTimestampTz;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_create_date", type="datetime", nullable=false)
     */
    private $adCreateDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_date_tz", type="string", length=40, nullable=false)
     */
    private $adCreateDateTz;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_delete_date", type="datetime", nullable=false)
     */
    private $adDeleteDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_delete_date_tz", type="string", length=40, nullable=false)
     */
    private $adDeleteDateTz;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_modify_date", type="datetime", nullable=false)
     */
    private $adModifyDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_date_tz", type="string", length=40, nullable=false)
     */
    private $adModifyDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var integer
     *
     * @ORM\Column(name="aw_workflow_trf_yn", type="integer", nullable=false)
     */
    private $awWorkflowTrfYn = '0';

    /**
     * @var string
     *
     * @ORM\Column(name="aw_workflow_trigger_id", type="integer", nullable=false)
     */
    private $awWorkflowTriggerId;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_user_id", type="string", length=36, nullable=true)
     */
    private $adCreateUserId;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_delete_user_id", type="string", length=36, nullable=true)
     */
    private $adDeleteUserId;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_user_id", type="string", length=36, nullable=true)
     */
    private $adModifyUserId;

    public function __construct() {
        $this->awWorkflowInactiveYn = '0';
        $this->adCreateDate = new \DateTime();
        $this->adCreateDateTz = date("e");
        $this->adModifyDate = new \DateTime();
        $this->adModifyDateTz = date("e");
        $this->awWorkflowId = 0;
        $this->awWorkflowTrfYn = 0;
    }

    /**
     * Get awWorkflowIx
     *
     * @return string
     */
    public function getAwWorkflowIx()
    {
      return $this->awWorkflowIx;
    }

    /**
     * Set awWorkflowIx
     *
     * @param string $awWorkflowIx
     *
     * @return AwWorkflow
     */
    public function setAwWorkflowIx($awWorkflowIx)
    {
      $this->awWorkflowIx = $awWorkflowIx;

      return $this;
    }
    
    /**
      * Get awWorkflowDb
      *
      * @return string
      *
     */

    public function getAwWorkflowDb()
    {
      return $this->awWorkflowDb;
    }

    /**
     * Set awWorkflowDb
     *
     * @param string $awWorkflowDb
     *
     * @return AwWorkflow
     *
     */
    public function setAwWorkflowDb($awWorkflowDb)
    {
      $this->awWorkflowDb = $awWorkflowDb;

      return $this;
    }

    /**
     * Get awWorkflowId
     *
     * @return string
     *
     */

    public function getAwWorkflowId()
    {
      return $this->awWorkflowId;
    }

    /**
     * Set awWorkflowId
     *
     * @param string $awWorkflowId
     *
     * @return AwWorkflow
     *
     */
    public function setAwWorkflowId($awWorkflowId)
    {
      $this->awWorkflowId = $awWorkflowId;

      return $this;
    }

    /**
     * Get awWorkflowName
     *
     * @return string
     *
     */

    public function getAwWorkflowName()
    {
      return $this->awWorkflowName;
    }

    /**
     * Set awWorkflowName
     *
     * @param string $awWorkflowName
     *
     * @return AwWorkflow
     *
     */
    public function setAwWorkflowName($awWorkflowName)
    {
      $this->awWorkflowName = $awWorkflowName;

      return $this;
    }

    /**
     * Get awWorkflowDescription
     *
     * @return string
     *
     */

    public function getAwWorkflowDescription()
    {
      return $this->awWorkflowDescription;
    }

    /**
     * Set awWorkflowDescription
     *
     * @param string $awWorkflowDescription
     *
     * @return AwWorkflow
     *
     */
    public function setAwWorkflowDescription($awWorkflowDescription)
    {
      $this->awWorkflowDescription = $awWorkflowDescription;

      return $this;
    }

    /**
     * Get awWorkflowTypeInd
     *
     * @return string
     *
     */

    public function getAwWorkflowTypeInd()
    {
      return $this->awWorkflowTypeInd;
    }

    /**
     * Set awWorkflowTypeInd
     *
     * @param string $awWorkflowTypeInd
     *
     * @return AwWorkflow
     *
     */
    public function setAwWorkflowTypeInd($awWorkflowTypeInd)
    {
      $this->awWorkflowTypeInd = $awWorkflowTypeInd;

      return $this;
    }

    /**
     * Get awWorkflowInactiveYn
     *
     * @return string
     *
     */

    public function getAwWorkflowInactiveYn()
    {
      return $this->awWorkflowInactiveYn;
    }

    /**
     * Set awWorkflowInactiveYn
     *
     * @param string $awWorkflowInactiveYn
     *
     * @return AwWorkflow
     *
     */
    public function setAwWorkflowInactiveYn($awWorkflowInactiveYn)
    {
      $this->awWorkflowInactiveYn = $awWorkflowInactiveYn;

      return $this;
    }

    /**
     * Get awWorkflowScheduleDays
     *
     * @return string
     *
     */

    public function getAwWorkflowScheduleDays()
    {
      return $this->awWorkflowScheduleDays;
    }

    /**
     * Set awWorkflowScheduleDays
     *
     * @param string $awWorkflowScheduleDays
     *
     * @return AwWorkflow
     *
     */
    public function setAwWorkflowScheduleDays($awWorkflowScheduleDays)
    {
      $this->awWorkflowScheduleDays = $awWorkflowScheduleDays;

      return $this;
    }

    /**
     * Get awWorkflowBeforeAfterInd
     *
     * @return string
     *
     */

    public function getAwWorkflowBeforeAfterInd()
    {
      return $this->awWorkflowBeforeAfterInd;
    }

    /**
     * Get awWorkflowConfig
     *
     * @return array
     */
    public function getAwWorkflowConfig()
    {
        return $this->awWorkflowConfig;
    }

    /**
     * Set awWorkflowConfig
     *
     * @param string $awWorkflowConfig
     *
     * @return AwWorkflow
     *
     */
    public function setAwWorkflowConfig($awWorkflowConfig)
    {
      $this->awWorkflowConfig = $awWorkflowConfig;

      return $this;
    }

    /**
     * Set awWorkflowBeforeAfterInd
     *
     * @param string $awWorkflowBeforeAfterInd
     *
     * @return AwWorkflow
     *
     */
    public function setAwWorkflowBeforeAfterInd($awWorkflowBeforeAfterInd)
    {
      $this->awWorkflowBeforeAfterInd = $awWorkflowBeforeAfterInd;

      return $this;
    }

    /**
     * Get awWorkflowTime
     *
     * @return string
     *
     */

    public function getAwWorkflowTime()
    {
      return $this->awWorkflowTime;
    }

    /**
     * Set awWorkflowTime
     *
     * @param string $awWorkflowTime
     *
     * @return AwWorkflow
     *
     */
    public function setAwWorkflowTime($awWorkflowTime)
    {
      $this->awWorkflowTime = $awWorkflowTime;

      return $this;
    }

    /**
     * Get awWorkflowTimeTz
     *
     * @return string
     *
     */

    public function getAwWorkflowTimeTz()
    {
      return $this->awWorkflowTimeTz;
    }

    /**
     * Set awWorkflowTimeTz
     *
     * @param string $awWorkflowTimeTz
     *
     * @return AwWorkflow
     *
     */
    public function setAwWorkflowTimeTz($awWorkflowTimeTz)
    {
      $this->awWorkflowTimeTz = $awWorkflowTimeTz;

      return $this;
    }

    /**
     * Get awWorkflowLastRunTimestamp
     *
     * @return string
     *
     */

    public function getAwWorkflowLastRunTimestamp()
    {
      return $this->awWorkflowLastRunTimestamp;
    }

    /**
     * Set awWorkflowLastRunTimestamp
     *
     * @param string $awWorkflowLastRunTimestamp
     *
     * @return AwWorkflow
     *
     */
    public function setAwWorkflowLastRunTimestamp($awWorkflowLastRunTimestamp)
    {
      $this->awWorkflowLastRunTimestamp = $awWorkflowLastRunTimestamp;

      return $this;
    }

    /**
     * Get awWorkflowLastRunTimestampTz
     *
     * @return string
     *
     */

    public function getAwWorkflowLastRunTimestampTz()
    {
      return $this->awWorkflowLastRunTimestampTz;
    }

    /**
     * Set awWorkflowLastRunTimestampTz
     *
     * @param string $awWorkflowLastRunTimestampTz
     *
     * @return AwWorkflow
     *
     */
    public function setAwWorkflowLastRunTimestampTz($awWorkflowLastRunTimestampTz)
    {
      $this->awWorkflowLastRunTimestampTz = $awWorkflowLastRunTimestampTz;

      return $this;
    }

    /**
     * Get adCreateDate
     *
     * @return string
     *
     */
    public function getAdCreateDate()
    {
      return $this->adCreateDate;
    }

    /**
     * Set adCreateDate
     *
     * @param string $adCreateDate
     *
     * @return AwWorkflow
     *
     */
    public function setAdCreateDate($adCreateDate)
    {
      $this->adCreateDate = $adCreateDate;

      return $this;
    }

    /**
      * Get adCreateDateTz
      *
      * @return string
      *
     */
    public function getAdCreateDateTz()
    {
      return $this->adCreateDateTz;
    }

    /**
     * Set adCreateDateTz
     *
     * @param string $adCreateDateTz
     *
     * @return AwWorkflow
     *
     */
    public function setAdCreateDateTz($adCreateDateTz)
    {
      $this->adCreateDateTz = $adCreateDateTz;

      return $this;
    }

    /**
     * Get adDeleteDate
     *
     * @return string
     *
     */

    public function getAdDeleteDate()
    {
      return $this->adDeleteDate;
    }

    /**
     * Set adDeleteDate
     *
     * @param string $adDeleteDate
     *
     * @return AwWorkflow
     *
     */
    public function setAdDeleteDate($adDeleteDate)
    {
      $this->adDeleteDate = $adDeleteDate;

      return $this;
    }

    /**
     * Get adDeleteDateTz
     *
     * @return string
     *
     */

    public function getAdDeleteDateTz()
    {
      return $this->adDeleteDateTz;
    }

    /**
     * Set adDeleteDateTz
     *
     * @param string $adDeleteDateTz
     *
     * @return AwWorkflow
     *
     */
    public function setAdDeleteDateTz($adDeleteDateTz)
    {
      $this->adDeleteDateTz = $adDeleteDateTz;

      return $this;
    }

    /**
     * Get adModifyDate
     *
     * @return string
     *
     */

    public function getAdModifyDate()
    {
      return $this->adModifyDate;
    }

    /**
     * Set adModifyDate
     *
     * @param string $adModifyDate
     *
     * @return AwWorkflow
     *
     */
    public function setAdModifyDate($adModifyDate)
    {
      $this->adModifyDate = $adModifyDate;

      return $this;
    }

    /**
     * Get adModifyDateTz
     *
     * @return string
     *
     */

    public function getAdModifyDateTz()
    {
      return $this->adModifyDateTz;
    }

    /**
     * Set adModifyDateTz
     *
     * @param string $adModifyDateTz
     *
     * @return AwWorkflow
     *
     */
    public function setAdModifyDateTz($adModifyDateTz)
    {
      $this->adModifyDateTz = $adModifyDateTz;

      return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     *
     */

    public function getDtTempId()
    {
      return $this->dtTempId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return AwWorkflow
     *
     */
    public function setDtTempId($dtTempId)
    {
      $this->dtTempId = $dtTempId;

      return $this;
    }

    /**
     * Get awWorkflowTrfYn
     *
     * @return string
     *
     */
    public function getAwWorkflowTrfYn()
    {
      return $this->awWorkflowTrfYn;
    }

    /**
     * Set awWorkflowTrfYn
     *
     * @param string $awWorkflowTrfYn
     *
     * @return AwWorkflow
     *
     */
    public function setAwWorkflowTrfYn($awWorkflowTrfYn)
    {
      $this->awWorkflowTrfYn = $awWorkflowTrfYn;

      return $this;
    }

    /**
     * Get awWorkflowTriggerId
     *
     * @return string
     *
     */

    public function getAwWorkflowTriggerId()
    {
      return $this->awWorkflowTriggerId;
    }

    /**
     * Set awWorkflowTriggerId
     *
     * @param string $awWorkflowTriggerId
     *
     * @return AwWorkflow
     *
     */
    public function setAwWorkflowTriggerId($awWorkflowTriggerId)
    {
      $this->awWorkflowTriggerId = $awWorkflowTriggerId;

      return $this;
    }

    /**
     * Get adCreateUserId
     *
     * @return string
     *
     */

    public function getAdCreateUserId()
    {
      return $this->adCreateUserId;
    }

    /**
     * Set adCreateUserId
     *
     * @param string $adCreateUserId
     *
     * @return AwWorkflow
     *
     */
    public function setAdCreateUserId($adCreateUserId)
    {
      $this->adCreateUserId = $adCreateUserId;

      return $this;
    }

    /**
     * Get adDeleteUserId
     *
     * @return string
     *
     */
    public function getAdDeleteUserId()
    {
      return $this->adDeleteUserId;
    }

    /**
     * Set adDeleteUserId
     *
     * @param string $adDeleteUserId
     *
     * @return AwWorkflow
     *
     */
    public function setAdDeleteUserId($adDeleteUserId)
    {
      $this->adDeleteUserId = $adDeleteUserId;

      return $this;
    }

    /**
      * Get adModifyUserId
      *
      * @return string
      *
     */
    public function getAdModifyUserId()
    {
      return $this->adModifyUserId;
    }

    /**
     * Set adModifyUserId
     *
     * @param string $adModifyUserId
     *
     * @return AwWorkflow
     *
     */
    public function setAdModifyUserId($adModifyUserId)
    {
      $this->adModifyUserId = $adModifyUserId;

      return $this;
    }

    public static function getWorkflowTypeDescription($awWorkflowTypeInd)
    {
      switch ($awWorkflowTypeInd) {
        case '0':
          return "Guest check-in reminders";
          break;
        case '1':
          return "Provisional expiry reminders";
          break;
        case '2':
          return "Payments due reminders";
          break;
        default:
          return "Unknown";
          break;
      }
    }

    public static function getWorkflowBeforeAfterDescription($awWorkflowBeforeAfterInd)
    {
      switch ($awWorkflowBeforeAfterInd) {
        case '0':
          return "Before";
          break;
        case '1':
          return "After";
          break;
        default:
          return "Unknown";
          break;
      }
    }
}
