<?php

namespace Resrequest\DB\Enterprise\Entity;

/**
 * Base Entity class for common functionality
 */

class Base
{
	/**
	 * Magic getter to expose protected properties
	 *
	 * @param string $property
	 * @return mixed
	 */
	public function __get($property)
	{
		return $this->$property;
	}

	/**
	 * Magic setter to save protected properties
	 *
	 * @param string $property
	 * @param mixed $value
	 */
	public function __set($property, $value)
	{
		$this->$property = $value;
	}

	/**
	 * Magic isset to allow empty() to work
	 * @param string $property
	 */
	public function __isset($property)
	{
		return isset($this->$property);
	}

	/**
	 * Convert the object to an array
	 *
	 * @return array
	 */
	public function getArrayCopy()
	{
		return get_object_vars($this);
	}

	/**
	 * Populate from an array.
	 *
	 * @param array $data
	 */
	public function exchangeArray($data = array())
	{
		foreach(get_object_vars as $key=>$value) {
			if(array_key_exists($key,$data)) {
				$this->$key = $data[$key];
			} else {
				$this->$key = null;
			}
		}
	}
}
