<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * BlBlock
 *
 * @ORM\Table(name="bl_block", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="bl_block_trf_yn", columns={"bl_block_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"}), @ORM\Index(name="bl_block_id", columns={"bl_block_id"})}, uniqueConstraints={@ORM\UniqueConstraint(name="bl_block_name", columns={"bl_block_name"})})
 * @ORM\Entity
 */
class BlBlock
{
    /**
     * @var string
     *
     * @ORM\Column(name="bl_block_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $blBlockIx;

    /**
     * @var string
     *
     * @ORM\Column(name="bl_block_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $blBlockDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="bl_block_id", type="integer", nullable=false)
     */
    private $blBlockId;

    /**
     * @var string
     *
     * @ORM\Column(name="bl_block_name", type="string", length=191, nullable=true)
     */
    private $blBlockName;

    /**
     * @var string
     *
     * @ORM\Column(name="bl_block_abbrev", type="string", length=200, nullable=false)
     */
    private $blBlockAbbrev;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_consultant_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $rvConsultantId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_agent_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $rvAgentId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_agent_contact_persona_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $rvAgentContactPersonaId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_agent_ref", type="string", length=255, nullable=false, options={"default"=""})
     */
    private $rvAgentRef;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_rate_type_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $rtRateTypeId;

    /**
     * @var string
     *
     * @ORM\Column(name="bl_block_commission_perc", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.00"})
     */
    private $blBlockCommissionPerc;

    /**
     * @var string
     *
     * @ORM\Column(name="bl_block_note", type="text", length=65535, nullable=true)
     */
    private $blBlockNote;

    /**
     * @var string
     *
     * @ORM\Column(name="bl_block_note_internal", type="text", length=65535, nullable=true)
     */
    private $blBlockNoteInternal;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_create_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adCreateDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_date_tz", type="string", length=40, nullable=false)
     */
    private $adCreateDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_user_id", type="string", length=36, nullable=true)
     */
    private $adCreateUserId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_modify_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adModifyDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_date_tz", type="string", length=40, nullable=false)
     */
    private $adModifyDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_user_id", type="string", length=36, nullable=true)
     */
    private $adModifyUserId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="bl_block_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $blBlockTrfYn;



    /**
     * Get blBlockIx
     *
     * @return string
     */
    public function getBlBlockIx()
    {
        return $this->blBlockIx;
    }

    /**
     * Set blBlockDb
     *
     * @param string $blBlockDb
     *
     * @return BlBlock
     */
    public function setBlBlockDb($blBlockDb)
    {
        $this->blBlockDb = $blBlockDb;

        return $this;
    }

    /**
     * Get blBlockDb
     *
     * @return string
     */
    public function getBlBlockDb()
    {
        return $this->blBlockDb;
    }

    /**
     * Set blBlockId
     *
     * @param integer $blBlockId
     *
     * @return BlBlock
     */
    public function setBlBlockId($blBlockId)
    {
        $this->blBlockId = $blBlockId;

        return $this;
    }

    /**
     * Get blBlockId
     *
     * @return integer
     */
    public function getBlBlockId()
    {
        return $this->blBlockId;
    }

    /**
     * Set blBlockName
     *
     * @param string $blBlockName
     *
     * @return BlBlock
     */
    public function setBlBlockName($blBlockName)
    {
        $this->blBlockName = $blBlockName;

        return $this;
    }

    /**
     * Get blBlockName
     *
     * @return string
     */
    public function getBlBlockName()
    {
        return $this->blBlockName;
    }

    /**
     * Set blBlockAbbrev
     *
     * @param string $blBlockAbbrev
     *
     * @return BlBlock
     */
    public function setBlBlockAbbrev($blBlockAbbrev)
    {
        $this->blBlockAbbrev = $blBlockAbbrev;

        return $this;
    }

    /**
     * Get blBlockAbbrev
     *
     * @return string
     */
    public function getBlBlockAbbrev()
    {
        return $this->blBlockAbbrev;
    }

    /**
     * Set rvConsultantId
     *
     * @param string $rvConsultantId
     *
     * @return BlBlock
     */
    public function setRvConsultantId($rvConsultantId)
    {
        $this->rvConsultantId = $rvConsultantId;

        return $this;
    }

    /**
     * Get rvConsultantId
     *
     * @return string
     */
    public function getRvConsultantId()
    {
        return $this->rvConsultantId;
    }

    /**
     * Set rvAgentId
     *
     * @param string $rvAgentId
     *
     * @return BlBlock
     */
    public function setRvAgentId($rvAgentId)
    {
        $this->rvAgentId = $rvAgentId;

        return $this;
    }

    /**
     * Get rvAgentId
     *
     * @return string
     */
    public function getRvAgentId()
    {
        return $this->rvAgentId;
    }

    /**
     * Set rvAgentContactPersonaId
     *
     * @param string $rvAgentContactPersonaId
     *
     * @return BlBlock
     */
    public function setRvAgentContactPersonaId($rvAgentContactPersonaId)
    {
        $this->rvAgentContactPersonaId = $rvAgentContactPersonaId;

        return $this;
    }

    /**
     * Get rvAgentContactPersonaId
     *
     * @return string
     */
    public function getRvAgentContactPersonaId()
    {
        return $this->rvAgentContactPersonaId;
    }

    /**
     * Set rvAgentRef
     *
     * @param string $rvAgentRef
     *
     * @return BlBlock
     */
    public function setRvAgentRef($rvAgentRef)
    {
        $this->rvAgentRef = $rvAgentRef;

        return $this;
    }

    /**
     * Get rvAgentRef
     *
     * @return string
     */
    public function getRvAgentRef()
    {
        return $this->rvAgentRef;
    }

    /**
     * Set rtRateTypeId
     *
     * @param string $rtRateTypeId
     *
     * @return BlBlock
     */
    public function setRtRateTypeId($rtRateTypeId)
    {
        $this->rtRateTypeId = $rtRateTypeId;

        return $this;
    }

    /**
     * Get rtRateTypeId
     *
     * @return string
     */
    public function getRtRateTypeId()
    {
        return $this->rtRateTypeId;
    }

    /**
     * Set blBlockCommissionPerc
     *
     * @param string $blBlockCommissionPerc
     *
     * @return BlBlock
     */
    public function setBlBlockCommissionPerc($blBlockCommissionPerc)
    {
        $this->blBlockCommissionPerc = $blBlockCommissionPerc;

        return $this;
    }

    /**
     * Get blBlockCommissionPerc
     *
     * @return string
     */
    public function getBlBlockCommissionPerc()
    {
        return $this->blBlockCommissionPerc;
    }

    /**
     * Set blBlockNote
     *
     * @param string $blBlockNote
     *
     * @return BlBlock
     */
    public function setBlBlockNote($blBlockNote)
    {
        $this->blBlockNote = $blBlockNote;

        return $this;
    }

    /**
     * Get blBlockNote
     *
     * @return string
     */
    public function getBlBlockNote()
    {
        return $this->blBlockNote;
    }

    /**
     * Set blBlockNoteInternal
     *
     * @param string $blBlockNoteInternal
     *
     * @return BlBlock
     */
    public function setBlBlockNoteInternal($blBlockNoteInternal)
    {
        $this->blBlockNoteInternal = $blBlockNoteInternal;

        return $this;
    }

    /**
     * Get blBlockNoteInternal
     *
     * @return string
     */
    public function getBlBlockNoteInternal()
    {
        return $this->blBlockNoteInternal;
    }

    /**
     * Set adCreateDate
     *
     * @param \DateTime $adCreateDate
     *
     * @return BlBlock
     */
    public function setAdCreateDate($adCreateDate)
    {
        $this->adCreateDate = $adCreateDate;

        return $this;
    }

    /**
     * Get adCreateDate
     *
     * @return \DateTime
     */
    public function getAdCreateDate()
    {
        return $this->adCreateDate;
    }

    /**
     * Set adCreateDateTz
     *
     * @param string $adCreateDateTz
     *
     * @return BlBlock
     */
    public function setAdCreateDateTz($adCreateDateTz)
    {
        $this->adCreateDateTz = $adCreateDateTz;

        return $this;
    }

    /**
     * Get adCreateDateTz
     *
     * @return string
     */
    public function getAdCreateDateTz()
    {
        return $this->adCreateDateTz;
    }

    /**
     * Set adCreateUserId
     *
     * @param string $adCreateUserId
     *
     * @return BlBlock
     */
    public function setAdCreateUserId($adCreateUserId)
    {
        $this->adCreateUserId = $adCreateUserId;

        return $this;
    }

    /**
     * Get adCreateUserId
     *
     * @return string
     */
    public function getAdCreateUserId()
    {
        return $this->adCreateUserId;
    }

    /**
     * Set adModifyDate
     *
     * @param \DateTime $adModifyDate
     *
     * @return BlBlock
     */
    public function setAdModifyDate($adModifyDate)
    {
        $this->adModifyDate = $adModifyDate;

        return $this;
    }

    /**
     * Get adModifyDate
     *
     * @return \DateTime
     */
    public function getAdModifyDate()
    {
        return $this->adModifyDate;
    }

    /**
     * Set adModifyDateTz
     *
     * @param string $adModifyDateTz
     *
     * @return BlBlock
     */
    public function setAdModifyDateTz($adModifyDateTz)
    {
        $this->adModifyDateTz = $adModifyDateTz;

        return $this;
    }

    /**
     * Get adModifyDateTz
     *
     * @return string
     */
    public function getAdModifyDateTz()
    {
        return $this->adModifyDateTz;
    }

    /**
     * Set adModifyUserId
     *
     * @param string $adModifyUserId
     *
     * @return BlBlock
     */
    public function setAdModifyUserId($adModifyUserId)
    {
        $this->adModifyUserId = $adModifyUserId;

        return $this;
    }

    /**
     * Get adModifyUserId
     *
     * @return string
     */
    public function getAdModifyUserId()
    {
        return $this->adModifyUserId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return BlBlock
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set blBlockTrfYn
     *
     * @param boolean $blBlockTrfYn
     *
     * @return BlBlock
     */
    public function setBlBlockTrfYn($blBlockTrfYn)
    {
        $this->blBlockTrfYn = $blBlockTrfYn;

        return $this;
    }

    /**
     * Get blBlockTrfYn
     *
     * @return boolean
     */
    public function getBlBlockTrfYn()
    {
        return $this->blBlockTrfYn;
    }
}
