<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * BlBlockItinerary
 *
 * @ORM\Table(name="bl_block_itinerary", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="bl_block_itinerary_trf_yn", columns={"bl_block_itinerary_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"}), @ORM\Index(name="bl_block_itinerary_id", columns={"bl_block_itinerary_id"})})
 * @ORM\Entity
 */
class BlBlockItinerary
{
    /**
     * @var string
     *
     * @ORM\Column(name="bl_block_itinerary_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $blBlockItineraryIx;

    /**
     * @var string
     *
     * @ORM\Column(name="bl_block_itinerary_db", type="string", length=2, nullable=false, options={"default"="RS", "fixed"="true"})
     */
    private $blBlockItineraryDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="bl_block_itinerary_id", type="integer", nullable=false)
     */
    private $blBlockItineraryId;

    /**
     * @var string
     *
     * @ORM\Column(name="bl_block_period_id", type="string", length=36, nullable=true)
     */
    private $blBlockPeriodId;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_accomm_type_id", type="string", length=36, nullable=true)
     */
    private $acAccommTypeId;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_rate_type_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $rtRateTypeId;

    /**
     * @var integer
     *
     * @ORM\Column(name="bl_itinerary_day_start", type="integer", nullable=false)
     */
    private $blItineraryDayStart;

    /**
     * @var integer
     *
     * @ORM\Column(name="bl_itinerary_day_end", type="integer", nullable=false)
     */
    private $blItineraryDayEnd;

    /**
     * @var integer
     *
     * @ORM\Column(name="bl_block_itinerary_rooms", type="integer", nullable=false)
     */
    private $blBlockItineraryRooms;

    /**
     * @var integer
     *
     * @ORM\Column(name="bl_block_itinerary_pax", type="integer", nullable=false)
     */
    private $blBlockItineraryPax;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_create_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adCreateDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_date_tz", type="string", length=40, nullable=false)
     */
    private $adCreateDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_user_id", type="string", length=36, nullable=true)
     */
    private $adCreateUserId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_modify_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adModifyDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_date_tz", type="string", length=40, nullable=false)
     */
    private $adModifyDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_user_id", type="string", length=36, nullable=true)
     */
    private $adModifyUserId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="bl_block_itinerary_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $blBlockItineraryTrfYn;



    /**
     * Get blBlockItineraryIx
     *
     * @return string
     */
    public function getBlBlockItineraryIx()
    {
        return $this->blBlockItineraryIx;
    }

    /**
     * Set blBlockItineraryDb
     *
     * @param string $blBlockItineraryDb
     *
     * @return BlBlockItinerary
     */
    public function setBlBlockItineraryDb($blBlockItineraryDb)
    {
        $this->blBlockItineraryDb = $blBlockItineraryDb;

        return $this;
    }

    /**
     * Get blBlockItineraryDb
     *
     * @return string
     */
    public function getBlBlockItineraryDb()
    {
        return $this->blBlockItineraryDb;
    }

    /**
     * Set blBlockItineraryId
     *
     * @param integer $blBlockItineraryId
     *
     * @return BlBlockItinerary
     */
    public function setBlBlockItineraryId($blBlockItineraryId)
    {
        $this->blBlockItineraryId = $blBlockItineraryId;

        return $this;
    }

    /**
     * Get blBlockItineraryId
     *
     * @return integer
     */
    public function getBlBlockItineraryId()
    {
        return $this->blBlockItineraryId;
    }

    /**
     * Set blBlockPeriodId
     *
     * @param string $blBlockPeriodId
     *
     * @return BlBlockItinerary
     */
    public function setBlBlockPeriodId($blBlockPeriodId)
    {
        $this->blBlockPeriodId = $blBlockPeriodId;

        return $this;
    }

    /**
     * Get blBlockPeriodId
     *
     * @return string
     */
    public function getBlBlockPeriodId()
    {
        return $this->blBlockPeriodId;
    }

    /**
     * Set acAccommTypeId
     *
     * @param string $acAccommTypeId
     *
     * @return BlBlockItinerary
     */
    public function setAcAccommTypeId($acAccommTypeId)
    {
        $this->acAccommTypeId = $acAccommTypeId;

        return $this;
    }

    /**
     * Get acAccommTypeId
     *
     * @return string
     */
    public function getAcAccommTypeId()
    {
        return $this->acAccommTypeId;
    }

    /**
     * Set rtRateTypeId
     *
     * @param string $rtRateTypeId
     *
     * @return BlBlockItinerary
     */
    public function setRtRateTypeId($rtRateTypeId)
    {
        $this->rtRateTypeId = $rtRateTypeId;

        return $this;
    }

    /**
     * Get rtRateTypeId
     *
     * @return string
     */
    public function getRtRateTypeId()
    {
        return $this->rtRateTypeId;
    }

    /**
     * Set blItineraryDayStart
     *
     * @param integer $blItineraryDayStart
     *
     * @return BlBlockItinerary
     */
    public function setBlItineraryDayStart($blItineraryDayStart)
    {
        $this->blItineraryDayStart = $blItineraryDayStart;

        return $this;
    }

    /**
     * Get blItineraryDayStart
     *
     * @return integer
     */
    public function getBlItineraryDayStart()
    {
        return $this->blItineraryDayStart;
    }

    /**
     * Set blItineraryDayEnd
     *
     * @param integer $blItineraryDayEnd
     *
     * @return BlBlockItinerary
     */
    public function setBlItineraryDayEnd($blItineraryDayEnd)
    {
        $this->blItineraryDayEnd = $blItineraryDayEnd;

        return $this;
    }

    /**
     * Get blItineraryDayEnd
     *
     * @return integer
     */
    public function getBlItineraryDayEnd()
    {
        return $this->blItineraryDayEnd;
    }

    /**
     * Set blBlockItineraryRooms
     *
     * @param integer $blBlockItineraryRooms
     *
     * @return BlBlockItinerary
     */
    public function setBlBlockItineraryRooms($blBlockItineraryRooms)
    {
        $this->blBlockItineraryRooms = $blBlockItineraryRooms;

        return $this;
    }

    /**
     * Get blBlockItineraryRooms
     *
     * @return integer
     */
    public function getBlBlockItineraryRooms()
    {
        return $this->blBlockItineraryRooms;
    }

    /**
     * Set blBlockItineraryPax
     *
     * @param integer $blBlockItineraryPax
     *
     * @return BlBlockItinerary
     */
    public function setBlBlockItineraryPax($blBlockItineraryPax)
    {
        $this->blBlockItineraryPax = $blBlockItineraryPax;

        return $this;
    }

    /**
     * Get blBlockItineraryPax
     *
     * @return integer
     */
    public function getBlBlockItineraryPax()
    {
        return $this->blBlockItineraryPax;
    }

    /**
     * Set adCreateDate
     *
     * @param \DateTime $adCreateDate
     *
     * @return BlBlockItinerary
     */
    public function setAdCreateDate($adCreateDate)
    {
        $this->adCreateDate = $adCreateDate;

        return $this;
    }

    /**
     * Get adCreateDate
     *
     * @return \DateTime
     */
    public function getAdCreateDate()
    {
        return $this->adCreateDate;
    }

    /**
     * Set adCreateDateTz
     *
     * @param string $adCreateDateTz
     *
     * @return BlBlockItinerary
     */
    public function setAdCreateDateTz($adCreateDateTz)
    {
        $this->adCreateDateTz = $adCreateDateTz;

        return $this;
    }

    /**
     * Get adCreateDateTz
     *
     * @return string
     */
    public function getAdCreateDateTz()
    {
        return $this->adCreateDateTz;
    }

    /**
     * Set adCreateUserId
     *
     * @param string $adCreateUserId
     *
     * @return BlBlockItinerary
     */
    public function setAdCreateUserId($adCreateUserId)
    {
        $this->adCreateUserId = $adCreateUserId;

        return $this;
    }

    /**
     * Get adCreateUserId
     *
     * @return string
     */
    public function getAdCreateUserId()
    {
        return $this->adCreateUserId;
    }

    /**
     * Set adModifyDate
     *
     * @param \DateTime $adModifyDate
     *
     * @return BlBlockItinerary
     */
    public function setAdModifyDate($adModifyDate)
    {
        $this->adModifyDate = $adModifyDate;

        return $this;
    }

    /**
     * Get adModifyDate
     *
     * @return \DateTime
     */
    public function getAdModifyDate()
    {
        return $this->adModifyDate;
    }

    /**
     * Set adModifyDateTz
     *
     * @param string $adModifyDateTz
     *
     * @return BlBlockItinerary
     */
    public function setAdModifyDateTz($adModifyDateTz)
    {
        $this->adModifyDateTz = $adModifyDateTz;

        return $this;
    }

    /**
     * Get adModifyDateTz
     *
     * @return string
     */
    public function getAdModifyDateTz()
    {
        return $this->adModifyDateTz;
    }

    /**
     * Set adModifyUserId
     *
     * @param string $adModifyUserId
     *
     * @return BlBlockItinerary
     */
    public function setAdModifyUserId($adModifyUserId)
    {
        $this->adModifyUserId = $adModifyUserId;

        return $this;
    }

    /**
     * Get adModifyUserId
     *
     * @return string
     */
    public function getAdModifyUserId()
    {
        return $this->adModifyUserId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return BlBlockItinerary
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set blBlockItineraryTrfYn
     *
     * @param boolean $blBlockItineraryTrfYn
     *
     * @return BlBlockItinerary
     */
    public function setBlBlockItineraryTrfYn($blBlockItineraryTrfYn)
    {
        $this->blBlockItineraryTrfYn = $blBlockItineraryTrfYn;

        return $this;
    }

    /**
     * Get blBlockItineraryTrfYn
     *
     * @return boolean
     */
    public function getBlBlockItineraryTrfYn()
    {
        return $this->blBlockItineraryTrfYn;
    }
}
