<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * BlBlockPeriod
 *
 * @ORM\Table(name="bl_block_period", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="bl_block_period_trf_yn", columns={"bl_block_period_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"}), @ORM\Index(name="bl_block_period_id", columns={"bl_block_period_id"})})
 * @ORM\Entity
 */
class BlBlockPeriod
{
    /**
     * @var string
     *
     * @ORM\Column(name="bl_block_period_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $blBlockPeriodIx;

    /**
     * @var string
     *
     * @ORM\Column(name="bl_block_period_db", type="string", length=2, nullable=false, options={"default"="RS", "fixed"="true"})
     */
    private $blBlockPeriodDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="bl_block_period_id", type="integer", nullable=false)
     */
    private $blBlockPeriodId;

    /**
     * @var string
     *
     * @ORM\Column(name="bl_block_id", type="string", length=36, nullable=true)
     */
    private $blBlockId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="bl_per_date_start_series_fst", type="date", nullable=false, options={"default"="0000-00-00"})
     */
    private $blPerDateStartSeriesFst;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="bl_per_date_start_series_lst", type="date", nullable=false, options={"default"="0000-00-00"})
     */
    private $blPerDateStartSeriesLst;

    /**
     * @var integer
     *
     * @ORM\Column(name="bl_per_recurrence_per_ind", type="integer", nullable=false)
     */
    private $blPerRecurrencePerInd;

    /**
     * @var integer
     *
     * @ORM\Column(name="bl_per_recurrence_per_1", type="integer", nullable=true)
     */
    private $blPerRecurrencePer1;

    /**
     * @var integer
     *
     * @ORM\Column(name="bl_per_recurrence_per_2", type="integer", nullable=true)
     */
    private $blPerRecurrencePer2;

    /**
     * @var integer
     *
     * @ORM\Column(name="bl_per_recurrence_per_3", type="integer", nullable=true)
     */
    private $blPerRecurrencePer3;

    /**
     * @var integer
     *
     * @ORM\Column(name="bl_per_recurrence_per_4", type="integer", nullable=true)
     */
    private $blPerRecurrencePer4;

    /**
     * @var integer
     *
     * @ORM\Column(name="bl_per_recurrence_per_5", type="integer", nullable=true)
     */
    private $blPerRecurrencePer5;

    /**
     * @var integer
     *
     * @ORM\Column(name="bl_per_expiry_ind", type="integer", nullable=false)
     */
    private $blPerExpiryInd;

    /**
     * @var integer
     *
     * @ORM\Column(name="bl_per_expiry_lead_time_days", type="integer", nullable=false, options={"default"="0"})
     */
    private $blPerExpiryLeadTimeDays;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="bl_per_expiry_lead_time_date", type="date", nullable=false, options={"default"="0000-00-00"})
     */
    private $blPerExpiryLeadTimeDate;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_create_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adCreateDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_date_tz", type="string", length=40, nullable=false)
     */
    private $adCreateDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_user_id", type="string", length=36, nullable=true)
     */
    private $adCreateUserId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_modify_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adModifyDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_date_tz", type="string", length=40, nullable=false)
     */
    private $adModifyDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_user_id", type="string", length=36, nullable=true)
     */
    private $adModifyUserId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="bl_block_period_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $blBlockPeriodTrfYn;



    /**
     * Get blBlockPeriodIx
     *
     * @return string
     */
    public function getBlBlockPeriodIx()
    {
        return $this->blBlockPeriodIx;
    }

    /**
     * Set blBlockPeriodDb
     *
     * @param string $blBlockPeriodDb
     *
     * @return BlBlockPeriod
     */
    public function setBlBlockPeriodDb($blBlockPeriodDb)
    {
        $this->blBlockPeriodDb = $blBlockPeriodDb;

        return $this;
    }

    /**
     * Get blBlockPeriodDb
     *
     * @return string
     */
    public function getBlBlockPeriodDb()
    {
        return $this->blBlockPeriodDb;
    }

    /**
     * Set blBlockPeriodId
     *
     * @param integer $blBlockPeriodId
     *
     * @return BlBlockPeriod
     */
    public function setBlBlockPeriodId($blBlockPeriodId)
    {
        $this->blBlockPeriodId = $blBlockPeriodId;

        return $this;
    }

    /**
     * Get blBlockPeriodId
     *
     * @return integer
     */
    public function getBlBlockPeriodId()
    {
        return $this->blBlockPeriodId;
    }

    /**
     * Set blBlockId
     *
     * @param string $blBlockId
     *
     * @return BlBlockPeriod
     */
    public function setBlBlockId($blBlockId)
    {
        $this->blBlockId = $blBlockId;

        return $this;
    }

    /**
     * Get blBlockId
     *
     * @return string
     */
    public function getBlBlockId()
    {
        return $this->blBlockId;
    }

    /**
     * Set blPerDateStartSeriesFst
     *
     * @param \DateTime $blPerDateStartSeriesFst
     *
     * @return BlBlockPeriod
     */
    public function setBlPerDateStartSeriesFst($blPerDateStartSeriesFst)
    {
        $this->blPerDateStartSeriesFst = $blPerDateStartSeriesFst;

        return $this;
    }

    /**
     * Get blPerDateStartSeriesFst
     *
     * @return \DateTime
     */
    public function getBlPerDateStartSeriesFst()
    {
        return $this->blPerDateStartSeriesFst;
    }

    /**
     * Set blPerDateStartSeriesLst
     *
     * @param \DateTime $blPerDateStartSeriesLst
     *
     * @return BlBlockPeriod
     */
    public function setBlPerDateStartSeriesLst($blPerDateStartSeriesLst)
    {
        $this->blPerDateStartSeriesLst = $blPerDateStartSeriesLst;

        return $this;
    }

    /**
     * Get blPerDateStartSeriesLst
     *
     * @return \DateTime
     */
    public function getBlPerDateStartSeriesLst()
    {
        return $this->blPerDateStartSeriesLst;
    }

    /**
     * Set blPerRecurrencePerInd
     *
     * @param integer $blPerRecurrencePerInd
     *
     * @return BlBlockPeriod
     */
    public function setBlPerRecurrencePerInd($blPerRecurrencePerInd)
    {
        $this->blPerRecurrencePerInd = $blPerRecurrencePerInd;

        return $this;
    }

    /**
     * Get blPerRecurrencePerInd
     *
     * @return integer
     */
    public function getBlPerRecurrencePerInd()
    {
        return $this->blPerRecurrencePerInd;
    }

    /**
     * Set blPerRecurrencePer1
     *
     * @param integer $blPerRecurrencePer1
     *
     * @return BlBlockPeriod
     */
    public function setBlPerRecurrencePer1($blPerRecurrencePer1)
    {
        $this->blPerRecurrencePer1 = $blPerRecurrencePer1;

        return $this;
    }

    /**
     * Get blPerRecurrencePer1
     *
     * @return integer
     */
    public function getBlPerRecurrencePer1()
    {
        return $this->blPerRecurrencePer1;
    }

    /**
     * Set blPerRecurrencePer2
     *
     * @param integer $blPerRecurrencePer2
     *
     * @return BlBlockPeriod
     */
    public function setBlPerRecurrencePer2($blPerRecurrencePer2)
    {
        $this->blPerRecurrencePer2 = $blPerRecurrencePer2;

        return $this;
    }

    /**
     * Get blPerRecurrencePer2
     *
     * @return integer
     */
    public function getBlPerRecurrencePer2()
    {
        return $this->blPerRecurrencePer2;
    }

    /**
     * Set blPerRecurrencePer3
     *
     * @param integer $blPerRecurrencePer3
     *
     * @return BlBlockPeriod
     */
    public function setBlPerRecurrencePer3($blPerRecurrencePer3)
    {
        $this->blPerRecurrencePer3 = $blPerRecurrencePer3;

        return $this;
    }

    /**
     * Get blPerRecurrencePer3
     *
     * @return integer
     */
    public function getBlPerRecurrencePer3()
    {
        return $this->blPerRecurrencePer3;
    }

    /**
     * Set blPerRecurrencePer4
     *
     * @param integer $blPerRecurrencePer4
     *
     * @return BlBlockPeriod
     */
    public function setBlPerRecurrencePer4($blPerRecurrencePer4)
    {
        $this->blPerRecurrencePer4 = $blPerRecurrencePer4;

        return $this;
    }

    /**
     * Get blPerRecurrencePer4
     *
     * @return integer
     */
    public function getBlPerRecurrencePer4()
    {
        return $this->blPerRecurrencePer4;
    }

    /**
     * Set blPerRecurrencePer5
     *
     * @param integer $blPerRecurrencePer5
     *
     * @return BlBlockPeriod
     */
    public function setBlPerRecurrencePer5($blPerRecurrencePer5)
    {
        $this->blPerRecurrencePer5 = $blPerRecurrencePer5;

        return $this;
    }

    /**
     * Get blPerRecurrencePer5
     *
     * @return integer
     */
    public function getBlPerRecurrencePer5()
    {
        return $this->blPerRecurrencePer5;
    }

    /**
     * Set blPerExpiryInd
     *
     * @param integer $blPerExpiryInd
     *
     * @return BlBlockPeriod
     */
    public function setBlPerExpiryInd($blPerExpiryInd)
    {
        $this->blPerExpiryInd = $blPerExpiryInd;

        return $this;
    }

    /**
     * Get blPerExpiryInd
     *
     * @return integer
     */
    public function getBlPerExpiryInd()
    {
        return $this->blPerExpiryInd;
    }

    /**
     * Set blPerExpiryLeadTimeDays
     *
     * @param integer $blPerExpiryLeadTimeDays
     *
     * @return BlBlockPeriod
     */
    public function setBlPerExpiryLeadTimeDays($blPerExpiryLeadTimeDays)
    {
        $this->blPerExpiryLeadTimeDays = $blPerExpiryLeadTimeDays;

        return $this;
    }

    /**
     * Get blPerExpiryLeadTimeDays
     *
     * @return integer
     */
    public function getBlPerExpiryLeadTimeDays()
    {
        return $this->blPerExpiryLeadTimeDays;
    }

    /**
     * Set blPerExpiryLeadTimeDate
     *
     * @param \DateTime $blPerExpiryLeadTimeDate
     *
     * @return BlBlockPeriod
     */
    public function setBlPerExpiryLeadTimeDate($blPerExpiryLeadTimeDate)
    {
        $this->blPerExpiryLeadTimeDate = $blPerExpiryLeadTimeDate;

        return $this;
    }

    /**
     * Get blPerExpiryLeadTimeDate
     *
     * @return \DateTime
     */
    public function getBlPerExpiryLeadTimeDate()
    {
        return $this->blPerExpiryLeadTimeDate;
    }

    /**
     * Set adCreateDate
     *
     * @param \DateTime $adCreateDate
     *
     * @return BlBlockPeriod
     */
    public function setAdCreateDate($adCreateDate)
    {
        $this->adCreateDate = $adCreateDate;

        return $this;
    }

    /**
     * Get adCreateDate
     *
     * @return \DateTime
     */
    public function getAdCreateDate()
    {
        return $this->adCreateDate;
    }

    /**
     * Set adCreateDateTz
     *
     * @param string $adCreateDateTz
     *
     * @return BlBlockPeriod
     */
    public function setAdCreateDateTz($adCreateDateTz)
    {
        $this->adCreateDateTz = $adCreateDateTz;

        return $this;
    }

    /**
     * Get adCreateDateTz
     *
     * @return string
     */
    public function getAdCreateDateTz()
    {
        return $this->adCreateDateTz;
    }

    /**
     * Set adCreateUserId
     *
     * @param string $adCreateUserId
     *
     * @return BlBlockPeriod
     */
    public function setAdCreateUserId($adCreateUserId)
    {
        $this->adCreateUserId = $adCreateUserId;

        return $this;
    }

    /**
     * Get adCreateUserId
     *
     * @return string
     */
    public function getAdCreateUserId()
    {
        return $this->adCreateUserId;
    }

    /**
     * Set adModifyDate
     *
     * @param \DateTime $adModifyDate
     *
     * @return BlBlockPeriod
     */
    public function setAdModifyDate($adModifyDate)
    {
        $this->adModifyDate = $adModifyDate;

        return $this;
    }

    /**
     * Get adModifyDate
     *
     * @return \DateTime
     */
    public function getAdModifyDate()
    {
        return $this->adModifyDate;
    }

    /**
     * Set adModifyDateTz
     *
     * @param string $adModifyDateTz
     *
     * @return BlBlockPeriod
     */
    public function setAdModifyDateTz($adModifyDateTz)
    {
        $this->adModifyDateTz = $adModifyDateTz;

        return $this;
    }

    /**
     * Get adModifyDateTz
     *
     * @return string
     */
    public function getAdModifyDateTz()
    {
        return $this->adModifyDateTz;
    }

    /**
     * Set adModifyUserId
     *
     * @param string $adModifyUserId
     *
     * @return BlBlockPeriod
     */
    public function setAdModifyUserId($adModifyUserId)
    {
        $this->adModifyUserId = $adModifyUserId;

        return $this;
    }

    /**
     * Get adModifyUserId
     *
     * @return string
     */
    public function getAdModifyUserId()
    {
        return $this->adModifyUserId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return BlBlockPeriod
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set blBlockPeriodTrfYn
     *
     * @param boolean $blBlockPeriodTrfYn
     *
     * @return BlBlockPeriod
     */
    public function setBlBlockPeriodTrfYn($blBlockPeriodTrfYn)
    {
        $this->blBlockPeriodTrfYn = $blBlockPeriodTrfYn;

        return $this;
    }

    /**
     * Get blBlockPeriodTrfYn
     *
     * @return boolean
     */
    public function getBlBlockPeriodTrfYn()
    {
        return $this->blBlockPeriodTrfYn;
    }
}
