<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ChChart
 *
 * @ORM\Table(name="ch_chart")
 * @ORM\Entity
 */
class ChChart
{
    /**
     * @var string
     *
     * @ORM\Column(name="ch_chart_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $chChartIx;

    /**
     * @var string
     *
     * @ORM\Column(name="ch_chart_name", type="string", length=50, nullable=false)
     */
    private $chChartName;

    /**
     * @var string
     *
     * @ORM\Column(name="ch_chart_description", type="string", length=1000, nullable=false)
     */
    private $chChartDescription;

    /**
     * @var string
     *
     * @ORM\Column(name="ch_chart_report_info", type="string", length=1000, nullable=false)
     */
    private $chChartReportInfo;

    /**
     * @var string
     *
     * @ORM\Column(name="ch_chart_library", type="string", length=36, nullable=false)
     */
    private $chChartLibrary;

    /**
     * @var string
     *
     * @ORM\Column(name="ch_chart_type", type="string", length=36, nullable=false)
     */
    private $chChartType;

    /**
     * @var string
     *
     * @ORM\Column(name="ch_chart_configuration", type="json_array", nullable=false)
     */
    private $chChartConfiguration;



    /**
     * Get chChartIx
     *
     * @return string
     */
    public function getChChartIx()
    {
        return $this->chChartIx;
    }

    /**
     * Get chChartName
     *
     * @return string
     */
    public function getChChartName()
    {
        return $this->chChartName;
    }

    /**
     * Get chChartDescription
     *
     * @return string
     */
    public function getChChartDescription()
    {
        return $this->chChartDescription;
    }

    /**
     * Get chChartReportInfo
     *
     * @return string
     */
    public function getChChartReportInfo()
    {
        return $this->chChartReportInfo;
    }

    /**
     * Get chChartLibrary
     *
     * @return string
     */
    public function getChChartLibrary()
    {
        return $this->chChartLibrary;
    }

    /**
     * Get chChartType
     *
     * @return string
     */
    public function getChChartType()
    {
        return $this->chChartType;
    }

    /**
     * Get chChartConfiguration
     *
     * @return string
     */
    public function getChChartConfiguration()
    {
        return $this->chChartConfiguration;
    }
}

