<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ChChartContainer
 *
 * @ORM\Table(name="ch_chart_container")
 * @ORM\Entity
 */
class ChChartContainer
{
    /**
     * @var string
     *
     * @ORM\Column(name="ch_chart_container_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $chChartContainerIx;

    /**
     * @var string
     *
     * @ORM\Column(name="ch_chart_container_name", type="string", length=50, nullable=false)
     */
    private $chChartContainerName;

    /**
     * @var string
     *
     * @ORM\Column(name="ch_chart_container_description", type="string", length=1000, nullable=true)
     */
    private $chChartContainerDescription;

    /**
     * @var string
     *
     * @ORM\Column(name="ch_chart_container_configuration", type="json_array", nullable=false)
     */
    private $chChartContainerConfiguration;



    /**
     * Get chChartContainerIx
     *
     * @return string
     */
    public function getChChartContainerIx()
    {
        return $this->chChartContainerIx;
    }

    /**
     * Get chChartContainerName
     *
     * @return string
     */
    public function getChChartContainerName()
    {
        return $this->chChartContainerName;
    }

    /**
     * Get chChartContainerDescription
     *
     * @return string
     */
    public function getChChartContainerDescription()
    {
        return $this->chChartContainerDescription;
    }

    /**
     * Get chChartContainerConfiguration
     *
     * @return array
     */
    public function getChChartContainerConfiguration()
    {
        return $this->chChartContainerConfiguration;
    }
}

