<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * EmMail
 *
 * @ORM\Table(name="em_mail", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rv_reservation_id", columns={"rv_reservation_id"}), @ORM\Index(name="em_mail_trf_yn", columns={"em_mail_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class EmMail
{
    /**
     * @var string
     *
     * @ORM\Column(name="em_mail_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $emMailIx;

    /**
     * @var string
     *
     * @ORM\Column(name="em_mail_db", type="string", length=2, nullable=false, options={"default"="RS", "fixed"="true"})
     */
    private $emMailDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="em_mail_id", type="integer", nullable=false)
     */
    private $emMailId;

    /**
     * @var string
     *
     * @ORM\Column(name="em_from", type="string", length=50, nullable=true)
     */
    private $emFrom;

    /**
     * @var string
     *
     * @ORM\Column(name="em_to", type="string", length=150, nullable=true)
     */
    private $emTo;

    /**
     * @var string
     *
     * @ORM\Column(name="em_subject", type="string", length=100, nullable=true)
     */
    private $emSubject;

    /**
     * @var string
     *
     * @ORM\Column(name="em_message", type="text", length=65535, nullable=true)
     */
    private $emMessage;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_reservation_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $rvReservationId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="em_mail_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $emMailTrfYn;



    /**
     * Get emMailIx
     *
     * @return string
     */
    public function getEmMailIx()
    {
        return $this->emMailIx;
    }

    /**
     * Set emMailDb
     *
     * @param string $emMailDb
     *
     * @return EmMail
     */
    public function setEmMailDb($emMailDb)
    {
        $this->emMailDb = $emMailDb;

        return $this;
    }

    /**
     * Get emMailDb
     *
     * @return string
     */
    public function getEmMailDb()
    {
        return $this->emMailDb;
    }

    /**
     * Set emMailId
     *
     * @param integer $emMailId
     *
     * @return EmMail
     */
    public function setEmMailId($emMailId)
    {
        $this->emMailId = $emMailId;

        return $this;
    }

    /**
     * Get emMailId
     *
     * @return integer
     */
    public function getEmMailId()
    {
        return $this->emMailId;
    }

    /**
     * Set emFrom
     *
     * @param string $emFrom
     *
     * @return EmMail
     */
    public function setEmFrom($emFrom)
    {
        $this->emFrom = $emFrom;

        return $this;
    }

    /**
     * Get emFrom
     *
     * @return string
     */
    public function getEmFrom()
    {
        return $this->emFrom;
    }

    /**
     * Set emTo
     *
     * @param string $emTo
     *
     * @return EmMail
     */
    public function setEmTo($emTo)
    {
        $this->emTo = $emTo;

        return $this;
    }

    /**
     * Get emTo
     *
     * @return string
     */
    public function getEmTo()
    {
        return $this->emTo;
    }

    /**
     * Set emSubject
     *
     * @param string $emSubject
     *
     * @return EmMail
     */
    public function setEmSubject($emSubject)
    {
        $this->emSubject = $emSubject;

        return $this;
    }

    /**
     * Get emSubject
     *
     * @return string
     */
    public function getEmSubject()
    {
        return $this->emSubject;
    }

    /**
     * Set emMessage
     *
     * @param string $emMessage
     *
     * @return EmMail
     */
    public function setEmMessage($emMessage)
    {
        $this->emMessage = $emMessage;

        return $this;
    }

    /**
     * Get emMessage
     *
     * @return string
     */
    public function getEmMessage()
    {
        return $this->emMessage;
    }

    /**
     * Set rvReservationId
     *
     * @param string $rvReservationId
     *
     * @return EmMail
     */
    public function setRvReservationId($rvReservationId)
    {
        $this->rvReservationId = $rvReservationId;

        return $this;
    }

    /**
     * Get rvReservationId
     *
     * @return string
     */
    public function getRvReservationId()
    {
        return $this->rvReservationId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return EmMail
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set emMailTrfYn
     *
     * @param boolean $emMailTrfYn
     *
     * @return EmMail
     */
    public function setEmMailTrfYn($emMailTrfYn)
    {
        $this->emMailTrfYn = $emMailTrfYn;

        return $this;
    }

    /**
     * Get emMailTrfYn
     *
     * @return boolean
     */
    public function getEmMailTrfYn()
    {
        return $this->emMailTrfYn;
    }
}
