<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * EmMailLog
 *
 * @ORM\Table(name="em_mail_log", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="em_mail_id", columns={"em_mail_id"}), @ORM\Index(name="em_mail_log_trf_yn", columns={"em_mail_log_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class EmMailLog
{
    /**
     * @var string
     *
     * @ORM\Column(name="em_mail_log_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $emMailLogIx;

    /**
     * @var string
     *
     * @ORM\Column(name="em_mail_log_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $emMailLogDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="em_mail_log_id", type="integer", nullable=false)
     */
    private $emMailLogId;

    /**
     * @var string
     *
     * @ORM\Column(name="em_server", type="string", length=64, nullable=false, options={"default"=""})
     */
    private $emServer;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_user_id", type="string", length=36, nullable=true)
     */
    private $prUserId;

    /**
     * @var string
     *
     * @ORM\Column(name="em_mail_id", type="string", length=36, nullable=true)
     */
    private $emMailId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="em_action", type="boolean", nullable=false, options={"default"="0"})
     */
    private $emAction;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="em_action_date_time", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $emActionDateTime;

    /**
     * @var string
     *
     * @ORM\Column(name="em_action_date_time_tz", type="string", length=40, nullable=false)
     */
    private $emActionDateTimeTz;

    /**
     * @var string
     *
     * @ORM\Column(name="em_action_log", type="text", length=65535, nullable=false)
     */
    private $emActionLog;

    /**
     * @var boolean
     *
     * @ORM\Column(name="em_status", type="boolean", nullable=false, options={"default"="0"})
     */
    private $emStatus;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="em_mail_log_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $emMailLogTrfYn;



    /**
     * Get emMailLogIx
     *
     * @return string
     */
    public function getEmMailLogIx()
    {
        return $this->emMailLogIx;
    }

    /**
     * Set emMailLogDb
     *
     * @param string $emMailLogDb
     *
     * @return EmMailLog
     */
    public function setEmMailLogDb($emMailLogDb)
    {
        $this->emMailLogDb = $emMailLogDb;

        return $this;
    }

    /**
     * Get emMailLogDb
     *
     * @return string
     */
    public function getEmMailLogDb()
    {
        return $this->emMailLogDb;
    }

    /**
     * Set emMailLogId
     *
     * @param integer $emMailLogId
     *
     * @return EmMailLog
     */
    public function setEmMailLogId($emMailLogId)
    {
        $this->emMailLogId = $emMailLogId;

        return $this;
    }

    /**
     * Get emMailLogId
     *
     * @return integer
     */
    public function getEmMailLogId()
    {
        return $this->emMailLogId;
    }

    /**
     * Set emServer
     *
     * @param string $emServer
     *
     * @return EmMailLog
     */
    public function setEmServer($emServer)
    {
        $this->emServer = $emServer;

        return $this;
    }

    /**
     * Get emServer
     *
     * @return string
     */
    public function getEmServer()
    {
        return $this->emServer;
    }

    /**
     * Set prUserId
     *
     * @param string $prUserId
     *
     * @return EmMailLog
     */
    public function setPrUserId($prUserId)
    {
        $this->prUserId = $prUserId;

        return $this;
    }

    /**
     * Get prUserId
     *
     * @return string
     */
    public function getPrUserId()
    {
        return $this->prUserId;
    }

    /**
     * Set emMailId
     *
     * @param string $emMailId
     *
     * @return EmMailLog
     */
    public function setEmMailId($emMailId)
    {
        $this->emMailId = $emMailId;

        return $this;
    }

    /**
     * Get emMailId
     *
     * @return string
     */
    public function getEmMailId()
    {
        return $this->emMailId;
    }

    /**
     * Set emAction
     *
     * @param boolean $emAction
     *
     * @return EmMailLog
     */
    public function setEmAction($emAction)
    {
        $this->emAction = $emAction;

        return $this;
    }

    /**
     * Get emAction
     *
     * @return boolean
     */
    public function getEmAction()
    {
        return $this->emAction;
    }

    /**
     * Set emActionDateTime
     *
     * @param \DateTime $emActionDateTime
     *
     * @return EmMailLog
     */
    public function setEmActionDateTime($emActionDateTime)
    {
        $this->emActionDateTime = $emActionDateTime;

        return $this;
    }

    /**
     * Get emActionDateTime
     *
     * @return \DateTime
     */
    public function getEmActionDateTime()
    {
        return $this->emActionDateTime;
    }

    /**
     * Set emActionDateTimeTz
     *
     * @param string $emActionDateTimeTz
     *
     * @return EmMailLog
     */
    public function setEmActionDateTimeTz($emActionDateTimeTz)
    {
        $this->emActionDateTimeTz = $emActionDateTimeTz;

        return $this;
    }

    /**
     * Get emActionDateTimeTz
     *
     * @return string
     */
    public function getEmActionDateTimeTz()
    {
        return $this->emActionDateTimeTz;
    }

    /**
     * Set emActionLog
     *
     * @param string $emActionLog
     *
     * @return EmMailLog
     */
    public function setEmActionLog($emActionLog)
    {
        $this->emActionLog = $emActionLog;

        return $this;
    }

    /**
     * Get emActionLog
     *
     * @return string
     */
    public function getEmActionLog()
    {
        return $this->emActionLog;
    }

    /**
     * Set emStatus
     *
     * @param boolean $emStatus
     *
     * @return EmMailLog
     */
    public function setEmStatus($emStatus)
    {
        $this->emStatus = $emStatus;

        return $this;
    }

    /**
     * Get emStatus
     *
     * @return boolean
     */
    public function getEmStatus()
    {
        return $this->emStatus;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return EmMailLog
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set emMailLogTrfYn
     *
     * @param boolean $emMailLogTrfYn
     *
     * @return EmMailLog
     */
    public function setEmMailLogTrfYn($emMailLogTrfYn)
    {
        $this->emMailLogTrfYn = $emMailLogTrfYn;

        return $this;
    }

    /**
     * Get emMailLogTrfYn
     *
     * @return boolean
     */
    public function getEmMailLogTrfYn()
    {
        return $this->emMailLogTrfYn;
    }
}
