<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * FnBatch
 *
 * @ORM\Table(name="fn_batch", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="fn_batch_trf_yn", columns={"fn_batch_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class FnBatch
{
    /**
     * @var string
     *
     * @ORM\Column(name="fn_batch_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $fnBatchIx;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_batch_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $fnBatchDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="fn_batch_id", type="integer", nullable=false)
     */
    private $fnBatchId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_batch_prefix", type="string", length=5, nullable=false, options={"default"=""})
     */
    private $fnBatchPrefix;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_batch_name", type="string", length=50, nullable=true)
     */
    private $fnBatchName;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_batch_note", type="text", length=65535, nullable=false)
     */
    private $fnBatchNote;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_batch_closed_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnBatchClosedYn;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_year_id", type="string", length=36, nullable=true)
     */
    private $fnYearId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_business_id", type="string", length=36, nullable=true)
     */
    private $prBusinessId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_create_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adCreateDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_date_tz", type="string", length=40, nullable=false)
     */
    private $adCreateDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_user_id", type="string", length=36, nullable=true)
     */
    private $adCreateUserId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_delete_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adDeleteDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_delete_date_tz", type="string", length=40, nullable=false)
     */
    private $adDeleteDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_delete_user_id", type="string", length=36, nullable=true)
     */
    private $adDeleteUserId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_modify_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adModifyDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_date_tz", type="string", length=40, nullable=false)
     */
    private $adModifyDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_user_id", type="string", length=36, nullable=true)
     */
    private $adModifyUserId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=18, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_batch_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnBatchTrfYn;



    /**
     * Get fnBatchIx
     *
     * @return string
     */
    public function getFnBatchIx()
    {
        return $this->fnBatchIx;
    }

    /**
     * Set fnBatchDb
     *
     * @param string $fnBatchDb
     *
     * @return FnBatch
     */
    public function setFnBatchDb($fnBatchDb)
    {
        $this->fnBatchDb = $fnBatchDb;

        return $this;
    }

    /**
     * Get fnBatchDb
     *
     * @return string
     */
    public function getFnBatchDb()
    {
        return $this->fnBatchDb;
    }

    /**
     * Set fnBatchId
     *
     * @param integer $fnBatchId
     *
     * @return FnBatch
     */
    public function setFnBatchId($fnBatchId)
    {
        $this->fnBatchId = $fnBatchId;

        return $this;
    }

    /**
     * Get fnBatchId
     *
     * @return integer
     */
    public function getFnBatchId()
    {
        return $this->fnBatchId;
    }

    /**
     * Set fnBatchPrefix
     *
     * @param string $fnBatchPrefix
     *
     * @return FnBatch
     */
    public function setFnBatchPrefix($fnBatchPrefix)
    {
        $this->fnBatchPrefix = $fnBatchPrefix;

        return $this;
    }

    /**
     * Get fnBatchPrefix
     *
     * @return string
     */
    public function getFnBatchPrefix()
    {
        return $this->fnBatchPrefix;
    }

    /**
     * Set fnBatchName
     *
     * @param string $fnBatchName
     *
     * @return FnBatch
     */
    public function setFnBatchName($fnBatchName)
    {
        $this->fnBatchName = $fnBatchName;

        return $this;
    }

    /**
     * Get fnBatchName
     *
     * @return string
     */
    public function getFnBatchName()
    {
        return $this->fnBatchName;
    }

    /**
     * Set fnBatchNote
     *
     * @param string $fnBatchNote
     *
     * @return FnBatch
     */
    public function setFnBatchNote($fnBatchNote)
    {
        $this->fnBatchNote = $fnBatchNote;

        return $this;
    }

    /**
     * Get fnBatchNote
     *
     * @return string
     */
    public function getFnBatchNote()
    {
        return $this->fnBatchNote;
    }

    /**
     * Set fnBatchClosedYn
     *
     * @param boolean $fnBatchClosedYn
     *
     * @return FnBatch
     */
    public function setFnBatchClosedYn($fnBatchClosedYn)
    {
        $this->fnBatchClosedYn = $fnBatchClosedYn;

        return $this;
    }

    /**
     * Get fnBatchClosedYn
     *
     * @return boolean
     */
    public function getFnBatchClosedYn()
    {
        return $this->fnBatchClosedYn;
    }

    /**
     * Set fnYearId
     *
     * @param string $fnYearId
     *
     * @return FnBatch
     */
    public function setFnYearId($fnYearId)
    {
        $this->fnYearId = $fnYearId;

        return $this;
    }

    /**
     * Get fnYearId
     *
     * @return string
     */
    public function getFnYearId()
    {
        return $this->fnYearId;
    }

    /**
     * Set prBusinessId
     *
     * @param string $prBusinessId
     *
     * @return FnBatch
     */
    public function setPrBusinessId($prBusinessId)
    {
        $this->prBusinessId = $prBusinessId;

        return $this;
    }

    /**
     * Get prBusinessId
     *
     * @return string
     */
    public function getPrBusinessId()
    {
        return $this->prBusinessId;
    }

    /**
     * Set adCreateDate
     *
     * @param \DateTime $adCreateDate
     *
     * @return FnBatch
     */
    public function setAdCreateDate($adCreateDate)
    {
        $this->adCreateDate = $adCreateDate;

        return $this;
    }

    /**
     * Get adCreateDate
     *
     * @return \DateTime
     */
    public function getAdCreateDate()
    {
        return $this->adCreateDate;
    }

    /**
     * Set adCreateDateTz
     *
     * @param string $adCreateDateTz
     *
     * @return FnBatch
     */
    public function setAdCreateDateTz($adCreateDateTz)
    {
        $this->adCreateDateTz = $adCreateDateTz;

        return $this;
    }

    /**
     * Get adCreateDateTz
     *
     * @return string
     */
    public function getAdCreateDateTz()
    {
        return $this->adCreateDateTz;
    }

    /**
     * Set adCreateUserId
     *
     * @param string $adCreateUserId
     *
     * @return FnBatch
     */
    public function setAdCreateUserId($adCreateUserId)
    {
        $this->adCreateUserId = $adCreateUserId;

        return $this;
    }

    /**
     * Get adCreateUserId
     *
     * @return string
     */
    public function getAdCreateUserId()
    {
        return $this->adCreateUserId;
    }

    /**
     * Set adDeleteDate
     *
     * @param \DateTime $adDeleteDate
     *
     * @return FnBatch
     */
    public function setAdDeleteDate($adDeleteDate)
    {
        $this->adDeleteDate = $adDeleteDate;

        return $this;
    }

    /**
     * Get adDeleteDate
     *
     * @return \DateTime
     */
    public function getAdDeleteDate()
    {
        return $this->adDeleteDate;
    }

    /**
     * Set adDeleteDateTz
     *
     * @param string $adDeleteDateTz
     *
     * @return FnBatch
     */
    public function setAdDeleteDateTz($adDeleteDateTz)
    {
        $this->adDeleteDateTz = $adDeleteDateTz;

        return $this;
    }

    /**
     * Get adDeleteDateTz
     *
     * @return string
     */
    public function getAdDeleteDateTz()
    {
        return $this->adDeleteDateTz;
    }

    /**
     * Set adDeleteUserId
     *
     * @param string $adDeleteUserId
     *
     * @return FnBatch
     */
    public function setAdDeleteUserId($adDeleteUserId)
    {
        $this->adDeleteUserId = $adDeleteUserId;

        return $this;
    }

    /**
     * Get adDeleteUserId
     *
     * @return string
     */
    public function getAdDeleteUserId()
    {
        return $this->adDeleteUserId;
    }

    /**
     * Set adModifyDate
     *
     * @param \DateTime $adModifyDate
     *
     * @return FnBatch
     */
    public function setAdModifyDate($adModifyDate)
    {
        $this->adModifyDate = $adModifyDate;

        return $this;
    }

    /**
     * Get adModifyDate
     *
     * @return \DateTime
     */
    public function getAdModifyDate()
    {
        return $this->adModifyDate;
    }

    /**
     * Set adModifyDateTz
     *
     * @param string $adModifyDateTz
     *
     * @return FnBatch
     */
    public function setAdModifyDateTz($adModifyDateTz)
    {
        $this->adModifyDateTz = $adModifyDateTz;

        return $this;
    }

    /**
     * Get adModifyDateTz
     *
     * @return string
     */
    public function getAdModifyDateTz()
    {
        return $this->adModifyDateTz;
    }

    /**
     * Set adModifyUserId
     *
     * @param string $adModifyUserId
     *
     * @return FnBatch
     */
    public function setAdModifyUserId($adModifyUserId)
    {
        $this->adModifyUserId = $adModifyUserId;

        return $this;
    }

    /**
     * Get adModifyUserId
     *
     * @return string
     */
    public function getAdModifyUserId()
    {
        return $this->adModifyUserId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return FnBatch
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set fnBatchTrfYn
     *
     * @param boolean $fnBatchTrfYn
     *
     * @return FnBatch
     */
    public function setFnBatchTrfYn($fnBatchTrfYn)
    {
        $this->fnBatchTrfYn = $fnBatchTrfYn;

        return $this;
    }

    /**
     * Get fnBatchTrfYn
     *
     * @return boolean
     */
    public function getFnBatchTrfYn()
    {
        return $this->fnBatchTrfYn;
    }
}
