<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * FnCostCentre
 *
 * @ORM\Table(name="fn_cost_centre", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="fn_cost_centre_trf_yn", columns={"fn_cost_centre_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class FnCostCentre
{
    /**
     * @var string
     *
     * @ORM\Column(name="fn_cost_centre_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $fnCostCentreIx;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_cost_centre_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $fnCostCentreDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="fn_cost_centre_id", type="integer", nullable=false)
     */
    private $fnCostCentreId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_cost_centre_code", type="string", length=20, nullable=true)
     */
    private $fnCostCentreCode;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_cost_centre_desc", type="string", length=50, nullable=true)
     */
    private $fnCostCentreDesc;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_cost_centre_ind", type="boolean", nullable=false, options={"default"="1"})
     */
    private $fnCostCentreInd;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_business_id", type="string", length=36, nullable=true)
     */
    private $prBusinessId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_cost_centre_inactive_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnCostCentreInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_cost_centre_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnCostCentreTrfYn;



    /**
     * Get fnCostCentreIx
     *
     * @return string
     */
    public function getFnCostCentreIx()
    {
        return $this->fnCostCentreIx;
    }

    /**
     * Set fnCostCentreDb
     *
     * @param string $fnCostCentreDb
     *
     * @return FnCostCentre
     */
    public function setFnCostCentreDb($fnCostCentreDb)
    {
        $this->fnCostCentreDb = $fnCostCentreDb;

        return $this;
    }

    /**
     * Get fnCostCentreDb
     *
     * @return string
     */
    public function getFnCostCentreDb()
    {
        return $this->fnCostCentreDb;
    }

    /**
     * Set fnCostCentreId
     *
     * @param integer $fnCostCentreId
     *
     * @return FnCostCentre
     */
    public function setFnCostCentreId($fnCostCentreId)
    {
        $this->fnCostCentreId = $fnCostCentreId;

        return $this;
    }

    /**
     * Get fnCostCentreId
     *
     * @return integer
     */
    public function getFnCostCentreId()
    {
        return $this->fnCostCentreId;
    }

    /**
     * Set fnCostCentreCode
     *
     * @param string $fnCostCentreCode
     *
     * @return FnCostCentre
     */
    public function setFnCostCentreCode($fnCostCentreCode)
    {
        $this->fnCostCentreCode = $fnCostCentreCode;

        return $this;
    }

    /**
     * Get fnCostCentreCode
     *
     * @return string
     */
    public function getFnCostCentreCode()
    {
        return $this->fnCostCentreCode;
    }

    /**
     * Set fnCostCentreDesc
     *
     * @param string $fnCostCentreDesc
     *
     * @return FnCostCentre
     */
    public function setFnCostCentreDesc($fnCostCentreDesc)
    {
        $this->fnCostCentreDesc = $fnCostCentreDesc;

        return $this;
    }

    /**
     * Get fnCostCentreDesc
     *
     * @return string
     */
    public function getFnCostCentreDesc()
    {
        return $this->fnCostCentreDesc;
    }

    /**
     * Set fnCostCentreInd
     *
     * @param boolean $fnCostCentreInd
     *
     * @return FnCostCentre
     */
    public function setFnCostCentreInd($fnCostCentreInd)
    {
        $this->fnCostCentreInd = $fnCostCentreInd;

        return $this;
    }

    /**
     * Get fnCostCentreInd
     *
     * @return boolean
     */
    public function getFnCostCentreInd()
    {
        return $this->fnCostCentreInd;
    }

    /**
     * Set prBusinessId
     *
     * @param string $prBusinessId
     *
     * @return FnCostCentre
     */
    public function setPrBusinessId($prBusinessId)
    {
        $this->prBusinessId = $prBusinessId;

        return $this;
    }

    /**
     * Get prBusinessId
     *
     * @return string
     */
    public function getPrBusinessId()
    {
        return $this->prBusinessId;
    }

    /**
     * Set fnCostCentreInactiveYn
     *
     * @param boolean $fnCostCentreInactiveYn
     *
     * @return FnCostCentre
     */
    public function setFnCostCentreInactiveYn($fnCostCentreInactiveYn)
    {
        $this->fnCostCentreInactiveYn = $fnCostCentreInactiveYn;

        return $this;
    }

    /**
     * Get fnCostCentreInactiveYn
     *
     * @return boolean
     */
    public function getFnCostCentreInactiveYn()
    {
        return $this->fnCostCentreInactiveYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return FnCostCentre
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set fnCostCentreTrfYn
     *
     * @param boolean $fnCostCentreTrfYn
     *
     * @return FnCostCentre
     */
    public function setFnCostCentreTrfYn($fnCostCentreTrfYn)
    {
        $this->fnCostCentreTrfYn = $fnCostCentreTrfYn;

        return $this;
    }

    /**
     * Get fnCostCentreTrfYn
     *
     * @return boolean
     */
    public function getFnCostCentreTrfYn()
    {
        return $this->fnCostCentreTrfYn;
    }
}
