<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * FnDbBusiness
 *
 * @ORM\Table(name="fn_db_business", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="fn_db_business_trf_yn", columns={"fn_db_business_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"}), @ORM\Index(name="pr_business_id", columns={"pr_business_id"}), @ORM\Index(name="rf_database_id", columns={"rf_database_id"})})
 * @ORM\Entity
 */
class FnDbBusiness
{
    /**
     * @var string
     *
     * @ORM\Column(name="fn_db_business_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $fnDbBusinessIx;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_db_business_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $fnDbBusinessDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="fn_db_business_id", type="integer", nullable=false)
     */
    private $fnDbBusinessId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_business_id", type="string", length=36, nullable=true)
     */
    private $prBusinessId;

    /**
     * @var integer
     *
     * @ORM\Column(name="rf_database_id", type="integer", nullable=true)
     */
    private $rfDatabaseId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_db_bus_debtor_ind", type="boolean", nullable=false, options={"default"="1"})
     */
    private $fnDbBusDebtorInd;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_db_business_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnDbBusinessTrfYn;



    /**
     * Get fnDbBusinessIx
     *
     * @return string
     */
    public function getFnDbBusinessIx()
    {
        return $this->fnDbBusinessIx;
    }

    /**
     * Set fnDbBusinessDb
     *
     * @param string $fnDbBusinessDb
     *
     * @return FnDbBusiness
     */
    public function setFnDbBusinessDb($fnDbBusinessDb)
    {
        $this->fnDbBusinessDb = $fnDbBusinessDb;

        return $this;
    }

    /**
     * Get fnDbBusinessDb
     *
     * @return string
     */
    public function getFnDbBusinessDb()
    {
        return $this->fnDbBusinessDb;
    }

    /**
     * Set fnDbBusinessId
     *
     * @param integer $fnDbBusinessId
     *
     * @return FnDbBusiness
     */
    public function setFnDbBusinessId($fnDbBusinessId)
    {
        $this->fnDbBusinessId = $fnDbBusinessId;

        return $this;
    }

    /**
     * Get fnDbBusinessId
     *
     * @return integer
     */
    public function getFnDbBusinessId()
    {
        return $this->fnDbBusinessId;
    }

    /**
     * Set prBusinessId
     *
     * @param string $prBusinessId
     *
     * @return FnDbBusiness
     */
    public function setPrBusinessId($prBusinessId)
    {
        $this->prBusinessId = $prBusinessId;

        return $this;
    }

    /**
     * Get prBusinessId
     *
     * @return string
     */
    public function getPrBusinessId()
    {
        return $this->prBusinessId;
    }

    /**
     * Set rfDatabaseId
     *
     * @param integer $rfDatabaseId
     *
     * @return FnDbBusiness
     */
    public function setRfDatabaseId($rfDatabaseId)
    {
        $this->rfDatabaseId = $rfDatabaseId;

        return $this;
    }

    /**
     * Get rfDatabaseId
     *
     * @return integer
     */
    public function getRfDatabaseId()
    {
        return $this->rfDatabaseId;
    }

    /**
     * Set fnDbBusDebtorInd
     *
     * @param boolean $fnDbBusDebtorInd
     *
     * @return FnDbBusiness
     */
    public function setFnDbBusDebtorInd($fnDbBusDebtorInd)
    {
        $this->fnDbBusDebtorInd = $fnDbBusDebtorInd;

        return $this;
    }

    /**
     * Get fnDbBusDebtorInd
     *
     * @return boolean
     */
    public function getFnDbBusDebtorInd()
    {
        return $this->fnDbBusDebtorInd;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return FnDbBusiness
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set fnDbBusinessTrfYn
     *
     * @param boolean $fnDbBusinessTrfYn
     *
     * @return FnDbBusiness
     */
    public function setFnDbBusinessTrfYn($fnDbBusinessTrfYn)
    {
        $this->fnDbBusinessTrfYn = $fnDbBusinessTrfYn;

        return $this;
    }

    /**
     * Get fnDbBusinessTrfYn
     *
     * @return boolean
     */
    public function getFnDbBusinessTrfYn()
    {
        return $this->fnDbBusinessTrfYn;
    }
}
