<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * FnDebtor
 *
 * @ORM\Table(name="fn_debtor", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="fn_debtor_trf_yn", columns={"fn_debtor_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"}), @ORM\Index(name="pr_business_id", columns={"pr_business_id"})})
 * @ORM\Entity
 */
class FnDebtor
{
    /**
     * @var string
     *
     * @ORM\Column(name="fn_debtor_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $fnDebtorIx;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_debtor_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $fnDebtorDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="fn_debtor_id", type="integer", nullable=false)
     */
    private $fnDebtorId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_debtor_code", type="string", length=50, nullable=true)
     */
    private $fnDebtorCode;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_debtor_desc", type="string", length=50, nullable=true)
     */
    private $fnDebtorDesc;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_debtor_export_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnDebtorExportYn;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_persona_id", type="string", length=36, nullable=true)
     */
    private $prPersonaId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_currency_id", type="string", length=36, nullable=true)
     */
    private $rfCurrencyId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_business_id", type="string", length=36, nullable=true)
     */
    private $prBusinessId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_debtor_inactive_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnDebtorInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_debtor_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnDebtorTrfYn;



    /**
     * Get fnDebtorIx
     *
     * @return string
     */
    public function getFnDebtorIx()
    {
        return $this->fnDebtorIx;
    }

    /**
     * Set fnDebtorDb
     *
     * @param string $fnDebtorDb
     *
     * @return FnDebtor
     */
    public function setFnDebtorDb($fnDebtorDb)
    {
        $this->fnDebtorDb = $fnDebtorDb;

        return $this;
    }

    /**
     * Get fnDebtorDb
     *
     * @return string
     */
    public function getFnDebtorDb()
    {
        return $this->fnDebtorDb;
    }

    /**
     * Set fnDebtorId
     *
     * @param integer $fnDebtorId
     *
     * @return FnDebtor
     */
    public function setFnDebtorId($fnDebtorId)
    {
        $this->fnDebtorId = $fnDebtorId;

        return $this;
    }

    /**
     * Get fnDebtorId
     *
     * @return integer
     */
    public function getFnDebtorId()
    {
        return $this->fnDebtorId;
    }

    /**
     * Set fnDebtorCode
     *
     * @param string $fnDebtorCode
     *
     * @return FnDebtor
     */
    public function setFnDebtorCode($fnDebtorCode)
    {
        $this->fnDebtorCode = $fnDebtorCode;

        return $this;
    }

    /**
     * Get fnDebtorCode
     *
     * @return string
     */
    public function getFnDebtorCode()
    {
        return $this->fnDebtorCode;
    }

    /**
     * Set fnDebtorDesc
     *
     * @param string $fnDebtorDesc
     *
     * @return FnDebtor
     */
    public function setFnDebtorDesc($fnDebtorDesc)
    {
        $this->fnDebtorDesc = $fnDebtorDesc;

        return $this;
    }

    /**
     * Get fnDebtorDesc
     *
     * @return string
     */
    public function getFnDebtorDesc()
    {
        return $this->fnDebtorDesc;
    }

    /**
     * Set fnDebtorExportYn
     *
     * @param boolean $fnDebtorExportYn
     *
     * @return FnDebtor
     */
    public function setFnDebtorExportYn($fnDebtorExportYn)
    {
        $this->fnDebtorExportYn = $fnDebtorExportYn;

        return $this;
    }

    /**
     * Get fnDebtorExportYn
     *
     * @return boolean
     */
    public function getFnDebtorExportYn()
    {
        return $this->fnDebtorExportYn;
    }

    /**
     * Set prPersonaId
     *
     * @param string $prPersonaId
     *
     * @return FnDebtor
     */
    public function setPrPersonaId($prPersonaId)
    {
        $this->prPersonaId = $prPersonaId;

        return $this;
    }

    /**
     * Get prPersonaId
     *
     * @return string
     */
    public function getPrPersonaId()
    {
        return $this->prPersonaId;
    }

    /**
     * Set rfCurrencyId
     *
     * @param string $rfCurrencyId
     *
     * @return FnDebtor
     */
    public function setRfCurrencyId($rfCurrencyId)
    {
        $this->rfCurrencyId = $rfCurrencyId;

        return $this;
    }

    /**
     * Get rfCurrencyId
     *
     * @return string
     */
    public function getRfCurrencyId()
    {
        return $this->rfCurrencyId;
    }

    /**
     * Set prBusinessId
     *
     * @param string $prBusinessId
     *
     * @return FnDebtor
     */
    public function setPrBusinessId($prBusinessId)
    {
        $this->prBusinessId = $prBusinessId;

        return $this;
    }

    /**
     * Get prBusinessId
     *
     * @return string
     */
    public function getPrBusinessId()
    {
        return $this->prBusinessId;
    }

    /**
     * Set fnDebtorInactiveYn
     *
     * @param boolean $fnDebtorInactiveYn
     *
     * @return FnDebtor
     */
    public function setFnDebtorInactiveYn($fnDebtorInactiveYn)
    {
        $this->fnDebtorInactiveYn = $fnDebtorInactiveYn;

        return $this;
    }

    /**
     * Get fnDebtorInactiveYn
     *
     * @return boolean
     */
    public function getFnDebtorInactiveYn()
    {
        return $this->fnDebtorInactiveYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return FnDebtor
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set fnDebtorTrfYn
     *
     * @param boolean $fnDebtorTrfYn
     *
     * @return FnDebtor
     */
    public function setFnDebtorTrfYn($fnDebtorTrfYn)
    {
        $this->fnDebtorTrfYn = $fnDebtorTrfYn;

        return $this;
    }

    /**
     * Get fnDebtorTrfYn
     *
     * @return boolean
     */
    public function getFnDebtorTrfYn()
    {
        return $this->fnDebtorTrfYn;
    }
}
