<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * FnFolio
 *
 * @ORM\Table(name="fn_folio", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rv_reservation_id", columns={"rv_reservation_id"}), @ORM\Index(name="fn_folio_trf_yn", columns={"fn_folio_trf_yn"}), @ORM\Index(name="fn_folio_status_ind", columns={"fn_folio_status_ind"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class FnFolio
{
    /**
     * @var string
     *
     * @ORM\Column(name="fn_folio_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $fnFolioIx;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_folio_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $fnFolioDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="fn_folio_id", type="integer", nullable=false)
     */
    private $fnFolioId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_folio_amount", type="decimal", precision=16, scale=2, nullable=true)
     */
    private $fnFolioAmount;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_folio_amt_comm", type="decimal", precision=16, scale=2, nullable=true)
     */
    private $fnFolioAmtComm;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_folio_amt_paid", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.00"})
     */
    private $fnFolioAmtPaid;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_folio_amt_tax", type="decimal", precision=16, scale=6, nullable=true)
     */
    private $fnFolioAmtTax;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_folio_amt_tba_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnFolioAmtTbaYn;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="fn_folio_date", type="date", nullable=false, options={"default"="0000-00-00"})
     */
    private $fnFolioDate;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_folio_folio_num", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnFolioFolioNum;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_folio_status_ind", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnFolioStatusInd;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_invoice_id", type="string", length=18, nullable=true)
     */
    private $fnInvoiceId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_folio_to_id", type="string", length=36, nullable=true)
     */
    private $fnFolioToId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_business_id", type="string", length=36, nullable=true)
     */
    private $prBusinessId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_bank_id", type="string", length=36, nullable=true)
     */
    private $rfBankId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_currency_id", type="string", length=36, nullable=true)
     */
    private $rfCurrencyId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_reservation_id", type="string", length=36, nullable=true)
     */
    private $rvReservationId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_res_item_group_id", type="string", length=36, nullable=true)
     */
    private $rvResItemGroupId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_create_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adCreateDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_date_tz", type="string", length=40, nullable=false)
     */
    private $adCreateDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_user_id", type="string", length=36, nullable=true)
     */
    private $adCreateUserId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_modify_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adModifyDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_date_tz", type="string", length=40, nullable=false)
     */
    private $adModifyDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_user_id", type="string", length=36, nullable=true)
     */
    private $adModifyUserId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_folio_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnFolioTrfYn;



    /**
     * Get fnFolioIx
     *
     * @return string
     */
    public function getFnFolioIx()
    {
        return $this->fnFolioIx;
    }

    /**
     * Set fnFolioDb
     *
     * @param string $fnFolioDb
     *
     * @return FnFolio
     */
    public function setFnFolioDb($fnFolioDb)
    {
        $this->fnFolioDb = $fnFolioDb;

        return $this;
    }

    /**
     * Get fnFolioDb
     *
     * @return string
     */
    public function getFnFolioDb()
    {
        return $this->fnFolioDb;
    }

    /**
     * Set fnFolioId
     *
     * @param integer $fnFolioId
     *
     * @return FnFolio
     */
    public function setFnFolioId($fnFolioId)
    {
        $this->fnFolioId = $fnFolioId;

        return $this;
    }

    /**
     * Get fnFolioId
     *
     * @return integer
     */
    public function getFnFolioId()
    {
        return $this->fnFolioId;
    }

    /**
     * Set fnFolioAmount
     *
     * @param string $fnFolioAmount
     *
     * @return FnFolio
     */
    public function setFnFolioAmount($fnFolioAmount)
    {
        $this->fnFolioAmount = $fnFolioAmount;

        return $this;
    }

    /**
     * Get fnFolioAmount
     *
     * @return string
     */
    public function getFnFolioAmount()
    {
        return $this->fnFolioAmount;
    }

    /**
     * Set fnFolioAmtComm
     *
     * @param string $fnFolioAmtComm
     *
     * @return FnFolio
     */
    public function setFnFolioAmtComm($fnFolioAmtComm)
    {
        $this->fnFolioAmtComm = $fnFolioAmtComm;

        return $this;
    }

    /**
     * Get fnFolioAmtComm
     *
     * @return string
     */
    public function getFnFolioAmtComm()
    {
        return $this->fnFolioAmtComm;
    }

    /**
     * Set fnFolioAmtPaid
     *
     * @param string $fnFolioAmtPaid
     *
     * @return FnFolio
     */
    public function setFnFolioAmtPaid($fnFolioAmtPaid)
    {
        $this->fnFolioAmtPaid = $fnFolioAmtPaid;

        return $this;
    }

    /**
     * Get fnFolioAmtPaid
     *
     * @return string
     */
    public function getFnFolioAmtPaid()
    {
        return $this->fnFolioAmtPaid;
    }

    /**
     * Set fnFolioAmtTax
     *
     * @param string $fnFolioAmtTax
     *
     * @return FnFolio
     */
    public function setFnFolioAmtTax($fnFolioAmtTax)
    {
        $this->fnFolioAmtTax = $fnFolioAmtTax;

        return $this;
    }

    /**
     * Get fnFolioAmtTax
     *
     * @return string
     */
    public function getFnFolioAmtTax()
    {
        return $this->fnFolioAmtTax;
    }

    /**
     * Set fnFolioAmtTbaYn
     *
     * @param boolean $fnFolioAmtTbaYn
     *
     * @return FnFolio
     */
    public function setFnFolioAmtTbaYn($fnFolioAmtTbaYn)
    {
        $this->fnFolioAmtTbaYn = $fnFolioAmtTbaYn;

        return $this;
    }

    /**
     * Get fnFolioAmtTbaYn
     *
     * @return boolean
     */
    public function getFnFolioAmtTbaYn()
    {
        return $this->fnFolioAmtTbaYn;
    }

    /**
     * Set fnFolioDate
     *
     * @param \DateTime $fnFolioDate
     *
     * @return FnFolio
     */
    public function setFnFolioDate($fnFolioDate)
    {
        $this->fnFolioDate = $fnFolioDate;

        return $this;
    }

    /**
     * Get fnFolioDate
     *
     * @return \DateTime
     */
    public function getFnFolioDate()
    {
        return $this->fnFolioDate;
    }

    /**
     * Set fnFolioFolioNum
     *
     * @param boolean $fnFolioFolioNum
     *
     * @return FnFolio
     */
    public function setFnFolioFolioNum($fnFolioFolioNum)
    {
        $this->fnFolioFolioNum = $fnFolioFolioNum;

        return $this;
    }

    /**
     * Get fnFolioFolioNum
     *
     * @return boolean
     */
    public function getFnFolioFolioNum()
    {
        return $this->fnFolioFolioNum;
    }

    /**
     * Set fnFolioStatusInd
     *
     * @param boolean $fnFolioStatusInd
     *
     * @return FnFolio
     */
    public function setFnFolioStatusInd($fnFolioStatusInd)
    {
        $this->fnFolioStatusInd = $fnFolioStatusInd;

        return $this;
    }

    /**
     * Get fnFolioStatusInd
     *
     * @return boolean
     */
    public function getFnFolioStatusInd()
    {
        return $this->fnFolioStatusInd;
    }

    /**
     * Set fnInvoiceId
     *
     * @param string $fnInvoiceId
     *
     * @return FnFolio
     */
    public function setFnInvoiceId($fnInvoiceId)
    {
        $this->fnInvoiceId = $fnInvoiceId;

        return $this;
    }

    /**
     * Get fnInvoiceId
     *
     * @return string
     */
    public function getFnInvoiceId()
    {
        return $this->fnInvoiceId;
    }

    /**
     * Set fnFolioToId
     *
     * @param string $fnFolioToId
     *
     * @return FnFolio
     */
    public function setFnFolioToId($fnFolioToId)
    {
        $this->fnFolioToId = $fnFolioToId;

        return $this;
    }

    /**
     * Get fnFolioToId
     *
     * @return string
     */
    public function getFnFolioToId()
    {
        return $this->fnFolioToId;
    }

    /**
     * Set prBusinessId
     *
     * @param string $prBusinessId
     *
     * @return FnFolio
     */
    public function setPrBusinessId($prBusinessId)
    {
        $this->prBusinessId = $prBusinessId;

        return $this;
    }

    /**
     * Get prBusinessId
     *
     * @return string
     */
    public function getPrBusinessId()
    {
        return $this->prBusinessId;
    }

    /**
     * Set rfBankId
     *
     * @param string $rfBankId
     *
     * @return FnFolio
     */
    public function setRfBankId($rfBankId)
    {
        $this->rfBankId = $rfBankId;

        return $this;
    }

    /**
     * Get rfBankId
     *
     * @return string
     */
    public function getRfBankId()
    {
        return $this->rfBankId;
    }

    /**
     * Set rfCurrencyId
     *
     * @param string $rfCurrencyId
     *
     * @return FnFolio
     */
    public function setRfCurrencyId($rfCurrencyId)
    {
        $this->rfCurrencyId = $rfCurrencyId;

        return $this;
    }

    /**
     * Get rfCurrencyId
     *
     * @return string
     */
    public function getRfCurrencyId()
    {
        return $this->rfCurrencyId;
    }

    /**
     * Set rvReservationId
     *
     * @param string $rvReservationId
     *
     * @return FnFolio
     */
    public function setRvReservationId($rvReservationId)
    {
        $this->rvReservationId = $rvReservationId;

        return $this;
    }

    /**
     * Get rvReservationId
     *
     * @return string
     */
    public function getRvReservationId()
    {
        return $this->rvReservationId;
    }

    /**
     * Set rvResItemGroupId
     *
     * @param string $rvResItemGroupId
     *
     * @return FnFolio
     */
    public function setRvResItemGroupId($rvResItemGroupId)
    {
        $this->rvResItemGroupId = $rvResItemGroupId;

        return $this;
    }

    /**
     * Get rvResItemGroupId
     *
     * @return string
     */
    public function getRvResItemGroupId()
    {
        return $this->rvResItemGroupId;
    }

    /**
     * Set adCreateDate
     *
     * @param \DateTime $adCreateDate
     *
     * @return FnFolio
     */
    public function setAdCreateDate($adCreateDate)
    {
        $this->adCreateDate = $adCreateDate;

        return $this;
    }

    /**
     * Get adCreateDate
     *
     * @return \DateTime
     */
    public function getAdCreateDate()
    {
        return $this->adCreateDate;
    }

    /**
     * Set adCreateDateTz
     *
     * @param string $adCreateDateTz
     *
     * @return FnFolio
     */
    public function setAdCreateDateTz($adCreateDateTz)
    {
        $this->adCreateDateTz = $adCreateDateTz;

        return $this;
    }

    /**
     * Get adCreateDateTz
     *
     * @return string
     */
    public function getAdCreateDateTz()
    {
        return $this->adCreateDateTz;
    }

    /**
     * Set adCreateUserId
     *
     * @param string $adCreateUserId
     *
     * @return FnFolio
     */
    public function setAdCreateUserId($adCreateUserId)
    {
        $this->adCreateUserId = $adCreateUserId;

        return $this;
    }

    /**
     * Get adCreateUserId
     *
     * @return string
     */
    public function getAdCreateUserId()
    {
        return $this->adCreateUserId;
    }

    /**
     * Set adModifyDate
     *
     * @param \DateTime $adModifyDate
     *
     * @return FnFolio
     */
    public function setAdModifyDate($adModifyDate)
    {
        $this->adModifyDate = $adModifyDate;

        return $this;
    }

    /**
     * Get adModifyDate
     *
     * @return \DateTime
     */
    public function getAdModifyDate()
    {
        return $this->adModifyDate;
    }

    /**
     * Set adModifyDateTz
     *
     * @param string $adModifyDateTz
     *
     * @return FnFolio
     */
    public function setAdModifyDateTz($adModifyDateTz)
    {
        $this->adModifyDateTz = $adModifyDateTz;

        return $this;
    }

    /**
     * Get adModifyDateTz
     *
     * @return string
     */
    public function getAdModifyDateTz()
    {
        return $this->adModifyDateTz;
    }

    /**
     * Set adModifyUserId
     *
     * @param string $adModifyUserId
     *
     * @return FnFolio
     */
    public function setAdModifyUserId($adModifyUserId)
    {
        $this->adModifyUserId = $adModifyUserId;

        return $this;
    }

    /**
     * Get adModifyUserId
     *
     * @return string
     */
    public function getAdModifyUserId()
    {
        return $this->adModifyUserId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return FnFolio
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set fnFolioTrfYn
     *
     * @param boolean $fnFolioTrfYn
     *
     * @return FnFolio
     */
    public function setFnFolioTrfYn($fnFolioTrfYn)
    {
        $this->fnFolioTrfYn = $fnFolioTrfYn;

        return $this;
    }

    /**
     * Get fnFolioTrfYn
     *
     * @return boolean
     */
    public function getFnFolioTrfYn()
    {
        return $this->fnFolioTrfYn;
    }
}
