<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * FnInvoice
 *
 * @ORM\Table(name="fn_invoice", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="fn_invoice_trf_yn", columns={"fn_invoice_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"}), @ORM\Index(name="fn_inv_status_ind", columns={"fn_inv_status_ind"}), @ORM\Index(name="fn_folio_id", columns={"fn_folio_id"}), @ORM\Index(name="rv_reservation_id", columns={"rv_reservation_id"})})
 * @ORM\Entity
 */
class FnInvoice
{
    /**
     * @var string
     *
     * @ORM\Column(name="fn_invoice_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $fnInvoiceIx;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_invoice_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $fnInvoiceDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="fn_invoice_id", type="integer", nullable=false)
     */
    private $fnInvoiceId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_agent_ref", type="string", length=50, nullable=false, options={"default"=""})
     */
    private $fnInvAgentRef;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_amt_comm", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.00"})
     */
    private $fnInvAmtComm;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_amt_paid", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.00"})
     */
    private $fnInvAmtPaid;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_amt_payable", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.00"})
     */
    private $fnInvAmtPayable;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_amt_tax", type="decimal", precision=16, scale=6, nullable=false, options={"default"="0.000000"})
     */
    private $fnInvAmtTax;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_be_addr_line1", type="string", length=50, nullable=true)
     */
    private $fnInvBeAddrLine1;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_be_addr_line2", type="string", length=50, nullable=true)
     */
    private $fnInvBeAddrLine2;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_be_addr_line3", type="string", length=50, nullable=true)
     */
    private $fnInvBeAddrLine3;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_be_city", type="string", length=50, nullable=true)
     */
    private $fnInvBeCity;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_be_country", type="string", length=50, nullable=true)
     */
    private $fnInvBeCountry;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_be_email", type="string", length=50, nullable=true)
     */
    private $fnInvBeEmail;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_be_fax", type="string", length=50, nullable=true)
     */
    private $fnInvBeFax;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_be_phone", type="string", length=50, nullable=true)
     */
    private $fnInvBePhone;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_be_post_code", type="string", length=50, nullable=true)
     */
    private $fnInvBePostCode;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_be_statutory_1", type="string", length=50, nullable=true)
     */
    private $fnInvBeStatutory1;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_be_statutory_2", type="string", length=50, nullable=true)
     */
    private $fnInvBeStatutory2;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_be_statutory_3", type="string", length=50, nullable=true)
     */
    private $fnInvBeStatutory3;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_be_statutory_label_1", type="string", length=50, nullable=true)
     */
    private $fnInvBeStatutoryLabel1;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_be_statutory_label_2", type="string", length=50, nullable=true)
     */
    private $fnInvBeStatutoryLabel2;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_be_statutory_label_3", type="string", length=50, nullable=true)
     */
    private $fnInvBeStatutoryLabel3;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_be_web_addr", type="string", length=50, nullable=true)
     */
    private $fnInvBeWebAddr;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_booking_info", type="text", length=65535, nullable=true)
     */
    private $fnInvBookingInfo;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_bus_memo_conditions", type="text", length=65535, nullable=true)
     */
    private $fnInvBusMemoConditions;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_curr", type="string", length=3, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $fnInvCurr;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_curr_home", type="string", length=3, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $fnInvCurrHome;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_inv_opt_accomm", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnInvOptAccomm;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_inv_opt_bank", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnInvOptBank;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_inv_opt_cca", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnInvOptCca;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_inv_opt_date", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnInvOptDate;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_inv_opt_special", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnInvOptSpecial;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_inv_opt_special_note", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnInvOptSpecialNote;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_inv_opt_tax", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnInvOptTax;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_inv_opt_tax_table", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnInvOptTaxTable;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_inv_opt_tax_table_gl", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnInvOptTaxTableGl;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_inv_opt_tax_table_rate", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnInvOptTaxTableRate;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_inv_opt_tax_table_total", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnInvOptTaxTableTotal;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_inv_opt_terms", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnInvOptTerms;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_inv_opt_terms_bus", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnInvOptTermsBus;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_inv_tax_table_align", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnInvTaxTableAlign = '0';

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_to_addr_line1", type="string", length=50, nullable=true)
     */
    private $fnInvToAddrLine1;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_to_addr_line2", type="string", length=50, nullable=true)
     */
    private $fnInvToAddrLine2;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_to_addr_line3", type="string", length=50, nullable=true)
     */
    private $fnInvToAddrLine3;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_to_city", type="string", length=50, nullable=true)
     */
    private $fnInvToCity;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_to_country", type="string", length=50, nullable=true)
     */
    private $fnInvToCountry;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_to_post_code", type="string", length=50, nullable=true)
     */
    private $fnInvToPostCode;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_to_statutory_1", type="string", length=50, nullable=true)
     */
    private $fnInvToStatutory1;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_to_statutory_2", type="string", length=50, nullable=true)
     */
    private $fnInvToStatutory2;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_to_statutory_3", type="string", length=50, nullable=true)
     */
    private $fnInvToStatutory3;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="fn_inv_date", type="date", nullable=false, options={"default"="0000-00-00"})
     */
    private $fnInvDate;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_exch_rate", type="decimal", precision=16, scale=6, nullable=false, options={"default"="1.000000"})
     */
    private $fnInvExchRate;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_exch_rate_balance", type="decimal", precision=16, scale=6, nullable=false, options={"default"="1.000000"})
     */
    private $fnInvExchRateBalance;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_invoice_prefix", type="string", length=5, nullable=false, options={"default"=""})
     */
    private $fnInvoicePrefix;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_inv_print_count", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnInvPrintCount;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_inv_status_ind", type="boolean", nullable=false, options={"default"="2"})
     */
    private $fnInvStatusInd;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_inv_type_ind", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnInvTypeInd;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_inv_reverse_ind", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnInvReverseInd;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_reverse_link_id", type="string", length=18, nullable=true)
     */
    private $fnInvReverseLinkId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_inv_void_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnInvVoidYn;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="fn_inv_void_date", type="date", nullable=false, options={"default"="0000-00-00"})
     */
    private $fnInvVoidDate;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_void_user_id", type="string", length=36, nullable=true)
     */
    private $fnInvVoidUserId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_from", type="string", length=95, nullable=false, options={"default"=""})
     */
    private $fnInvFrom;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_to", type="string", length=95, nullable=false, options={"default"=""})
     */
    private $fnInvTo;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_folio_id", type="string", length=36, nullable=true)
     */
    private $fnFolioId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_business_id", type="string", length=36, nullable=true)
     */
    private $prBusinessId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_post_id", type="string", length=36, nullable=true)
     */
    private $fnPostId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_reservation_id", type="string", length=36, nullable=true)
     */
    private $rvReservationId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_create_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adCreateDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_date_tz", type="string", length=40, nullable=false)
     */
    private $adCreateDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_user_id", type="string", length=36, nullable=true)
     */
    private $adCreateUserId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_modify_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adModifyDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_date_tz", type="string", length=40, nullable=false)
     */
    private $adModifyDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_user_id", type="string", length=36, nullable=true)
     */
    private $adModifyUserId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_invoice_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnInvoiceTrfYn;



    /**
     * Get fnInvoiceIx
     *
     * @return string
     */
    public function getFnInvoiceIx()
    {
        return $this->fnInvoiceIx;
    }

    /**
     * Set fnInvoiceDb
     *
     * @param string $fnInvoiceDb
     *
     * @return FnInvoice
     */
    public function setFnInvoiceDb($fnInvoiceDb)
    {
        $this->fnInvoiceDb = $fnInvoiceDb;

        return $this;
    }

    /**
     * Get fnInvoiceDb
     *
     * @return string
     */
    public function getFnInvoiceDb()
    {
        return $this->fnInvoiceDb;
    }

    /**
     * Set fnInvoiceId
     *
     * @param integer $fnInvoiceId
     *
     * @return FnInvoice
     */
    public function setFnInvoiceId($fnInvoiceId)
    {
        $this->fnInvoiceId = $fnInvoiceId;

        return $this;
    }

    /**
     * Get fnInvoiceId
     *
     * @return integer
     */
    public function getFnInvoiceId()
    {
        return $this->fnInvoiceId;
    }

    /**
     * Set fnInvAgentRef
     *
     * @param string $fnInvAgentRef
     *
     * @return FnInvoice
     */
    public function setFnInvAgentRef($fnInvAgentRef)
    {
        $this->fnInvAgentRef = $fnInvAgentRef;

        return $this;
    }

    /**
     * Get fnInvAgentRef
     *
     * @return string
     */
    public function getFnInvAgentRef()
    {
        return $this->fnInvAgentRef;
    }

    /**
     * Set fnInvAmtComm
     *
     * @param string $fnInvAmtComm
     *
     * @return FnInvoice
     */
    public function setFnInvAmtComm($fnInvAmtComm)
    {
        $this->fnInvAmtComm = $fnInvAmtComm;

        return $this;
    }

    /**
     * Get fnInvAmtComm
     *
     * @return string
     */
    public function getFnInvAmtComm()
    {
        return $this->fnInvAmtComm;
    }

    /**
     * Set fnInvAmtPaid
     *
     * @param string $fnInvAmtPaid
     *
     * @return FnInvoice
     */
    public function setFnInvAmtPaid($fnInvAmtPaid)
    {
        $this->fnInvAmtPaid = $fnInvAmtPaid;

        return $this;
    }

    /**
     * Get fnInvAmtPaid
     *
     * @return string
     */
    public function getFnInvAmtPaid()
    {
        return $this->fnInvAmtPaid;
    }

    /**
     * Set fnInvAmtPayable
     *
     * @param string $fnInvAmtPayable
     *
     * @return FnInvoice
     */
    public function setFnInvAmtPayable($fnInvAmtPayable)
    {
        $this->fnInvAmtPayable = $fnInvAmtPayable;

        return $this;
    }

    /**
     * Get fnInvAmtPayable
     *
     * @return string
     */
    public function getFnInvAmtPayable()
    {
        return $this->fnInvAmtPayable;
    }

    /**
     * Set fnInvAmtTax
     *
     * @param string $fnInvAmtTax
     *
     * @return FnInvoice
     */
    public function setFnInvAmtTax($fnInvAmtTax)
    {
        $this->fnInvAmtTax = $fnInvAmtTax;

        return $this;
    }

    /**
     * Get fnInvAmtTax
     *
     * @return string
     */
    public function getFnInvAmtTax()
    {
        return $this->fnInvAmtTax;
    }

    /**
     * Set fnInvBeAddrLine1
     *
     * @param string $fnInvBeAddrLine1
     *
     * @return FnInvoice
     */
    public function setFnInvBeAddrLine1($fnInvBeAddrLine1)
    {
        $this->fnInvBeAddrLine1 = $fnInvBeAddrLine1;

        return $this;
    }

    /**
     * Get fnInvBeAddrLine1
     *
     * @return string
     */
    public function getFnInvBeAddrLine1()
    {
        return $this->fnInvBeAddrLine1;
    }

    /**
     * Set fnInvBeAddrLine2
     *
     * @param string $fnInvBeAddrLine2
     *
     * @return FnInvoice
     */
    public function setFnInvBeAddrLine2($fnInvBeAddrLine2)
    {
        $this->fnInvBeAddrLine2 = $fnInvBeAddrLine2;

        return $this;
    }

    /**
     * Get fnInvBeAddrLine2
     *
     * @return string
     */
    public function getFnInvBeAddrLine2()
    {
        return $this->fnInvBeAddrLine2;
    }

    /**
     * Set fnInvBeAddrLine3
     *
     * @param string $fnInvBeAddrLine3
     *
     * @return FnInvoice
     */
    public function setFnInvBeAddrLine3($fnInvBeAddrLine3)
    {
        $this->fnInvBeAddrLine3 = $fnInvBeAddrLine3;

        return $this;
    }

    /**
     * Get fnInvBeAddrLine3
     *
     * @return string
     */
    public function getFnInvBeAddrLine3()
    {
        return $this->fnInvBeAddrLine3;
    }

    /**
     * Set fnInvBeCity
     *
     * @param string $fnInvBeCity
     *
     * @return FnInvoice
     */
    public function setFnInvBeCity($fnInvBeCity)
    {
        $this->fnInvBeCity = $fnInvBeCity;

        return $this;
    }

    /**
     * Get fnInvBeCity
     *
     * @return string
     */
    public function getFnInvBeCity()
    {
        return $this->fnInvBeCity;
    }

    /**
     * Set fnInvBeCountry
     *
     * @param string $fnInvBeCountry
     *
     * @return FnInvoice
     */
    public function setFnInvBeCountry($fnInvBeCountry)
    {
        $this->fnInvBeCountry = $fnInvBeCountry;

        return $this;
    }

    /**
     * Get fnInvBeCountry
     *
     * @return string
     */
    public function getFnInvBeCountry()
    {
        return $this->fnInvBeCountry;
    }

    /**
     * Set fnInvBeEmail
     *
     * @param string $fnInvBeEmail
     *
     * @return FnInvoice
     */
    public function setFnInvBeEmail($fnInvBeEmail)
    {
        $this->fnInvBeEmail = $fnInvBeEmail;

        return $this;
    }

    /**
     * Get fnInvBeEmail
     *
     * @return string
     */
    public function getFnInvBeEmail()
    {
        return $this->fnInvBeEmail;
    }

    /**
     * Set fnInvBeFax
     *
     * @param string $fnInvBeFax
     *
     * @return FnInvoice
     */
    public function setFnInvBeFax($fnInvBeFax)
    {
        $this->fnInvBeFax = $fnInvBeFax;

        return $this;
    }

    /**
     * Get fnInvBeFax
     *
     * @return string
     */
    public function getFnInvBeFax()
    {
        return $this->fnInvBeFax;
    }

    /**
     * Set fnInvBePhone
     *
     * @param string $fnInvBePhone
     *
     * @return FnInvoice
     */
    public function setFnInvBePhone($fnInvBePhone)
    {
        $this->fnInvBePhone = $fnInvBePhone;

        return $this;
    }

    /**
     * Get fnInvBePhone
     *
     * @return string
     */
    public function getFnInvBePhone()
    {
        return $this->fnInvBePhone;
    }

    /**
     * Set fnInvBePostCode
     *
     * @param string $fnInvBePostCode
     *
     * @return FnInvoice
     */
    public function setFnInvBePostCode($fnInvBePostCode)
    {
        $this->fnInvBePostCode = $fnInvBePostCode;

        return $this;
    }

    /**
     * Get fnInvBePostCode
     *
     * @return string
     */
    public function getFnInvBePostCode()
    {
        return $this->fnInvBePostCode;
    }

    /**
     * Set fnInvBeStatutory1
     *
     * @param string $fnInvBeStatutory1
     *
     * @return FnInvoice
     */
    public function setFnInvBeStatutory1($fnInvBeStatutory1)
    {
        $this->fnInvBeStatutory1 = $fnInvBeStatutory1;

        return $this;
    }

    /**
     * Get fnInvBeStatutory1
     *
     * @return string
     */
    public function getFnInvBeStatutory1()
    {
        return $this->fnInvBeStatutory1;
    }

    /**
     * Set fnInvBeStatutory2
     *
     * @param string $fnInvBeStatutory2
     *
     * @return FnInvoice
     */
    public function setFnInvBeStatutory2($fnInvBeStatutory2)
    {
        $this->fnInvBeStatutory2 = $fnInvBeStatutory2;

        return $this;
    }

    /**
     * Get fnInvBeStatutory2
     *
     * @return string
     */
    public function getFnInvBeStatutory2()
    {
        return $this->fnInvBeStatutory2;
    }

    /**
     * Set fnInvBeStatutory3
     *
     * @param string $fnInvBeStatutory3
     *
     * @return FnInvoice
     */
    public function setFnInvBeStatutory3($fnInvBeStatutory3)
    {
        $this->fnInvBeStatutory3 = $fnInvBeStatutory3;

        return $this;
    }

    /**
     * Get fnInvBeStatutory3
     *
     * @return string
     */
    public function getFnInvBeStatutory3()
    {
        return $this->fnInvBeStatutory3;
    }

    /**
     * Set fnInvBeStatutoryLabel1
     *
     * @param string $fnInvBeStatutoryLabel1
     *
     * @return FnInvoice
     */
    public function setFnInvBeStatutoryLabel1($fnInvBeStatutoryLabel1)
    {
        $this->fnInvBeStatutoryLabel1 = $fnInvBeStatutoryLabel1;

        return $this;
    }

    /**
     * Get fnInvBeStatutoryLabel1
     *
     * @return string
     */
    public function getFnInvBeStatutoryLabel1()
    {
        return $this->fnInvBeStatutoryLabel1;
    }

    /**
     * Set fnInvBeStatutoryLabel2
     *
     * @param string $fnInvBeStatutoryLabel2
     *
     * @return FnInvoice
     */
    public function setFnInvBeStatutoryLabel2($fnInvBeStatutoryLabel2)
    {
        $this->fnInvBeStatutoryLabel2 = $fnInvBeStatutoryLabel2;

        return $this;
    }

    /**
     * Get fnInvBeStatutoryLabel2
     *
     * @return string
     */
    public function getFnInvBeStatutoryLabel2()
    {
        return $this->fnInvBeStatutoryLabel2;
    }

    /**
     * Set fnInvBeStatutoryLabel3
     *
     * @param string $fnInvBeStatutoryLabel3
     *
     * @return FnInvoice
     */
    public function setFnInvBeStatutoryLabel3($fnInvBeStatutoryLabel3)
    {
        $this->fnInvBeStatutoryLabel3 = $fnInvBeStatutoryLabel3;

        return $this;
    }

    /**
     * Get fnInvBeStatutoryLabel3
     *
     * @return string
     */
    public function getFnInvBeStatutoryLabel3()
    {
        return $this->fnInvBeStatutoryLabel3;
    }

    /**
     * Set fnInvBeWebAddr
     *
     * @param string $fnInvBeWebAddr
     *
     * @return FnInvoice
     */
    public function setFnInvBeWebAddr($fnInvBeWebAddr)
    {
        $this->fnInvBeWebAddr = $fnInvBeWebAddr;

        return $this;
    }

    /**
     * Get fnInvBeWebAddr
     *
     * @return string
     */
    public function getFnInvBeWebAddr()
    {
        return $this->fnInvBeWebAddr;
    }

    /**
     * Set fnInvBookingInfo
     *
     * @param string $fnInvBookingInfo
     *
     * @return FnInvoice
     */
    public function setFnInvBookingInfo($fnInvBookingInfo)
    {
        $this->fnInvBookingInfo = $fnInvBookingInfo;

        return $this;
    }

    /**
     * Get fnInvBookingInfo
     *
     * @return string
     */
    public function getFnInvBookingInfo()
    {
        return $this->fnInvBookingInfo;
    }

    /**
     * Set fnInvBusMemoConditions
     *
     * @param string $fnInvBusMemoConditions
     *
     * @return FnInvoice
     */
    public function setFnInvBusMemoConditions($fnInvBusMemoConditions)
    {
        $this->fnInvBusMemoConditions = $fnInvBusMemoConditions;

        return $this;
    }

    /**
     * Get fnInvBusMemoConditions
     *
     * @return string
     */
    public function getFnInvBusMemoConditions()
    {
        return $this->fnInvBusMemoConditions;
    }

    /**
     * Set fnInvCurr
     *
     * @param string $fnInvCurr
     *
     * @return FnInvoice
     */
    public function setFnInvCurr($fnInvCurr)
    {
        $this->fnInvCurr = $fnInvCurr;

        return $this;
    }

    /**
     * Get fnInvCurr
     *
     * @return string
     */
    public function getFnInvCurr()
    {
        return $this->fnInvCurr;
    }

    /**
     * Set fnInvCurrHome
     *
     * @param string $fnInvCurrHome
     *
     * @return FnInvoice
     */
    public function setFnInvCurrHome($fnInvCurrHome)
    {
        $this->fnInvCurrHome = $fnInvCurrHome;

        return $this;
    }

    /**
     * Get fnInvCurrHome
     *
     * @return string
     */
    public function getFnInvCurrHome()
    {
        return $this->fnInvCurrHome;
    }

    /**
     * Set fnInvOptAccomm
     *
     * @param boolean $fnInvOptAccomm
     *
     * @return FnInvoice
     */
    public function setFnInvOptAccomm($fnInvOptAccomm)
    {
        $this->fnInvOptAccomm = $fnInvOptAccomm;

        return $this;
    }

    /**
     * Get fnInvOptAccomm
     *
     * @return boolean
     */
    public function getFnInvOptAccomm()
    {
        return $this->fnInvOptAccomm;
    }

    /**
     * Set fnInvOptBank
     *
     * @param boolean $fnInvOptBank
     *
     * @return FnInvoice
     */
    public function setFnInvOptBank($fnInvOptBank)
    {
        $this->fnInvOptBank = $fnInvOptBank;

        return $this;
    }

    /**
     * Get fnInvOptBank
     *
     * @return boolean
     */
    public function getFnInvOptBank()
    {
        return $this->fnInvOptBank;
    }

    /**
     * Set fnInvOptCca
     *
     * @param boolean $fnInvOptCca
     *
     * @return FnInvoice
     */
    public function setFnInvOptCca($fnInvOptCca)
    {
        $this->fnInvOptCca = $fnInvOptCca;

        return $this;
    }

    /**
     * Get fnInvOptCca
     *
     * @return boolean
     */
    public function getFnInvOptCca()
    {
        return $this->fnInvOptCca;
    }

    /**
     * Set fnInvOptDate
     *
     * @param boolean $fnInvOptDate
     *
     * @return FnInvoice
     */
    public function setFnInvOptDate($fnInvOptDate)
    {
        $this->fnInvOptDate = $fnInvOptDate;

        return $this;
    }

    /**
     * Get fnInvOptDate
     *
     * @return boolean
     */
    public function getFnInvOptDate()
    {
        return $this->fnInvOptDate;
    }

    /**
     * Set fnInvOptSpecial
     *
     * @param boolean $fnInvOptSpecial
     *
     * @return FnInvoice
     */
    public function setFnInvOptSpecial($fnInvOptSpecial)
    {
        $this->fnInvOptSpecial = $fnInvOptSpecial;

        return $this;
    }

    /**
     * Get fnInvOptSpecial
     *
     * @return boolean
     */
    public function getFnInvOptSpecial()
    {
        return $this->fnInvOptSpecial;
    }

    /**
     * Set fnInvOptSpecialNote
     *
     * @param boolean $fnInvOptSpecialNote
     *
     * @return FnInvoice
     */
    public function setFnInvOptSpecialNote($fnInvOptSpecialNote)
    {
        $this->fnInvOptSpecialNote = $fnInvOptSpecialNote;

        return $this;
    }

    /**
     * Get fnInvOptSpecialNote
     *
     * @return boolean
     */
    public function getFnInvOptSpecialNote()
    {
        return $this->fnInvOptSpecialNote;
    }

    /**
     * Set fnInvOptTax
     *
     * @param boolean $fnInvOptTax
     *
     * @return FnInvoice
     */
    public function setFnInvOptTax($fnInvOptTax)
    {
        $this->fnInvOptTax = $fnInvOptTax;

        return $this;
    }

    /**
     * Get fnInvOptTax
     *
     * @return boolean
     */
    public function getFnInvOptTax()
    {
        return $this->fnInvOptTax;
    }

    /**
     * Set fnInvOptTaxTable
     *
     * @param boolean $fnInvOptTaxTable
     *
     * @return FnInvoice
     */
    public function setFnInvOptTaxTable($fnInvOptTaxTable)
    {
        $this->fnInvOptTaxTable = $fnInvOptTaxTable;

        return $this;
    }

    /**
     * Get fnInvOptTaxTable
     *
     * @return boolean
     */
    public function getFnInvOptTaxTable()
    {
        return $this->fnInvOptTaxTable;
    }

    /**
     * Set fnInvOptTaxTableGl
     *
     * @param boolean $fnInvOptTaxTableGl
     *
     * @return FnInvoice
     */
    public function setFnInvOptTaxTableGl($fnInvOptTaxTableGl)
    {
        $this->fnInvOptTaxTableGl = $fnInvOptTaxTableGl;

        return $this;
    }

    /**
     * Get fnInvOptTaxTableGl
     *
     * @return boolean
     */
    public function getFnInvOptTaxTableGl()
    {
        return $this->fnInvOptTaxTableGl;
    }

    /**
     * Set fnInvOptTaxTableRate
     *
     * @param boolean $fnInvOptTaxTableRate
     *
     * @return FnInvoice
     */
    public function setFnInvOptTaxTableRate($fnInvOptTaxTableRate)
    {
        $this->fnInvOptTaxTableRate = $fnInvOptTaxTableRate;

        return $this;
    }

    /**
     * Get fnInvOptTaxTableRate
     *
     * @return boolean
     */
    public function getFnInvOptTaxTableRate()
    {
        return $this->fnInvOptTaxTableRate;
    }

    /**
     * Set fnInvOptTaxTableTotal
     *
     * @param boolean $fnInvOptTaxTableTotal
     *
     * @return FnInvoice
     */
    public function setFnInvOptTaxTableTotal($fnInvOptTaxTableTotal)
    {
        $this->fnInvOptTaxTableTotal = $fnInvOptTaxTableTotal;

        return $this;
    }

    /**
     * Get fnInvOptTaxTableTotal
     *
     * @return boolean
     */
    public function getFnInvOptTaxTableTotal()
    {
        return $this->fnInvOptTaxTableTotal;
    }

    /**
     * Set fnInvOptTerms
     *
     * @param boolean $fnInvOptTerms
     *
     * @return FnInvoice
     */
    public function setFnInvOptTerms($fnInvOptTerms)
    {
        $this->fnInvOptTerms = $fnInvOptTerms;

        return $this;
    }

    /**
     * Get fnInvOptTerms
     *
     * @return boolean
     */
    public function getFnInvOptTerms()
    {
        return $this->fnInvOptTerms;
    }

    /**
     * Set fnInvOptTermsBus
     *
     * @param boolean $fnInvOptTermsBus
     *
     * @return FnInvoice
     */
    public function setFnInvOptTermsBus($fnInvOptTermsBus)
    {
        $this->fnInvOptTermsBus = $fnInvOptTermsBus;

        return $this;
    }

    /**
     * Get fnInvOptTermsBus
     *
     * @return boolean
     */
    public function getFnInvOptTermsBus()
    {
        return $this->fnInvOptTermsBus;
    }

    /**
     * Set fnInvTaxTableAlign
     *
     * @param boolean $fnInvTaxTableAlign
     *
     * @return FnInvoice
     */
    public function setFnInvTaxTableAlign($fnInvTaxTableAlign)
    {
        $this->fnInvTaxTableAlign = $fnInvTaxTableAlign;

        return $this;
    }

    /**
     * Get fnInvTaxTableAlign
     *
     * @return boolean
     */
    public function getFnInvTaxTableAlign()
    {
        return $this->fnInvTaxTableAlign;
    }

    /**
     * Set fnInvToAddrLine1
     *
     * @param string $fnInvToAddrLine1
     *
     * @return FnInvoice
     */
    public function setFnInvToAddrLine1($fnInvToAddrLine1)
    {
        $this->fnInvToAddrLine1 = $fnInvToAddrLine1;

        return $this;
    }

    /**
     * Get fnInvToAddrLine1
     *
     * @return string
     */
    public function getFnInvToAddrLine1()
    {
        return $this->fnInvToAddrLine1;
    }

    /**
     * Set fnInvToAddrLine2
     *
     * @param string $fnInvToAddrLine2
     *
     * @return FnInvoice
     */
    public function setFnInvToAddrLine2($fnInvToAddrLine2)
    {
        $this->fnInvToAddrLine2 = $fnInvToAddrLine2;

        return $this;
    }

    /**
     * Get fnInvToAddrLine2
     *
     * @return string
     */
    public function getFnInvToAddrLine2()
    {
        return $this->fnInvToAddrLine2;
    }

    /**
     * Set fnInvToAddrLine3
     *
     * @param string $fnInvToAddrLine3
     *
     * @return FnInvoice
     */
    public function setFnInvToAddrLine3($fnInvToAddrLine3)
    {
        $this->fnInvToAddrLine3 = $fnInvToAddrLine3;

        return $this;
    }

    /**
     * Get fnInvToAddrLine3
     *
     * @return string
     */
    public function getFnInvToAddrLine3()
    {
        return $this->fnInvToAddrLine3;
    }

    /**
     * Set fnInvToCity
     *
     * @param string $fnInvToCity
     *
     * @return FnInvoice
     */
    public function setFnInvToCity($fnInvToCity)
    {
        $this->fnInvToCity = $fnInvToCity;

        return $this;
    }

    /**
     * Get fnInvToCity
     *
     * @return string
     */
    public function getFnInvToCity()
    {
        return $this->fnInvToCity;
    }

    /**
     * Set fnInvToCountry
     *
     * @param string $fnInvToCountry
     *
     * @return FnInvoice
     */
    public function setFnInvToCountry($fnInvToCountry)
    {
        $this->fnInvToCountry = $fnInvToCountry;

        return $this;
    }

    /**
     * Get fnInvToCountry
     *
     * @return string
     */
    public function getFnInvToCountry()
    {
        return $this->fnInvToCountry;
    }

    /**
     * Set fnInvToPostCode
     *
     * @param string $fnInvToPostCode
     *
     * @return FnInvoice
     */
    public function setFnInvToPostCode($fnInvToPostCode)
    {
        $this->fnInvToPostCode = $fnInvToPostCode;

        return $this;
    }

    /**
     * Get fnInvToPostCode
     *
     * @return string
     */
    public function getFnInvToPostCode()
    {
        return $this->fnInvToPostCode;
    }

    /**
     * Set fnInvToStatutory1
     *
     * @param string $fnInvToStatutory1
     *
     * @return FnInvoice
     */
    public function setFnInvToStatutory1($fnInvToStatutory1)
    {
        $this->fnInvToStatutory1 = $fnInvToStatutory1;

        return $this;
    }

    /**
     * Get fnInvToStatutory1
     *
     * @return string
     */
    public function getFnInvToStatutory1()
    {
        return $this->fnInvToStatutory1;
    }

    /**
     * Set fnInvToStatutory2
     *
     * @param string $fnInvToStatutory2
     *
     * @return FnInvoice
     */
    public function setFnInvToStatutory2($fnInvToStatutory2)
    {
        $this->fnInvToStatutory2 = $fnInvToStatutory2;

        return $this;
    }

    /**
     * Get fnInvToStatutory2
     *
     * @return string
     */
    public function getFnInvToStatutory2()
    {
        return $this->fnInvToStatutory2;
    }

    /**
     * Set fnInvToStatutory3
     *
     * @param string $fnInvToStatutory3
     *
     * @return FnInvoice
     */
    public function setFnInvToStatutory3($fnInvToStatutory3)
    {
        $this->fnInvToStatutory3 = $fnInvToStatutory3;

        return $this;
    }

    /**
     * Get fnInvToStatutory3
     *
     * @return string
     */
    public function getFnInvToStatutory3()
    {
        return $this->fnInvToStatutory3;
    }

    /**
     * Set fnInvDate
     *
     * @param \DateTime $fnInvDate
     *
     * @return FnInvoice
     */
    public function setFnInvDate($fnInvDate)
    {
        $this->fnInvDate = $fnInvDate;

        return $this;
    }

    /**
     * Get fnInvDate
     *
     * @return \DateTime
     */
    public function getFnInvDate()
    {
        return $this->fnInvDate;
    }

    /**
     * Set fnInvExchRate
     *
     * @param string $fnInvExchRate
     *
     * @return FnInvoice
     */
    public function setFnInvExchRate($fnInvExchRate)
    {
        $this->fnInvExchRate = $fnInvExchRate;

        return $this;
    }

    /**
     * Get fnInvExchRate
     *
     * @return string
     */
    public function getFnInvExchRate()
    {
        return $this->fnInvExchRate;
    }

    /**
     * Set fnInvExchRateBalance
     *
     * @param string $fnInvExchRateBalance
     *
     * @return FnInvoice
     */
    public function setFnInvExchRateBalance($fnInvExchRateBalance)
    {
        $this->fnInvExchRateBalance = $fnInvExchRateBalance;

        return $this;
    }

    /**
     * Get fnInvExchRateBalance
     *
     * @return string
     */
    public function getFnInvExchRateBalance()
    {
        return $this->fnInvExchRateBalance;
    }

    /**
     * Set fnInvoicePrefix
     *
     * @param string $fnInvoicePrefix
     *
     * @return FnInvoice
     */
    public function setFnInvoicePrefix($fnInvoicePrefix)
    {
        $this->fnInvoicePrefix = $fnInvoicePrefix;

        return $this;
    }

    /**
     * Get fnInvoicePrefix
     *
     * @return string
     */
    public function getFnInvoicePrefix()
    {
        return $this->fnInvoicePrefix;
    }

    /**
     * Set fnInvPrintCount
     *
     * @param boolean $fnInvPrintCount
     *
     * @return FnInvoice
     */
    public function setFnInvPrintCount($fnInvPrintCount)
    {
        $this->fnInvPrintCount = $fnInvPrintCount;

        return $this;
    }

    /**
     * Get fnInvPrintCount
     *
     * @return boolean
     */
    public function getFnInvPrintCount()
    {
        return $this->fnInvPrintCount;
    }

    /**
     * Set fnInvStatusInd
     *
     * @param boolean $fnInvStatusInd
     *
     * @return FnInvoice
     */
    public function setFnInvStatusInd($fnInvStatusInd)
    {
        $this->fnInvStatusInd = $fnInvStatusInd;

        return $this;
    }

    /**
     * Get fnInvStatusInd
     *
     * @return boolean
     */
    public function getFnInvStatusInd()
    {
        return $this->fnInvStatusInd;
    }

    /**
     * Set fnInvTypeInd
     *
     * @param boolean $fnInvTypeInd
     *
     * @return FnInvoice
     */
    public function setFnInvTypeInd($fnInvTypeInd)
    {
        $this->fnInvTypeInd = $fnInvTypeInd;

        return $this;
    }

    /**
     * Get fnInvTypeInd
     *
     * @return boolean
     */
    public function getFnInvTypeInd()
    {
        return $this->fnInvTypeInd;
    }

    /**
     * Set fnInvReverseInd
     *
     * @param boolean $fnInvReverseInd
     *
     * @return FnInvoice
     */
    public function setFnInvReverseInd($fnInvReverseInd)
    {
        $this->fnInvReverseInd = $fnInvReverseInd;

        return $this;
    }

    /**
     * Get fnInvReverseInd
     *
     * @return boolean
     */
    public function getFnInvReverseInd()
    {
        return $this->fnInvReverseInd;
    }

    /**
     * Set fnInvReverseLinkId
     *
     * @param string $fnInvReverseLinkId
     *
     * @return FnInvoice
     */
    public function setFnInvReverseLinkId($fnInvReverseLinkId)
    {
        $this->fnInvReverseLinkId = $fnInvReverseLinkId;

        return $this;
    }

    /**
     * Get fnInvReverseLinkId
     *
     * @return string
     */
    public function getFnInvReverseLinkId()
    {
        return $this->fnInvReverseLinkId;
    }

    /**
     * Set fnInvVoidYn
     *
     * @param boolean $fnInvVoidYn
     *
     * @return FnInvoice
     */
    public function setFnInvVoidYn($fnInvVoidYn)
    {
        $this->fnInvVoidYn = $fnInvVoidYn;

        return $this;
    }

    /**
     * Get fnInvVoidYn
     *
     * @return boolean
     */
    public function getFnInvVoidYn()
    {
        return $this->fnInvVoidYn;
    }

    /**
     * Set fnInvVoidDate
     *
     * @param \DateTime $fnInvVoidDate
     *
     * @return FnInvoice
     */
    public function setFnInvVoidDate($fnInvVoidDate)
    {
        $this->fnInvVoidDate = $fnInvVoidDate;

        return $this;
    }

    /**
     * Get fnInvVoidDate
     *
     * @return \DateTime
     */
    public function getFnInvVoidDate()
    {
        return $this->fnInvVoidDate;
    }

    /**
     * Set fnInvVoidUserId
     *
     * @param string $fnInvVoidUserId
     *
     * @return FnInvoice
     */
    public function setFnInvVoidUserId($fnInvVoidUserId)
    {
        $this->fnInvVoidUserId = $fnInvVoidUserId;

        return $this;
    }

    /**
     * Get fnInvVoidUserId
     *
     * @return string
     */
    public function getFnInvVoidUserId()
    {
        return $this->fnInvVoidUserId;
    }

    /**
     * Set fnInvFrom
     *
     * @param string $fnInvFrom
     *
     * @return FnInvoice
     */
    public function setFnInvFrom($fnInvFrom)
    {
        $this->fnInvFrom = $fnInvFrom;

        return $this;
    }

    /**
     * Get fnInvFrom
     *
     * @return string
     */
    public function getFnInvFrom()
    {
        return $this->fnInvFrom;
    }

    /**
     * Set fnInvTo
     *
     * @param string $fnInvTo
     *
     * @return FnInvoice
     */
    public function setFnInvTo($fnInvTo)
    {
        $this->fnInvTo = $fnInvTo;

        return $this;
    }

    /**
     * Get fnInvTo
     *
     * @return string
     */
    public function getFnInvTo()
    {
        return $this->fnInvTo;
    }

    /**
     * Set fnFolioId
     *
     * @param string $fnFolioId
     *
     * @return FnInvoice
     */
    public function setFnFolioId($fnFolioId)
    {
        $this->fnFolioId = $fnFolioId;

        return $this;
    }

    /**
     * Get fnFolioId
     *
     * @return string
     */
    public function getFnFolioId()
    {
        return $this->fnFolioId;
    }

    /**
     * Set prBusinessId
     *
     * @param string $prBusinessId
     *
     * @return FnInvoice
     */
    public function setPrBusinessId($prBusinessId)
    {
        $this->prBusinessId = $prBusinessId;

        return $this;
    }

    /**
     * Get prBusinessId
     *
     * @return string
     */
    public function getPrBusinessId()
    {
        return $this->prBusinessId;
    }

    /**
     * Set fnPostId
     *
     * @param string $fnPostId
     *
     * @return FnInvoice
     */
    public function setFnPostId($fnPostId)
    {
        $this->fnPostId = $fnPostId;

        return $this;
    }

    /**
     * Get fnPostId
     *
     * @return string
     */
    public function getFnPostId()
    {
        return $this->fnPostId;
    }

    /**
     * Set rvReservationId
     *
     * @param string $rvReservationId
     *
     * @return FnInvoice
     */
    public function setRvReservationId($rvReservationId)
    {
        $this->rvReservationId = $rvReservationId;

        return $this;
    }

    /**
     * Get rvReservationId
     *
     * @return string
     */
    public function getRvReservationId()
    {
        return $this->rvReservationId;
    }

    /**
     * Set adCreateDate
     *
     * @param \DateTime $adCreateDate
     *
     * @return FnInvoice
     */
    public function setAdCreateDate($adCreateDate)
    {
        $this->adCreateDate = $adCreateDate;

        return $this;
    }

    /**
     * Get adCreateDate
     *
     * @return \DateTime
     */
    public function getAdCreateDate()
    {
        return $this->adCreateDate;
    }

    /**
     * Set adCreateDateTz
     *
     * @param string $adCreateDateTz
     *
     * @return FnInvoice
     */
    public function setAdCreateDateTz($adCreateDateTz)
    {
        $this->adCreateDateTz = $adCreateDateTz;

        return $this;
    }

    /**
     * Get adCreateDateTz
     *
     * @return string
     */
    public function getAdCreateDateTz()
    {
        return $this->adCreateDateTz;
    }

    /**
     * Set adCreateUserId
     *
     * @param string $adCreateUserId
     *
     * @return FnInvoice
     */
    public function setAdCreateUserId($adCreateUserId)
    {
        $this->adCreateUserId = $adCreateUserId;

        return $this;
    }

    /**
     * Get adCreateUserId
     *
     * @return string
     */
    public function getAdCreateUserId()
    {
        return $this->adCreateUserId;
    }

    /**
     * Set adModifyDate
     *
     * @param \DateTime $adModifyDate
     *
     * @return FnInvoice
     */
    public function setAdModifyDate($adModifyDate)
    {
        $this->adModifyDate = $adModifyDate;

        return $this;
    }

    /**
     * Get adModifyDate
     *
     * @return \DateTime
     */
    public function getAdModifyDate()
    {
        return $this->adModifyDate;
    }

    /**
     * Set adModifyDateTz
     *
     * @param string $adModifyDateTz
     *
     * @return FnInvoice
     */
    public function setAdModifyDateTz($adModifyDateTz)
    {
        $this->adModifyDateTz = $adModifyDateTz;

        return $this;
    }

    /**
     * Get adModifyDateTz
     *
     * @return string
     */
    public function getAdModifyDateTz()
    {
        return $this->adModifyDateTz;
    }

    /**
     * Set adModifyUserId
     *
     * @param string $adModifyUserId
     *
     * @return FnInvoice
     */
    public function setAdModifyUserId($adModifyUserId)
    {
        $this->adModifyUserId = $adModifyUserId;

        return $this;
    }

    /**
     * Get adModifyUserId
     *
     * @return string
     */
    public function getAdModifyUserId()
    {
        return $this->adModifyUserId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return FnInvoice
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set fnInvoiceTrfYn
     *
     * @param boolean $fnInvoiceTrfYn
     *
     * @return FnInvoice
     */
    public function setFnInvoiceTrfYn($fnInvoiceTrfYn)
    {
        $this->fnInvoiceTrfYn = $fnInvoiceTrfYn;

        return $this;
    }

    /**
     * Get fnInvoiceTrfYn
     *
     * @return boolean
     */
    public function getFnInvoiceTrfYn()
    {
        return $this->fnInvoiceTrfYn;
    }
}
