<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * FnInvoiceBank
 *
 * @ORM\Table(name="fn_invoice_bank", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="fn_invoice_bank_trf_yn", columns={"fn_invoice_bank_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class FnInvoiceBank
{
    /**
     * @var string
     *
     * @ORM\Column(name="fn_invoice_bank_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $fnInvoiceBankIx;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_invoice_bank_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $fnInvoiceBankDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="fn_invoice_bank_id", type="integer", nullable=false)
     */
    private $fnInvoiceBankId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_bank_acc_name", type="string", length=70, nullable=true)
     */
    private $fnInvBankAccName;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_bank_acc_no", type="string", length=50, nullable=true)
     */
    private $fnInvBankAccNo;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_bank_detail_1", type="string", length=100, nullable=true)
     */
    private $fnInvBankDetail1;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_bank_detail_2", type="string", length=100, nullable=true)
     */
    private $fnInvBankDetail2;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_bank_detail_3", type="string", length=100, nullable=true)
     */
    private $fnInvBankDetail3;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_bank_name", type="string", length=70, nullable=true)
     */
    private $fnInvBankName;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_currency_symbol", type="string", length=3, nullable=true, options={"fixed"="true"})
     */
    private $fnInvCurrencySymbol;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_invoice_id", type="string", length=18, nullable=false, options={"default"=""}))
     */
    private $fnInvoiceId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_invoice_bank_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnInvoiceBankTrfYn;



    /**
     * Get fnInvoiceBankIx
     *
     * @return string
     */
    public function getFnInvoiceBankIx()
    {
        return $this->fnInvoiceBankIx;
    }

    /**
     * Set fnInvoiceBankDb
     *
     * @param string $fnInvoiceBankDb
     *
     * @return FnInvoiceBank
     */
    public function setFnInvoiceBankDb($fnInvoiceBankDb)
    {
        $this->fnInvoiceBankDb = $fnInvoiceBankDb;

        return $this;
    }

    /**
     * Get fnInvoiceBankDb
     *
     * @return string
     */
    public function getFnInvoiceBankDb()
    {
        return $this->fnInvoiceBankDb;
    }

    /**
     * Set fnInvoiceBankId
     *
     * @param integer $fnInvoiceBankId
     *
     * @return FnInvoiceBank
     */
    public function setFnInvoiceBankId($fnInvoiceBankId)
    {
        $this->fnInvoiceBankId = $fnInvoiceBankId;

        return $this;
    }

    /**
     * Get fnInvoiceBankId
     *
     * @return integer
     */
    public function getFnInvoiceBankId()
    {
        return $this->fnInvoiceBankId;
    }

    /**
     * Set fnInvBankAccName
     *
     * @param string $fnInvBankAccName
     *
     * @return FnInvoiceBank
     */
    public function setFnInvBankAccName($fnInvBankAccName)
    {
        $this->fnInvBankAccName = $fnInvBankAccName;

        return $this;
    }

    /**
     * Get fnInvBankAccName
     *
     * @return string
     */
    public function getFnInvBankAccName()
    {
        return $this->fnInvBankAccName;
    }

    /**
     * Set fnInvBankAccNo
     *
     * @param string $fnInvBankAccNo
     *
     * @return FnInvoiceBank
     */
    public function setFnInvBankAccNo($fnInvBankAccNo)
    {
        $this->fnInvBankAccNo = $fnInvBankAccNo;

        return $this;
    }

    /**
     * Get fnInvBankAccNo
     *
     * @return string
     */
    public function getFnInvBankAccNo()
    {
        return $this->fnInvBankAccNo;
    }

    /**
     * Set fnInvBankDetail1
     *
     * @param string $fnInvBankDetail1
     *
     * @return FnInvoiceBank
     */
    public function setFnInvBankDetail1($fnInvBankDetail1)
    {
        $this->fnInvBankDetail1 = $fnInvBankDetail1;

        return $this;
    }

    /**
     * Get fnInvBankDetail1
     *
     * @return string
     */
    public function getFnInvBankDetail1()
    {
        return $this->fnInvBankDetail1;
    }

    /**
     * Set fnInvBankDetail2
     *
     * @param string $fnInvBankDetail2
     *
     * @return FnInvoiceBank
     */
    public function setFnInvBankDetail2($fnInvBankDetail2)
    {
        $this->fnInvBankDetail2 = $fnInvBankDetail2;

        return $this;
    }

    /**
     * Get fnInvBankDetail2
     *
     * @return string
     */
    public function getFnInvBankDetail2()
    {
        return $this->fnInvBankDetail2;
    }

    /**
     * Set fnInvBankDetail3
     *
     * @param string $fnInvBankDetail3
     *
     * @return FnInvoiceBank
     */
    public function setFnInvBankDetail3($fnInvBankDetail3)
    {
        $this->fnInvBankDetail3 = $fnInvBankDetail3;

        return $this;
    }

    /**
     * Get fnInvBankDetail3
     *
     * @return string
     */
    public function getFnInvBankDetail3()
    {
        return $this->fnInvBankDetail3;
    }

    /**
     * Set fnInvBankName
     *
     * @param string $fnInvBankName
     *
     * @return FnInvoiceBank
     */
    public function setFnInvBankName($fnInvBankName)
    {
        $this->fnInvBankName = $fnInvBankName;

        return $this;
    }

    /**
     * Get fnInvBankName
     *
     * @return string
     */
    public function getFnInvBankName()
    {
        return $this->fnInvBankName;
    }

    /**
     * Set fnInvCurrencySymbol
     *
     * @param string $fnInvCurrencySymbol
     *
     * @return FnInvoiceBank
     */
    public function setFnInvCurrencySymbol($fnInvCurrencySymbol)
    {
        $this->fnInvCurrencySymbol = $fnInvCurrencySymbol;

        return $this;
    }

    /**
     * Get fnInvCurrencySymbol
     *
     * @return string
     */
    public function getFnInvCurrencySymbol()
    {
        return $this->fnInvCurrencySymbol;
    }

    /**
     * Set fnInvoiceId
     *
     * @param string $fnInvoiceId
     *
     * @return FnInvoiceBank
     */
    public function setFnInvoiceId($fnInvoiceId)
    {
        $this->fnInvoiceId = $fnInvoiceId;

        return $this;
    }

    /**
     * Get fnInvoiceId
     *
     * @return string
     */
    public function getFnInvoiceId()
    {
        return $this->fnInvoiceId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return FnInvoiceBank
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set fnInvoiceBankTrfYn
     *
     * @param boolean $fnInvoiceBankTrfYn
     *
     * @return FnInvoiceBank
     */
    public function setFnInvoiceBankTrfYn($fnInvoiceBankTrfYn)
    {
        $this->fnInvoiceBankTrfYn = $fnInvoiceBankTrfYn;

        return $this;
    }

    /**
     * Get fnInvoiceBankTrfYn
     *
     * @return boolean
     */
    public function getFnInvoiceBankTrfYn()
    {
        return $this->fnInvoiceBankTrfYn;
    }
}
