<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * FnInvoiceItem
 *
 * @ORM\Table(name="fn_invoice_item", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="fn_invoice_item_trf_yn", columns={"fn_invoice_item_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"}), @ORM\Index(name="fn_invoice_id", columns={"fn_invoice_id"})})
 * @ORM\Entity
 */
class FnInvoiceItem
{
    /**
     * @var string
     *
     * @ORM\Column(name="fn_invoice_item_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $fnInvoiceItemIx;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_invoice_item_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $fnInvoiceItemDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="fn_invoice_item_id", type="integer", nullable=false)
     */
    private $fnInvoiceItemId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_item_amount", type="decimal", precision=16, scale=2, nullable=true)
     */
    private $fnInvItemAmount;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_item_amt_comm", type="decimal", precision=16, scale=2, nullable=true)
     */
    private $fnInvItemAmtComm;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_item_amt_tax", type="decimal", precision=16, scale=6, nullable=true)
     */
    private $fnInvItemAmtTax;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_item_comm_perc", type="decimal", precision=16, scale=2, nullable=true)
     */
    private $fnInvItemCommPerc;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="fn_inv_item_date", type="date", nullable=false, options={"default"="0000-00-00"})
     */
    private $fnInvItemDate;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_item_desc", type="string", length=50, nullable=true)
     */
    private $fnInvItemDesc;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_item_tax_desc", type="string", length=50, nullable=true)
     */
    private $fnInvItemTaxDesc;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_item_tax_perc", type="decimal", precision=16, scale=2, nullable=true)
     */
    private $fnInvItemTaxPerc;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_inv_item_type", type="boolean", nullable=true)
     */
    private $fnInvItemType;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_invoice_id", type="string", length=18, nullable=true)
     */
    private $fnInvoiceId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_ledger_id", type="string", length=36, nullable=true)
     */
    private $fnLedgerId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_invoice_item_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnInvoiceItemTrfYn;



    /**
     * Get fnInvoiceItemIx
     *
     * @return string
     */
    public function getFnInvoiceItemIx()
    {
        return $this->fnInvoiceItemIx;
    }

    /**
     * Set fnInvoiceItemDb
     *
     * @param string $fnInvoiceItemDb
     *
     * @return FnInvoiceItem
     */
    public function setFnInvoiceItemDb($fnInvoiceItemDb)
    {
        $this->fnInvoiceItemDb = $fnInvoiceItemDb;

        return $this;
    }

    /**
     * Get fnInvoiceItemDb
     *
     * @return string
     */
    public function getFnInvoiceItemDb()
    {
        return $this->fnInvoiceItemDb;
    }

    /**
     * Set fnInvoiceItemId
     *
     * @param integer $fnInvoiceItemId
     *
     * @return FnInvoiceItem
     */
    public function setFnInvoiceItemId($fnInvoiceItemId)
    {
        $this->fnInvoiceItemId = $fnInvoiceItemId;

        return $this;
    }

    /**
     * Get fnInvoiceItemId
     *
     * @return integer
     */
    public function getFnInvoiceItemId()
    {
        return $this->fnInvoiceItemId;
    }

    /**
     * Set fnInvItemAmount
     *
     * @param string $fnInvItemAmount
     *
     * @return FnInvoiceItem
     */
    public function setFnInvItemAmount($fnInvItemAmount)
    {
        $this->fnInvItemAmount = $fnInvItemAmount;

        return $this;
    }

    /**
     * Get fnInvItemAmount
     *
     * @return string
     */
    public function getFnInvItemAmount()
    {
        return $this->fnInvItemAmount;
    }

    /**
     * Set fnInvItemAmtComm
     *
     * @param string $fnInvItemAmtComm
     *
     * @return FnInvoiceItem
     */
    public function setFnInvItemAmtComm($fnInvItemAmtComm)
    {
        $this->fnInvItemAmtComm = $fnInvItemAmtComm;

        return $this;
    }

    /**
     * Get fnInvItemAmtComm
     *
     * @return string
     */
    public function getFnInvItemAmtComm()
    {
        return $this->fnInvItemAmtComm;
    }

    /**
     * Set fnInvItemAmtTax
     *
     * @param string $fnInvItemAmtTax
     *
     * @return FnInvoiceItem
     */
    public function setFnInvItemAmtTax($fnInvItemAmtTax)
    {
        $this->fnInvItemAmtTax = $fnInvItemAmtTax;

        return $this;
    }

    /**
     * Get fnInvItemAmtTax
     *
     * @return string
     */
    public function getFnInvItemAmtTax()
    {
        return $this->fnInvItemAmtTax;
    }

    /**
     * Set fnInvItemCommPerc
     *
     * @param string $fnInvItemCommPerc
     *
     * @return FnInvoiceItem
     */
    public function setFnInvItemCommPerc($fnInvItemCommPerc)
    {
        $this->fnInvItemCommPerc = $fnInvItemCommPerc;

        return $this;
    }

    /**
     * Get fnInvItemCommPerc
     *
     * @return string
     */
    public function getFnInvItemCommPerc()
    {
        return $this->fnInvItemCommPerc;
    }

    /**
     * Set fnInvItemDate
     *
     * @param \DateTime $fnInvItemDate
     *
     * @return FnInvoiceItem
     */
    public function setFnInvItemDate($fnInvItemDate)
    {
        $this->fnInvItemDate = $fnInvItemDate;

        return $this;
    }

    /**
     * Get fnInvItemDate
     *
     * @return \DateTime
     */
    public function getFnInvItemDate()
    {
        return $this->fnInvItemDate;
    }

    /**
     * Set fnInvItemDesc
     *
     * @param string $fnInvItemDesc
     *
     * @return FnInvoiceItem
     */
    public function setFnInvItemDesc($fnInvItemDesc)
    {
        $this->fnInvItemDesc = $fnInvItemDesc;

        return $this;
    }

    /**
     * Get fnInvItemDesc
     *
     * @return string
     */
    public function getFnInvItemDesc()
    {
        return $this->fnInvItemDesc;
    }

    /**
     * Set fnInvItemTaxDesc
     *
     * @param string $fnInvItemTaxDesc
     *
     * @return FnInvoiceItem
     */
    public function setFnInvItemTaxDesc($fnInvItemTaxDesc)
    {
        $this->fnInvItemTaxDesc = $fnInvItemTaxDesc;

        return $this;
    }

    /**
     * Get fnInvItemTaxDesc
     *
     * @return string
     */
    public function getFnInvItemTaxDesc()
    {
        return $this->fnInvItemTaxDesc;
    }

    /**
     * Set fnInvItemTaxPerc
     *
     * @param string $fnInvItemTaxPerc
     *
     * @return FnInvoiceItem
     */
    public function setFnInvItemTaxPerc($fnInvItemTaxPerc)
    {
        $this->fnInvItemTaxPerc = $fnInvItemTaxPerc;

        return $this;
    }

    /**
     * Get fnInvItemTaxPerc
     *
     * @return string
     */
    public function getFnInvItemTaxPerc()
    {
        return $this->fnInvItemTaxPerc;
    }

    /**
     * Set fnInvItemType
     *
     * @param boolean $fnInvItemType
     *
     * @return FnInvoiceItem
     */
    public function setFnInvItemType($fnInvItemType)
    {
        $this->fnInvItemType = $fnInvItemType;

        return $this;
    }

    /**
     * Get fnInvItemType
     *
     * @return boolean
     */
    public function getFnInvItemType()
    {
        return $this->fnInvItemType;
    }

    /**
     * Set fnInvoiceId
     *
     * @param string $fnInvoiceId
     *
     * @return FnInvoiceItem
     */
    public function setFnInvoiceId($fnInvoiceId)
    {
        $this->fnInvoiceId = $fnInvoiceId;

        return $this;
    }

    /**
     * Get fnInvoiceId
     *
     * @return string
     */
    public function getFnInvoiceId()
    {
        return $this->fnInvoiceId;
    }

    /**
     * Set fnLedgerId
     *
     * @param string $fnLedgerId
     *
     * @return FnInvoiceItem
     */
    public function setFnLedgerId($fnLedgerId)
    {
        $this->fnLedgerId = $fnLedgerId;

        return $this;
    }

    /**
     * Get fnLedgerId
     *
     * @return string
     */
    public function getFnLedgerId()
    {
        return $this->fnLedgerId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return FnInvoiceItem
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set fnInvoiceItemTrfYn
     *
     * @param boolean $fnInvoiceItemTrfYn
     *
     * @return FnInvoiceItem
     */
    public function setFnInvoiceItemTrfYn($fnInvoiceItemTrfYn)
    {
        $this->fnInvoiceItemTrfYn = $fnInvoiceItemTrfYn;

        return $this;
    }

    /**
     * Get fnInvoiceItemTrfYn
     *
     * @return boolean
     */
    public function getFnInvoiceItemTrfYn()
    {
        return $this->fnInvoiceItemTrfYn;
    }
}
