<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * FnInvoiceItemTax
 *
 * @ORM\Table(name="fn_invoice_item_tax", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="fn_invoice_item_tax_trf_yn", columns={"fn_invoice_item_tax_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"}), @ORM\Index(name="rf_tax_rate_id", columns={"rf_tax_rate_id"}), @ORM\Index(name="fn_invoice_item_id", columns={"fn_invoice_item_id"})})
 * @ORM\Entity
 */
class FnInvoiceItemTax
{
    /**
     * @var string
     *
     * @ORM\Column(name="fn_invoice_item_tax_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $fnInvoiceItemTaxIx;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_invoice_item_tax_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $fnInvoiceItemTaxDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="fn_invoice_item_tax_id", type="integer", nullable=false)
     */
    private $fnInvoiceItemTaxId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_invoice_item_tax_amt", type="decimal", precision=16, scale=6, nullable=true)
     */
    private $fnInvoiceItemTaxAmt;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_invoice_item_tax_perc", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.00"})
     */
    private $fnInvoiceItemTaxPerc;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_invoice_item_tax_desc", type="string", length=50, nullable=true)
     */
    private $fnInvoiceItemTaxDesc;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_invoice_item_tax_seq", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnInvoiceItemTaxSeq;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_invoice_item_tax_inactive_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnInvoiceItemTaxInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_tax_rate_id", type="string", length=36, nullable=true)
     */
    private $rfTaxRateId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_invoice_item_id", type="string", length=36, nullable=true)
     */
    private $fnInvoiceItemId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_invoice_item_tax_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnInvoiceItemTaxTrfYn;



    /**
     * Get fnInvoiceItemTaxIx
     *
     * @return string
     */
    public function getFnInvoiceItemTaxIx()
    {
        return $this->fnInvoiceItemTaxIx;
    }

    /**
     * Set fnInvoiceItemTaxDb
     *
     * @param string $fnInvoiceItemTaxDb
     *
     * @return FnInvoiceItemTax
     */
    public function setFnInvoiceItemTaxDb($fnInvoiceItemTaxDb)
    {
        $this->fnInvoiceItemTaxDb = $fnInvoiceItemTaxDb;

        return $this;
    }

    /**
     * Get fnInvoiceItemTaxDb
     *
     * @return string
     */
    public function getFnInvoiceItemTaxDb()
    {
        return $this->fnInvoiceItemTaxDb;
    }

    /**
     * Set fnInvoiceItemTaxId
     *
     * @param integer $fnInvoiceItemTaxId
     *
     * @return FnInvoiceItemTax
     */
    public function setFnInvoiceItemTaxId($fnInvoiceItemTaxId)
    {
        $this->fnInvoiceItemTaxId = $fnInvoiceItemTaxId;

        return $this;
    }

    /**
     * Get fnInvoiceItemTaxId
     *
     * @return integer
     */
    public function getFnInvoiceItemTaxId()
    {
        return $this->fnInvoiceItemTaxId;
    }

    /**
     * Set fnInvoiceItemTaxAmt
     *
     * @param string $fnInvoiceItemTaxAmt
     *
     * @return FnInvoiceItemTax
     */
    public function setFnInvoiceItemTaxAmt($fnInvoiceItemTaxAmt)
    {
        $this->fnInvoiceItemTaxAmt = $fnInvoiceItemTaxAmt;

        return $this;
    }

    /**
     * Get fnInvoiceItemTaxAmt
     *
     * @return string
     */
    public function getFnInvoiceItemTaxAmt()
    {
        return $this->fnInvoiceItemTaxAmt;
    }

    /**
     * Set fnInvoiceItemTaxPerc
     *
     * @param string $fnInvoiceItemTaxPerc
     *
     * @return FnInvoiceItemTax
     */
    public function setFnInvoiceItemTaxPerc($fnInvoiceItemTaxPerc)
    {
        $this->fnInvoiceItemTaxPerc = $fnInvoiceItemTaxPerc;

        return $this;
    }

    /**
     * Get fnInvoiceItemTaxPerc
     *
     * @return string
     */
    public function getFnInvoiceItemTaxPerc()
    {
        return $this->fnInvoiceItemTaxPerc;
    }

    /**
     * Set fnInvoiceItemTaxDesc
     *
     * @param string $fnInvoiceItemTaxDesc
     *
     * @return FnInvoiceItemTax
     */
    public function setFnInvoiceItemTaxDesc($fnInvoiceItemTaxDesc)
    {
        $this->fnInvoiceItemTaxDesc = $fnInvoiceItemTaxDesc;

        return $this;
    }

    /**
     * Get fnInvoiceItemTaxDesc
     *
     * @return string
     */
    public function getFnInvoiceItemTaxDesc()
    {
        return $this->fnInvoiceItemTaxDesc;
    }

    /**
     * Set fnInvoiceItemTaxSeq
     *
     * @param boolean $fnInvoiceItemTaxSeq
     *
     * @return FnInvoiceItemTax
     */
    public function setFnInvoiceItemTaxSeq($fnInvoiceItemTaxSeq)
    {
        $this->fnInvoiceItemTaxSeq = $fnInvoiceItemTaxSeq;

        return $this;
    }

    /**
     * Get fnInvoiceItemTaxSeq
     *
     * @return boolean
     */
    public function getFnInvoiceItemTaxSeq()
    {
        return $this->fnInvoiceItemTaxSeq;
    }

    /**
     * Set fnInvoiceItemTaxInactiveYn
     *
     * @param boolean $fnInvoiceItemTaxInactiveYn
     *
     * @return FnInvoiceItemTax
     */
    public function setFnInvoiceItemTaxInactiveYn($fnInvoiceItemTaxInactiveYn)
    {
        $this->fnInvoiceItemTaxInactiveYn = $fnInvoiceItemTaxInactiveYn;

        return $this;
    }

    /**
     * Get fnInvoiceItemTaxInactiveYn
     *
     * @return boolean
     */
    public function getFnInvoiceItemTaxInactiveYn()
    {
        return $this->fnInvoiceItemTaxInactiveYn;
    }

    /**
     * Set rfTaxRateId
     *
     * @param string $rfTaxRateId
     *
     * @return FnInvoiceItemTax
     */
    public function setRfTaxRateId($rfTaxRateId)
    {
        $this->rfTaxRateId = $rfTaxRateId;

        return $this;
    }

    /**
     * Get rfTaxRateId
     *
     * @return string
     */
    public function getRfTaxRateId()
    {
        return $this->rfTaxRateId;
    }

    /**
     * Set fnInvoiceItemId
     *
     * @param string $fnInvoiceItemId
     *
     * @return FnInvoiceItemTax
     */
    public function setFnInvoiceItemId($fnInvoiceItemId)
    {
        $this->fnInvoiceItemId = $fnInvoiceItemId;

        return $this;
    }

    /**
     * Get fnInvoiceItemId
     *
     * @return string
     */
    public function getFnInvoiceItemId()
    {
        return $this->fnInvoiceItemId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return FnInvoiceItemTax
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set fnInvoiceItemTaxTrfYn
     *
     * @param boolean $fnInvoiceItemTaxTrfYn
     *
     * @return FnInvoiceItemTax
     */
    public function setFnInvoiceItemTaxTrfYn($fnInvoiceItemTaxTrfYn)
    {
        $this->fnInvoiceItemTaxTrfYn = $fnInvoiceItemTaxTrfYn;

        return $this;
    }

    /**
     * Get fnInvoiceItemTaxTrfYn
     *
     * @return boolean
     */
    public function getFnInvoiceItemTaxTrfYn()
    {
        return $this->fnInvoiceItemTaxTrfYn;
    }
}
