<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * FnInvoiceNote
 *
 * @ORM\Table(name="fn_invoice_note", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="fn_invoice_note_trf_yn", columns={"fn_invoice_note_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"}), @ORM\Index(name="fn_invoice_id", columns={"fn_invoice_id"})})
 * @ORM\Entity
 */
class FnInvoiceNote
{
    /**
     * @var string
     *
     * @ORM\Column(name="fn_invoice_note_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $fnInvoiceNoteIx;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_invoice_note_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $fnInvoiceNoteDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="fn_invoice_note_id", type="integer", nullable=false)
     */
    private $fnInvoiceNoteId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_note_content", type="text", length=65535, nullable=true)
     */
    private $fnInvNoteContent;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_note_hdg", type="string", length=30, nullable=true)
     */
    private $fnInvNoteHdg;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_invoice_id", type="string", length=36, nullable=true)
     */
    private $fnInvoiceId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_invoice_note_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnInvoiceNoteTrfYn;



    /**
     * Get fnInvoiceNoteIx
     *
     * @return string
     */
    public function getFnInvoiceNoteIx()
    {
        return $this->fnInvoiceNoteIx;
    }

    /**
     * Set fnInvoiceNoteDb
     *
     * @param string $fnInvoiceNoteDb
     *
     * @return FnInvoiceNote
     */
    public function setFnInvoiceNoteDb($fnInvoiceNoteDb)
    {
        $this->fnInvoiceNoteDb = $fnInvoiceNoteDb;

        return $this;
    }

    /**
     * Get fnInvoiceNoteDb
     *
     * @return string
     */
    public function getFnInvoiceNoteDb()
    {
        return $this->fnInvoiceNoteDb;
    }

    /**
     * Set fnInvoiceNoteId
     *
     * @param integer $fnInvoiceNoteId
     *
     * @return FnInvoiceNote
     */
    public function setFnInvoiceNoteId($fnInvoiceNoteId)
    {
        $this->fnInvoiceNoteId = $fnInvoiceNoteId;

        return $this;
    }

    /**
     * Get fnInvoiceNoteId
     *
     * @return integer
     */
    public function getFnInvoiceNoteId()
    {
        return $this->fnInvoiceNoteId;
    }

    /**
     * Set fnInvNoteContent
     *
     * @param string $fnInvNoteContent
     *
     * @return FnInvoiceNote
     */
    public function setFnInvNoteContent($fnInvNoteContent)
    {
        $this->fnInvNoteContent = $fnInvNoteContent;

        return $this;
    }

    /**
     * Get fnInvNoteContent
     *
     * @return string
     */
    public function getFnInvNoteContent()
    {
        return $this->fnInvNoteContent;
    }

    /**
     * Set fnInvNoteHdg
     *
     * @param string $fnInvNoteHdg
     *
     * @return FnInvoiceNote
     */
    public function setFnInvNoteHdg($fnInvNoteHdg)
    {
        $this->fnInvNoteHdg = $fnInvNoteHdg;

        return $this;
    }

    /**
     * Get fnInvNoteHdg
     *
     * @return string
     */
    public function getFnInvNoteHdg()
    {
        return $this->fnInvNoteHdg;
    }

    /**
     * Set fnInvoiceId
     *
     * @param string $fnInvoiceId
     *
     * @return FnInvoiceNote
     */
    public function setFnInvoiceId($fnInvoiceId)
    {
        $this->fnInvoiceId = $fnInvoiceId;

        return $this;
    }

    /**
     * Get fnInvoiceId
     *
     * @return string
     */
    public function getFnInvoiceId()
    {
        return $this->fnInvoiceId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return FnInvoiceNote
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set fnInvoiceNoteTrfYn
     *
     * @param boolean $fnInvoiceNoteTrfYn
     *
     * @return FnInvoiceNote
     */
    public function setFnInvoiceNoteTrfYn($fnInvoiceNoteTrfYn)
    {
        $this->fnInvoiceNoteTrfYn = $fnInvoiceNoteTrfYn;

        return $this;
    }

    /**
     * Get fnInvoiceNoteTrfYn
     *
     * @return boolean
     */
    public function getFnInvoiceNoteTrfYn()
    {
        return $this->fnInvoiceNoteTrfYn;
    }
}
